/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.OutputStreamToAsyncBinaryAdapter;
import org.glassfish.tyrus.SendCompletionAdapter;
import org.glassfish.tyrus.SessionImpl;
import org.glassfish.tyrus.WriterToAsyncTextAdapter;

public final class RemoteEndpointWrapper
implements RemoteEndpoint {
    private final RemoteEndpoint remoteEndpoint;
    private final SessionImpl session;
    private final EndpointWrapper endpointWrapper;

    RemoteEndpointWrapper(SessionImpl session, RemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper) {
        this.remoteEndpoint = remoteEndpoint;
        this.endpointWrapper = endpointWrapper;
        this.session = session;
    }

    public void sendString(String data) throws IOException {
        this.remoteEndpoint.sendString(data);
        this.session.updateLastConnectionActivity();
    }

    public void sendBytes(ByteBuffer data) throws IOException {
        this.remoteEndpoint.sendBytes(data);
        this.session.updateLastConnectionActivity();
    }

    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        this.remoteEndpoint.sendPartialString(fragment, isLast);
        this.session.updateLastConnectionActivity();
    }

    public void sendPartialBytes(ByteBuffer byteBuffer, boolean isLast) throws IOException {
        this.remoteEndpoint.sendPartialBytes(byteBuffer, isLast);
        this.session.updateLastConnectionActivity();
    }

    public OutputStream getSendStream() throws IOException {
        return new OutputStreamToAsyncBinaryAdapter(this);
    }

    public Writer getSendWriter() throws IOException {
        return new WriterToAsyncTextAdapter(this);
    }

    public void sendObject(Object o) throws IOException, EncodeException {
        this.session.updateLastConnectionActivity();
        this.sendPolymorphic(o);
    }

    public void sendStringByCompletion(String s, SendHandler sendHandler) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.TEXT);
        goesAway.send(s, sendHandler);
        this.session.updateLastConnectionActivity();
    }

    public Future<SendResult> sendStringByFuture(String s) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.TEXT);
        Future<SendResult> fsr = goesAway.send(s, null);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    public Future<SendResult> sendBytesByFuture(ByteBuffer byteBuffer) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
        Future<SendResult> fsr = goesAway.send(byteBuffer, null);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    public void sendBytesByCompletion(ByteBuffer byteBuffer, SendHandler sendHandler) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
        goesAway.send(byteBuffer, sendHandler);
        this.session.updateLastConnectionActivity();
    }

    public Future<SendResult> sendObjectByFuture(Object t) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.OBJECT);
        Future<SendResult> fsr = goesAway.send(t, null);
        this.session.updateLastConnectionActivity();
        return fsr;
    }

    public void sendObjectByCompletion(Object t, SendHandler sendHandler) {
        SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
        goesAway.send(t, sendHandler);
        this.session.updateLastConnectionActivity();
    }

    public void sendPing(ByteBuffer applicationData) {
        this.remoteEndpoint.sendPing(applicationData);
        this.session.updateLastConnectionActivity();
    }

    public void sendPong(ByteBuffer applicationData) {
        this.remoteEndpoint.sendPong(applicationData);
        this.session.updateLastConnectionActivity();
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    private void sendPrimitiveMessage(Object data) throws IOException, EncodeException {
        if (!this.isPrimitiveData(data)) {
            throw new EncodeException(data, "Object " + data + " is not a primitive type.");
        }
        this.sendString(data.toString());
    }

    private void sendPolymorphic(Object o) throws IOException, EncodeException {
        if (o instanceof String) {
            this.sendString((String)o);
        } else if (this.isPrimitiveData(o)) {
            this.sendPrimitiveMessage(o);
        } else {
            Object toSend = this.endpointWrapper.doEncode(o);
            if (toSend instanceof String) {
                this.sendString((String)toSend);
            } else if (toSend instanceof ByteBuffer) {
                this.sendBytes((ByteBuffer)toSend);
            } else if (toSend instanceof StringWriter) {
                StringWriter writer = (StringWriter)toSend;
                StringBuffer sb = writer.getBuffer();
                this.sendString(sb.toString());
            } else if (toSend instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
                this.sendBytes(buffer);
            }
        }
    }

    private boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        return dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
    }

    public void close(CloseReason cr) throws IOException {
        System.out.println("Close  public void close(CloseReason cr): " + cr);
    }

    public Session getSession() {
        return this.session;
    }

    public void updateLastConnectionActivity() {
        this.session.updateLastConnectionActivity();
    }
}

