/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.glassfish.tyrus.core.DefaultComponentProvider;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.ServiceFinder;
import org.glassfish.tyrus.spi.ComponentProvider;

public class ComponentProviderService {
    private volatile Map<Session, Map<Class<?>, Object>> sessionToObject;
    private final List<ComponentProvider> providers;

    public static ComponentProviderService create() {
        ArrayList<ComponentProvider> foundProviders = new ArrayList<ComponentProvider>();
        ServiceFinder<ComponentProvider> finder = ServiceFinder.find(ComponentProvider.class);
        for (ComponentProvider componentProvider : finder) {
            foundProviders.add(componentProvider);
        }
        foundProviders.add(new DefaultComponentProvider());
        return new ComponentProviderService(Collections.unmodifiableList(foundProviders));
    }

    private ComponentProviderService(List<ComponentProvider> providers) {
        this.providers = providers;
        this.sessionToObject = new ConcurrentHashMap();
    }

    public ComponentProviderService(ComponentProviderService componentProviderService) {
        this.providers = componentProviderService.providers;
        this.sessionToObject = componentProviderService.sessionToObject;
    }

    public <T> T getInstance(Class<T> c, Session session, ErrorCollector collector) {
        Object loaded = null;
        Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
        if (classObjectMap != null && classObjectMap.containsKey(c)) {
            Object fromMap = classObjectMap.get(c);
            loaded = c.isAssignableFrom(fromMap.getClass()) ? fromMap : null;
        } else {
            try {
                loaded = this.getEndpointInstance(c);
                if (classObjectMap == null) {
                    this.sessionToObject.put(session, new HashMap());
                }
                this.sessionToObject.get(session).put(c, loaded);
            }
            catch (Exception e) {
                collector.addException((Exception)new DeploymentException(String.format("Component provider threw exception when providing instance of class %s", c.getName()), (Throwable)e));
            }
        }
        return (T)loaded;
    }

    public <T> T getCoderInstance(Class<T> c, Session session, EndpointConfig endpointConfig, ErrorCollector collector) {
        Object loaded = null;
        Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
        if (classObjectMap != null && classObjectMap.containsKey(c)) {
            Object fromMap = classObjectMap.get(c);
            loaded = c.isAssignableFrom(fromMap.getClass()) ? fromMap : null;
        } else {
            for (ComponentProvider componentProvider : this.providers) {
                if (!componentProvider.isApplicable(c)) continue;
                try {
                    loaded = componentProvider.provideInstance(c);
                    if (loaded == null) continue;
                    if (loaded instanceof Encoder) {
                        ((Encoder)loaded).init(endpointConfig);
                    } else if (loaded instanceof Decoder) {
                        ((Decoder)loaded).init(endpointConfig);
                    }
                    if (classObjectMap == null) {
                        this.sessionToObject.put(session, new HashMap());
                    }
                    this.sessionToObject.get(session).put(c, loaded);
                    break;
                }
                catch (Exception e) {
                    collector.addException((Exception)new DeploymentException(String.format("Component provider %s threw exception when providing instance of class %s", componentProvider.getClass().getName(), c.getName()), (Throwable)e));
                }
            }
        }
        return (T)loaded;
    }

    public void removeSession(Session session) {
        Map<Class<?>, Object> classObjectMap = this.sessionToObject.get(session);
        if (classObjectMap != null) {
            for (Object o : classObjectMap.values()) {
                if (o instanceof Encoder) {
                    ((Encoder)o).destroy();
                } else if (o instanceof Decoder) {
                    ((Decoder)o).destroy();
                }
                for (ComponentProvider componentProvider : this.providers) {
                    if (componentProvider.destroyInstance(o)) break;
                }
            }
        }
        this.sessionToObject.remove(session);
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        for (ComponentProvider componentProvider : this.providers) {
            Object t;
            if (!componentProvider.isApplicable(endpointClass) || (t = componentProvider.provideInstance(endpointClass)) == null) continue;
            return (T)t;
        }
        throw new InstantiationException(String.format("Component provider for class %s not found.", endpointClass.getName()));
    }
}

