/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.BufferedInputStream;
import org.glassfish.tyrus.core.MessageTooBigException;

class InputStreamBuffer {
    private List<ByteBuffer> bufferedFragments = new ArrayList<ByteBuffer>();
    private boolean receivedLast = false;
    private BufferedInputStream inputStream = null;
    private MessageHandler.Whole<InputStream> messageHandler;
    private final Object lock;
    private int bufferSize;
    private int currentlyBuffered;
    private static final Logger LOGGER = Logger.getLogger(InputStreamBuffer.class.getName());
    private final ExecutorService executorService;

    public InputStreamBuffer(ExecutorService executorService) {
        this.executorService = executorService;
        this.lock = new Object();
        this.currentlyBuffered = 0;
    }

    private void blockOnReaderThread() {
        try {
            this.lock.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getNextByte() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferedFragments.isEmpty()) {
                if (this.receivedLast) {
                    this.inputStream = null;
                    this.currentlyBuffered = 0;
                    return -1;
                }
                this.blockOnReaderThread();
            }
            if (this.bufferedFragments.size() == 1 && !this.bufferedFragments.get(0).hasRemaining() && this.receivedLast) {
                this.inputStream = null;
                this.currentlyBuffered = 0;
                return -1;
            }
            ByteBuffer firstBuffer = this.bufferedFragments.get(0);
            byte result = firstBuffer.get();
            if (!firstBuffer.hasRemaining()) {
                this.bufferedFragments.remove(0);
            }
            return result;
        }
    }

    public void finishReading() {
        this.bufferedFragments = new ArrayList<ByteBuffer>();
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(ByteBuffer message, boolean last) {
        Object object = this.lock;
        synchronized (object) {
            this.currentlyBuffered += message.remaining();
            if (this.currentlyBuffered > this.bufferSize) {
                MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
                LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.bufferedFragments.add(message);
            this.receivedLast = last;
            this.lock.notifyAll();
        }
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(this);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    InputStreamBuffer.this.messageHandler.onMessage((Object)InputStreamBuffer.this.inputStream);
                }
            });
        }
    }

    public void setMessageHandler(MessageHandler.Whole<InputStream> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentlyBuffered = 0;
        this.bufferedFragments.clear();
    }
}

