/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.Decoder;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.AsyncMessageHandler;
import org.glassfish.tyrus.core.BasicMessageHandler;
import org.glassfish.tyrus.core.CoderWrapper;
import org.glassfish.tyrus.core.ReflectionHelper;

class MessageHandlerManager {
    private static final List<Class<?>> WHOLE_TEXT_HANDLER_TYPES = Arrays.asList(String.class, Reader.class);
    private static final Class<?> PARTIAL_TEXT_HANDLER_TYPE = String.class;
    private static final List<Class<?>> WHOLE_BINARY_HANDLER_TYPES = Arrays.asList(ByteBuffer.class, InputStream.class, byte[].class);
    private static final List<Class<?>> PARTIAL_BINARY_HANDLER_TYPES = Arrays.asList(ByteBuffer.class, byte[].class);
    private static final Class<?> PONG_HANDLER_TYPE = PongMessage.class;
    private boolean textHandlerPresent = false;
    private boolean textWholeHandlerPresent = false;
    private boolean binaryHandlerPresent = false;
    private boolean binaryWholeHandlerPresent = false;
    private boolean pongHandlerPresent = false;
    private boolean readerHandlerPresent = false;
    private boolean inputStreamHandlerPresent = false;
    private final Map<Class<?>, MessageHandler> registeredHandlers = new HashMap();
    private final List<Class<? extends Decoder>> decoders;
    private Set<MessageHandler> messageHandlerCache;

    MessageHandlerManager() {
        this(Collections.emptyList());
    }

    MessageHandlerManager(List<Class<? extends Decoder>> decoders) {
        this.decoders = decoders;
    }

    static MessageHandlerManager fromDecoderInstances(List<Decoder> decoders) {
        ArrayList<Class<? extends Decoder>> decoderList = new ArrayList<Class<? extends Decoder>>();
        for (Decoder decoder : decoders) {
            if (decoder instanceof CoderWrapper) {
                decoderList.add(((CoderWrapper)decoder).getCoderClass());
                continue;
            }
            decoderList.add(decoder.getClass());
        }
        return new MessageHandlerManager(decoderList);
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        if (!(handler instanceof MessageHandler.Whole) && !(handler instanceof MessageHandler.Partial)) {
            this.throwException("MessageHandler must implement MessageHandler.Whole or MessageHandler.Partial.");
        }
        Class<?> handlerClass = MessageHandlerManager.getHandlerType(handler);
        if (handler instanceof MessageHandler.Whole) {
            if (WHOLE_TEXT_HANDLER_TYPES.contains(handlerClass)) {
                if (this.textHandlerPresent) {
                    this.throwException("Text MessageHandler already registered.");
                } else {
                    if (Reader.class.isAssignableFrom(handlerClass)) {
                        this.readerHandlerPresent = true;
                    }
                    this.textHandlerPresent = true;
                    this.textWholeHandlerPresent = true;
                }
            } else if (WHOLE_BINARY_HANDLER_TYPES.contains(handlerClass)) {
                if (this.binaryHandlerPresent) {
                    this.throwException("Binary MessageHandler already registered.");
                } else {
                    if (InputStream.class.isAssignableFrom(handlerClass)) {
                        this.inputStreamHandlerPresent = true;
                    }
                    this.binaryHandlerPresent = true;
                    this.binaryWholeHandlerPresent = true;
                }
            } else if (PONG_HANDLER_TYPE == handlerClass) {
                if (this.pongHandlerPresent) {
                    this.throwException("Pong MessageHander already registered.");
                } else {
                    this.pongHandlerPresent = true;
                }
            } else {
                boolean decoderExists = false;
                if (this.checkTextDecoders(handlerClass)) {
                    if (this.textHandlerPresent) {
                        this.throwException("Text MessageHandler already registered.");
                    } else {
                        this.textHandlerPresent = true;
                        this.textWholeHandlerPresent = true;
                        decoderExists = true;
                    }
                } else if (this.checkBinaryDecoders(handlerClass)) {
                    if (this.binaryHandlerPresent) {
                        this.throwException("Text MessageHandler already registered.");
                    } else {
                        this.binaryHandlerPresent = true;
                        this.binaryWholeHandlerPresent = true;
                        decoderExists = true;
                    }
                }
                if (!decoderExists) {
                    this.throwException(String.format("Decoder for type: %s has not been registered.", handlerClass));
                }
            }
        } else if (PARTIAL_TEXT_HANDLER_TYPE.equals(handlerClass)) {
            if (this.textHandlerPresent) {
                this.throwException("Text MessageHandler already registered.");
            } else {
                this.textHandlerPresent = true;
            }
        } else if (PARTIAL_BINARY_HANDLER_TYPES.contains(handlerClass)) {
            if (this.binaryHandlerPresent) {
                this.throwException("Binary MessageHandler already registered.");
            } else {
                this.binaryHandlerPresent = true;
            }
        } else {
            this.throwException(String.format("Partial MessageHandler can't be of type: %s.", handlerClass));
        }
        if (this.registeredHandlers.containsKey(handlerClass)) {
            this.throwException(String.format("MessageHandler for type: %s already registered.", handlerClass));
        } else {
            this.registeredHandlers.put(handlerClass, handler);
        }
        this.messageHandlerCache = null;
    }

    private void throwException(String text) throws IllegalStateException {
        throw new IllegalStateException(text);
    }

    public void removeMessageHandler(MessageHandler handler) {
        boolean wasRegistered = false;
        Iterator<Map.Entry<Class<?>, MessageHandler>> iterator = this.registeredHandlers.entrySet().iterator();
        Class<?> handlerClass = MessageHandlerManager.getHandlerType(handler);
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, MessageHandler> next = iterator.next();
            if (!next.getValue().equals(handler)) continue;
            iterator.remove();
            this.messageHandlerCache = null;
            wasRegistered = true;
            break;
        }
        if (!wasRegistered) {
            return;
        }
        if (handler instanceof MessageHandler.Whole) {
            if (WHOLE_TEXT_HANDLER_TYPES.contains(handlerClass)) {
                this.textHandlerPresent = false;
                this.textWholeHandlerPresent = false;
            } else if (WHOLE_BINARY_HANDLER_TYPES.contains(handlerClass)) {
                this.binaryHandlerPresent = false;
                this.binaryWholeHandlerPresent = false;
            } else if (PONG_HANDLER_TYPE == handlerClass) {
                this.pongHandlerPresent = false;
            } else if (this.checkTextDecoders(handlerClass)) {
                this.textHandlerPresent = false;
                this.textWholeHandlerPresent = false;
            } else if (this.checkBinaryDecoders(handlerClass)) {
                this.binaryHandlerPresent = false;
                this.binaryWholeHandlerPresent = false;
            }
        } else if (PARTIAL_TEXT_HANDLER_TYPE.equals(handlerClass)) {
            this.textHandlerPresent = false;
        } else if (PARTIAL_BINARY_HANDLER_TYPES.contains(handlerClass)) {
            this.binaryHandlerPresent = false;
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        if (this.messageHandlerCache == null) {
            this.messageHandlerCache = Collections.unmodifiableSet(new HashSet<MessageHandler>(this.registeredHandlers.values()));
        }
        return this.messageHandlerCache;
    }

    static Class<?> getHandlerType(MessageHandler handler) {
        Class<MessageHandler.Partial> root;
        if (handler instanceof AsyncMessageHandler) {
            return ((AsyncMessageHandler)handler).getType();
        }
        if (handler instanceof BasicMessageHandler) {
            return ((BasicMessageHandler)handler).getType();
        }
        if (handler instanceof MessageHandler.Partial) {
            root = MessageHandler.Partial.class;
        } else if (handler instanceof MessageHandler.Whole) {
            root = MessageHandler.Whole.class;
        } else {
            throw new IllegalArgumentException(String.format("Illegal MessageHandler argument value: %s", handler));
        }
        Class<?> result = ReflectionHelper.getClassType(handler.getClass(), root);
        return result == null ? Object.class : result;
    }

    private boolean checkTextDecoders(Class<?> requiredType) {
        for (Class<? extends Decoder> decoderClass : this.decoders) {
            if (!this.isTextDecoder(decoderClass) || !AnnotatedEndpoint.getDecoderClassType(decoderClass).isAssignableFrom(requiredType)) continue;
            return true;
        }
        return false;
    }

    private boolean checkBinaryDecoders(Class<?> requiredType) {
        for (Class<? extends Decoder> decoderClass : this.decoders) {
            if (!this.isBinaryDecoder(decoderClass) || !AnnotatedEndpoint.getDecoderClassType(decoderClass).isAssignableFrom(requiredType)) continue;
            return true;
        }
        return false;
    }

    private boolean isTextDecoder(Class<? extends Decoder> decoderClass) {
        return Decoder.Text.class.isAssignableFrom(decoderClass) || Decoder.TextStream.class.isAssignableFrom(decoderClass);
    }

    private boolean isBinaryDecoder(Class<? extends Decoder> decoderClass) {
        return Decoder.Binary.class.isAssignableFrom(decoderClass) || Decoder.BinaryStream.class.isAssignableFrom(decoderClass);
    }

    boolean isWholeTextHandlerPresent() {
        return this.textWholeHandlerPresent;
    }

    boolean isWholeBinaryHandlerPresent() {
        return this.binaryWholeHandlerPresent;
    }

    boolean isPartialTextHandlerPresent() {
        return this.textHandlerPresent && !this.textWholeHandlerPresent;
    }

    boolean isPartialBinaryHandlerPresent() {
        return this.binaryHandlerPresent && !this.binaryWholeHandlerPresent;
    }

    public boolean isReaderHandlerPresent() {
        return this.readerHandlerPresent;
    }

    public boolean isInputStreamHandlerPresent() {
        return this.inputStreamHandlerPresent;
    }

    boolean isPongHandlerPresent() {
        return this.pongHandlerPresent;
    }
}

