/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.glassfish.tyrus.core.EndpointWrapper;
import org.glassfish.tyrus.core.OutputStreamToAsyncBinaryAdapter;
import org.glassfish.tyrus.core.SendCompletionAdapter;
import org.glassfish.tyrus.core.SessionImpl;
import org.glassfish.tyrus.core.WriterToAsyncTextAdapter;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;

public abstract class RemoteEndpointWrapper
implements RemoteEndpoint {
    protected final SPIRemoteEndpoint remoteEndpoint;
    protected final SessionImpl session;
    protected final EndpointWrapper endpointWrapper;

    private RemoteEndpointWrapper(SessionImpl session, SPIRemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper) {
        this.remoteEndpoint = remoteEndpoint;
        this.endpointWrapper = endpointWrapper;
        this.session = session;
    }

    protected Future<?> sendSyncText(String data) throws IOException {
        return this.remoteEndpoint.sendText(data);
    }

    protected Future<?> sendSyncBinary(ByteBuffer buf) throws IOException {
        return this.remoteEndpoint.sendBinary(buf);
    }

    protected Future<?> sendSyncObject(Object o) throws IOException, EncodeException {
        if (o instanceof String) {
            return this.remoteEndpoint.sendText((String)o);
        }
        if (this.isPrimitiveData(o)) {
            return this.remoteEndpoint.sendText(o.toString());
        }
        Object toSend = this.endpointWrapper.doEncode(this.session, o);
        if (toSend instanceof String) {
            return this.remoteEndpoint.sendText((String)toSend);
        }
        if (toSend instanceof ByteBuffer) {
            return this.remoteEndpoint.sendBinary((ByteBuffer)toSend);
        }
        if (toSend instanceof StringWriter) {
            StringWriter writer = (StringWriter)toSend;
            StringBuffer sb = writer.getBuffer();
            return this.remoteEndpoint.sendText(sb.toString());
        }
        if (toSend instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            return this.remoteEndpoint.sendBinary(buffer);
        }
        return null;
    }

    protected boolean isPrimitiveData(Object data) {
        Class<?> dataClass = data.getClass();
        return dataClass.equals(Integer.class) || dataClass.equals(Byte.class) || dataClass.equals(Short.class) || dataClass.equals(Long.class) || dataClass.equals(Float.class) || dataClass.equals(Double.class) || dataClass.equals(Boolean.class) || dataClass.equals(Character.class);
    }

    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException("Ping applicationData exceeded the maximum allowed payload of 125 bytes.");
        }
        this.remoteEndpoint.sendPing(applicationData);
    }

    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (applicationData != null && applicationData.remaining() > 125) {
            throw new IllegalArgumentException("Pong applicationData exceeded the maximum allowed payload of 125 bytes.");
        }
        this.remoteEndpoint.sendPong(applicationData);
    }

    public String toString() {
        return "Wrapped: " + this.getClass().getSimpleName();
    }

    public void setBatchingAllowed(boolean allowed) {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void flushBatch() {
    }

    public void close(CloseReason cr) {
        Logger.getLogger(RemoteEndpointWrapper.class.getName()).fine("Close public void close(CloseReason cr): " + cr);
        this.remoteEndpoint.close(cr);
    }

    static class Async
    extends RemoteEndpointWrapper
    implements RemoteEndpoint.Async {
        private long sendTimeout;

        Async(SessionImpl session, SPIRemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper) {
            super(session, remoteEndpoint, endpointWrapper);
        }

        public void sendText(String text, SendHandler handler) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.TEXT);
            this.session.restartIdleTimeoutExecutor();
            goesAway.send(text, handler);
        }

        public Future<Void> sendText(String text) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.TEXT);
            this.session.restartIdleTimeoutExecutor();
            return goesAway.send(text, null);
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
            this.session.restartIdleTimeoutExecutor();
            return goesAway.send(data, null);
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.BINARY);
            this.session.restartIdleTimeoutExecutor();
            goesAway.send(data, completion);
        }

        public void sendObject(Object data, SendHandler handler) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.OBJECT);
            this.session.restartIdleTimeoutExecutor();
            goesAway.send(data, handler);
        }

        public long getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
            this.remoteEndpoint.setWriteTimeout(timeoutmillis);
        }

        public Future<Void> sendObject(Object data) {
            SendCompletionAdapter goesAway = new SendCompletionAdapter(this, SendCompletionAdapter.State.OBJECT);
            this.session.restartIdleTimeoutExecutor();
            return goesAway.send(data, null);
        }
    }

    static class Basic
    extends RemoteEndpointWrapper
    implements RemoteEndpoint.Basic {
        Basic(SessionImpl session, SPIRemoteEndpoint remoteEndpoint, EndpointWrapper endpointWrapper) {
            super(session, remoteEndpoint, endpointWrapper);
        }

        public void sendText(String text) throws IOException {
            super.sendSyncText(text);
            this.session.restartIdleTimeoutExecutor();
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            super.sendSyncBinary(data);
            this.session.restartIdleTimeoutExecutor();
        }

        public void sendText(String partialMessage, boolean isLast) throws IOException {
            this.remoteEndpoint.sendText(partialMessage, isLast);
            this.session.restartIdleTimeoutExecutor();
        }

        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            this.remoteEndpoint.sendBinary(partialByte, isLast);
            this.session.restartIdleTimeoutExecutor();
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            super.sendSyncObject(data);
            this.session.restartIdleTimeoutExecutor();
        }

        public OutputStream getSendStream() throws IOException {
            return new OutputStreamToAsyncBinaryAdapter(this.remoteEndpoint);
        }

        public Writer getSendWriter() throws IOException {
            return new WriterToAsyncTextAdapter(this.remoteEndpoint);
        }
    }
}

