/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusRemoteEndpoint;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIHandshakeRequest;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.SPIRemoteEndpoint;
import org.glassfish.tyrus.websockets.DefaultWebSocket;
import org.glassfish.tyrus.websockets.Extension;
import org.glassfish.tyrus.websockets.ProtocolHandler;
import org.glassfish.tyrus.websockets.WebSocket;
import org.glassfish.tyrus.websockets.WebSocketApplication;
import org.glassfish.tyrus.websockets.WebSocketListener;
import org.glassfish.tyrus.websockets.WebSocketRequest;
import org.glassfish.tyrus.websockets.WebSocketResponse;
import org.glassfish.tyrus.websockets.draft06.ClosingFrame;

public class TyrusEndpoint
extends WebSocketApplication
implements SPIRegisteredEndpoint {
    private final SPIEndpoint endpoint;
    private List<Extension> temporaryNegotiatedExtensions = Collections.emptyList();
    private String temporaryNegotiatedProtocol;

    public TyrusEndpoint(SPIEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isApplicationRequest(WebSocketRequest webSocketRequest) {
        List protocols = (List)webSocketRequest.getHeaders().get("Sec-WebSocket-Protocol");
        this.temporaryNegotiatedProtocol = this.endpoint.getNegotiatedProtocol(protocols);
        List<Extension> extensions = TyrusExtension.fromString((List)webSocketRequest.getHeaders().get("Sec-WebSocket-Extensions"));
        this.temporaryNegotiatedExtensions = this.endpoint.getNegotiatedExtensions(extensions);
        return this.endpoint.checkHandshake((SPIHandshakeRequest)(webSocketRequest instanceof RequestContext ? (RequestContext)webSocketRequest : null));
    }

    public String getPath() {
        return this.endpoint.getEndpointPath();
    }

    public WebSocket createSocket(ProtocolHandler handler, WebSocketListener ... listeners) {
        handler.setContainer(this.endpoint.getWebSocketContainer());
        return new DefaultWebSocket(handler, listeners);
    }

    public void onConnect(WebSocket socket) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onConnect((SPIRemoteEndpoint)gs, this.temporaryNegotiatedProtocol, this.temporaryNegotiatedExtensions);
    }

    public void onFragment(WebSocket socket, String fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, fragment, last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        try {
            this.endpoint.onPartialMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(fragment), last);
        }
        catch (Throwable t) {
            Logger.getLogger(TyrusEndpoint.class.getName()).severe("Error !!!" + t);
            t.printStackTrace();
        }
    }

    public void onMessage(WebSocket socket, String messageString) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, messageString);
    }

    public void onMessage(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onMessage((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void onClose(WebSocket socket, ClosingFrame frame) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        CloseReason closeReason = null;
        if (frame != null) {
            closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)frame.getCode()), frame.getReason() == null ? "" : frame.getReason());
        }
        this.endpoint.onClose((SPIRemoteEndpoint)gs, closeReason);
        TyrusRemoteEndpoint.remove(socket);
    }

    public void onPong(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onPong((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void remove() {
        this.endpoint.remove();
    }

    public Set<Session> getOpenSessions() {
        return this.endpoint.getOpenSessions();
    }

    public void onExtensionNegotiation(List<org.glassfish.tyrus.websockets.Extension> extensions) {
    }

    public List<org.glassfish.tyrus.websockets.Extension> getSupportedExtensions() {
        ArrayList<org.glassfish.tyrus.websockets.Extension> grizzlyExtensions = new ArrayList<org.glassfish.tyrus.websockets.Extension>();
        for (Extension ext : this.temporaryNegotiatedExtensions) {
            org.glassfish.tyrus.websockets.Extension extension = new org.glassfish.tyrus.websockets.Extension(ext.getName());
            for (Extension.Parameter p : ext.getParameters()) {
                extension.getParameters().add(new Extension.Parameter(p.getName(), p.getValue()));
            }
            grizzlyExtensions.add(extension);
        }
        return grizzlyExtensions;
    }

    public boolean onError(WebSocket webSocket, Throwable t) {
        Logger.getLogger(TyrusEndpoint.class.getName()).log(Level.WARNING, "Unexpected error, closing connection.", t);
        return true;
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        List<String> result;
        if (this.temporaryNegotiatedProtocol == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            result.add(this.temporaryNegotiatedProtocol);
        }
        return result;
    }

    public void onPing(WebSocket socket, byte[] bytes) {
        TyrusRemoteEndpoint gs = TyrusRemoteEndpoint.get(socket);
        this.endpoint.onPing((SPIRemoteEndpoint)gs, ByteBuffer.wrap(bytes));
    }

    public void onHandShakeResponse(WebSocketRequest request, WebSocketResponse response) {
        EndpointConfig configuration = this.endpoint.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            HandshakeResponse handshakeResponse = this.createHandshakeResponse(response);
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), handshakeResponse);
            for (Map.Entry headerEntry : handshakeResponse.getHeaders().entrySet()) {
                StringBuilder finalHeaderValue = new StringBuilder();
                for (String headerValue : (List)headerEntry.getValue()) {
                    if (finalHeaderValue.length() != 0) {
                        finalHeaderValue.append(", ");
                    }
                    finalHeaderValue.append(headerValue);
                }
                response.getHeaders().put(headerEntry.getKey(), finalHeaderValue.toString());
            }
        }
    }

    private HandshakeRequest createHandshakeRequest(WebSocketRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)webSocketRequest;
            requestContext.lock();
            return requestContext;
        }
        return null;
    }

    private HandshakeResponse createHandshakeResponse(WebSocketResponse webSocketResponse) {
        final TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        });
        for (Map.Entry entry : webSocketResponse.getHeaders().entrySet()) {
            headers.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
        }
        return new HandshakeResponse(){

            public Map<String, List<String>> getHeaders() {
                return headers;
            }
        };
    }
}

