/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.BufferedInputStream;
import org.glassfish.tyrus.core.MessageTooBigException;

class InputStreamBuffer {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final List<ByteBuffer> bufferedFragments = new ArrayList<ByteBuffer>();
    private final ExecutorService executorService;
    private static final Logger LOGGER = Logger.getLogger(InputStreamBuffer.class.getName());
    private boolean receivedLast = false;
    private BufferedInputStream inputStream = null;
    private MessageHandler.Whole<InputStream> messageHandler;
    private int bufferSize;
    private int currentlyBuffered;

    public InputStreamBuffer(ExecutorService executorService) {
        this.executorService = executorService;
        this.currentlyBuffered = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getNextByte() {
        this.lock.lock();
        try {
            byte interrupted;
            if (this.bufferedFragments.isEmpty()) {
                if (this.receivedLast) {
                    this.inputStream = null;
                    this.currentlyBuffered = 0;
                    byte by = -1;
                    return by;
                }
                do {
                    interrupted = 0;
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        interrupted = 1;
                    }
                } while (interrupted != 0);
            }
            if (this.bufferedFragments.size() == 1 && !this.bufferedFragments.get(0).hasRemaining() && this.receivedLast) {
                this.inputStream = null;
                this.currentlyBuffered = 0;
                interrupted = -1;
                return interrupted;
            }
            ByteBuffer firstBuffer = this.bufferedFragments.get(0);
            byte result = firstBuffer.get();
            if (!firstBuffer.hasRemaining()) {
                this.bufferedFragments.remove(0);
            }
            byte by = result;
            return by;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finishReading() {
        this.bufferedFragments.clear();
        this.inputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessagePart(ByteBuffer message, boolean last) {
        this.lock.lock();
        try {
            this.currentlyBuffered += message.remaining();
            if (this.currentlyBuffered > this.bufferSize) {
                MessageTooBigException messageTooBigException = new MessageTooBigException("Partial message could not be delivered due to buffer overflow.");
                LOGGER.log(Level.FINE, "Partial message could not be delivered due to buffer overflow.", messageTooBigException);
                this.receivedLast = true;
                throw messageTooBigException;
            }
            this.bufferedFragments.add(message);
            this.receivedLast = last;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(this);
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    InputStreamBuffer.this.messageHandler.onMessage((Object)InputStreamBuffer.this.inputStream);
                }
            });
        }
    }

    public void setMessageHandler(MessageHandler.Whole<InputStream> messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void resetBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.currentlyBuffered = 0;
        this.bufferedFragments.clear();
    }
}

