/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientContainer;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.ServerContainer;
import javax.websocket.ServerEndpointConfiguration;
import javax.websocket.Session;
import org.glassfish.tyrus.AnnotatedEndpoint;
import org.glassfish.tyrus.ComponentProviderService;
import org.glassfish.tyrus.EndpointWrapper;
import org.glassfish.tyrus.WithProperties;
import org.glassfish.tyrus.server.ServerConfiguration;
import org.glassfish.tyrus.spi.SPIEndpoint;
import org.glassfish.tyrus.spi.SPIRegisteredEndpoint;
import org.glassfish.tyrus.spi.TyrusServer;

public class TyrusServerContainer
extends WithProperties
implements ServerContainer {
    private final TyrusServer server;
    private final String contextPath;
    private final ServerConfiguration configuration;
    private final Set<SPIRegisteredEndpoint> endpoints = new HashSet<SPIRegisteredEndpoint>();

    public TyrusServerContainer(TyrusServer server, String contextPath, final ServerConfiguration configuration) {
        this.server = server;
        this.contextPath = contextPath;
        this.configuration = new ServerConfiguration(){
            private final Set<Class<?>> endpointClasses;
            private final Set<Endpoint> endpointInstances;
            private final long maxSessionIdleTimeout;
            private final long maxBinaryMessageBufferSize;
            private final long maxTextMessageBufferSize;
            private final List<String> extensions;
            {
                this.endpointClasses = Collections.unmodifiableSet(new HashSet(configuration.getEndpointClasses()));
                this.endpointInstances = Collections.unmodifiableSet(new HashSet<Endpoint>(configuration.getEndpointInstances()));
                this.maxSessionIdleTimeout = configuration.getMaxSessionIdleTimeout();
                this.maxBinaryMessageBufferSize = configuration.getMaxBinaryMessageBufferSize();
                this.maxTextMessageBufferSize = configuration.getMaxTextMessageBufferSize();
                this.extensions = Collections.unmodifiableList(new ArrayList<String>(configuration.getExtensions()));
            }

            @Override
            public Set<Class<?>> getEndpointClasses() {
                return this.endpointClasses;
            }

            @Override
            public Set<Endpoint> getEndpointInstances() {
                return this.endpointInstances;
            }

            @Override
            public long getMaxSessionIdleTimeout() {
                return this.maxSessionIdleTimeout;
            }

            @Override
            public long getMaxBinaryMessageBufferSize() {
                return this.maxBinaryMessageBufferSize;
            }

            @Override
            public long getMaxTextMessageBufferSize() {
                return this.maxTextMessageBufferSize;
            }

            @Override
            public List<String> getExtensions() {
                return this.extensions;
            }
        };
    }

    public void start() throws IOException {
        this.server.start();
        for (Endpoint endpoint : this.configuration.getEndpointInstances()) {
            this.deploy(endpoint);
        }
        for (Class clazz : this.configuration.getEndpointClasses()) {
            try {
                this.deploy(clazz);
            }
            catch (DeploymentException e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void deploy(Endpoint endpoint) {
        EndpointWrapper ew = new EndpointWrapper(endpoint, (ClientContainer)this, this.contextPath);
        SPIRegisteredEndpoint ge = this.server.register((SPIEndpoint)ew);
        this.endpoints.add(ge);
    }

    private void deploy(Class<?> endpointClass) throws DeploymentException {
        AnnotatedEndpoint endpoint;
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            endpoint = (Endpoint)ComponentProviderService.getInstance(endpointClass);
        } else {
            endpoint = AnnotatedEndpoint.fromClass(endpointClass);
            if (endpoint == null) {
                throw new DeploymentException("Endpoint class " + endpointClass.getName() + " does " + "not extend Endpoint and is not " + "annotated with @WebSocketEndpoint annotation, so will be ignored.");
            }
        }
        this.deploy((Endpoint)endpoint);
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Registered a " + endpointClass + " at " + ((ServerEndpointConfiguration)endpoint.getEndpointConfiguration()).getPath());
    }

    public void stop() {
        for (SPIRegisteredEndpoint wsa : this.endpoints) {
            wsa.remove();
            this.server.unregister(wsa);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Closing down : " + wsa);
        }
        this.server.stop();
    }

    public void publishServer(Class<? extends Endpoint> endpointClass) throws DeploymentException {
        this.deploy(endpointClass);
    }

    public void connectToServer(Object endpoint, URI path) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public Set<Session> getActiveSessions() {
        throw new UnsupportedOperationException();
    }

    public long getMaxSessionIdleTimeout() {
        return this.configuration.getMaxSessionIdleTimeout();
    }

    public void setMaxSessionIdleTimeout(long timeout) {
        throw new UnsupportedOperationException();
    }

    public long getMaxBinaryMessageBufferSize() {
        return this.configuration.getMaxBinaryMessageBufferSize();
    }

    public void setMaxBinaryMessageBufferSize(long max) {
        throw new UnsupportedOperationException();
    }

    public long getMaxTextMessageBufferSize() {
        return this.configuration.getMaxTextMessageBufferSize();
    }

    public void setMaxTextMessageBufferSize(long max) {
        throw new UnsupportedOperationException();
    }

    public Set<String> getInstalledExtensions() {
        return Collections.unmodifiableSet(new HashSet<String>(this.configuration.getExtensions()));
    }
}

