package org.glowroot.agent.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PluginDescriptor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePluginDescriptor.builder()}.
 */
@Generated(from = "PluginDescriptor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePluginDescriptor extends PluginDescriptor {
  private final String id;
  private final String name;
  private final ImmutableList<PropertyDescriptor> properties;
  private final ImmutableList<InstrumentationConfig> instrumentationConfigs;
  private final ImmutableList<String> aspects;
  private final boolean collocate;
  private final @Nullable File pluginJar;

  private ImmutablePluginDescriptor(ImmutablePluginDescriptor.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.properties = builder.properties.build();
    this.instrumentationConfigs = builder.instrumentationConfigs.build();
    this.aspects = builder.aspects.build();
    this.pluginJar = builder.pluginJar;
    this.collocate = builder.collocateIsSet()
        ? builder.collocate
        : super.collocate();
  }

  private ImmutablePluginDescriptor(
      String id,
      String name,
      ImmutableList<PropertyDescriptor> properties,
      ImmutableList<InstrumentationConfig> instrumentationConfigs,
      ImmutableList<String> aspects,
      boolean collocate,
      @Nullable File pluginJar) {
    this.id = id;
    this.name = name;
    this.properties = properties;
    this.instrumentationConfigs = instrumentationConfigs;
    this.aspects = aspects;
    this.collocate = collocate;
    this.pluginJar = pluginJar;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableList<PropertyDescriptor> properties() {
    return properties;
  }

  /**
   * @return The value of the {@code instrumentationConfigs} attribute
   */
  @JsonProperty("instrumentation")
  @Override
  public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
    return instrumentationConfigs;
  }

  /**
   * @return The value of the {@code aspects} attribute
   */
  @JsonProperty("aspects")
  @Override
  public ImmutableList<String> aspects() {
    return aspects;
  }

  /**
   * @return The value of the {@code collocate} attribute
   */
  @JsonProperty("collocate")
  @Override
  public boolean collocate() {
    return collocate;
  }

  /**
   * @return The value of the {@code pluginJar} attribute
   */
  @JsonProperty("pluginJar")
  @JsonIgnore
  @Override
  public @Nullable File pluginJar() {
    return pluginJar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDescriptor#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePluginDescriptor withId(String value) {
    String newValue = Preconditions.checkNotNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutablePluginDescriptor(
        newValue,
        this.name,
        this.properties,
        this.instrumentationConfigs,
        this.aspects,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDescriptor#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePluginDescriptor withName(String value) {
    String newValue = Preconditions.checkNotNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePluginDescriptor(
        this.id,
        newValue,
        this.properties,
        this.instrumentationConfigs,
        this.aspects,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#properties() properties}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withProperties(PropertyDescriptor... elements) {
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        newValue,
        this.instrumentationConfigs,
        this.aspects,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#properties() properties}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of properties elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withProperties(Iterable<? extends PropertyDescriptor> elements) {
    if (this.properties == elements) return this;
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        newValue,
        this.instrumentationConfigs,
        this.aspects,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withInstrumentationConfigs(InstrumentationConfig... elements) {
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(this.id, this.name, this.properties, newValue, this.aspects, this.collocate, this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of instrumentationConfigs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
    if (this.instrumentationConfigs == elements) return this;
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(this.id, this.name, this.properties, newValue, this.aspects, this.collocate, this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#aspects() aspects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withAspects(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        this.properties,
        this.instrumentationConfigs,
        newValue,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDescriptor#aspects() aspects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of aspects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePluginDescriptor withAspects(Iterable<String> elements) {
    if (this.aspects == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        this.properties,
        this.instrumentationConfigs,
        newValue,
        this.collocate,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDescriptor#collocate() collocate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collocate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePluginDescriptor withCollocate(boolean value) {
    if (this.collocate == value) return this;
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        this.properties,
        this.instrumentationConfigs,
        this.aspects,
        value,
        this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDescriptor#pluginJar() pluginJar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pluginJar (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePluginDescriptor withPluginJar(@Nullable File value) {
    if (this.pluginJar == value) return this;
    return new ImmutablePluginDescriptor(
        this.id,
        this.name,
        this.properties,
        this.instrumentationConfigs,
        this.aspects,
        this.collocate,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePluginDescriptor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePluginDescriptor
        && equalTo((ImmutablePluginDescriptor) another);
  }

  private boolean equalTo(ImmutablePluginDescriptor another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && properties.equals(another.properties)
        && instrumentationConfigs.equals(another.instrumentationConfigs)
        && aspects.equals(another.aspects)
        && collocate == another.collocate
        && Objects.equal(pluginJar, another.pluginJar);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code properties}, {@code instrumentationConfigs}, {@code aspects}, {@code collocate}, {@code pluginJar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + properties.hashCode();
    h += (h << 5) + instrumentationConfigs.hashCode();
    h += (h << 5) + aspects.hashCode();
    h += (h << 5) + Booleans.hashCode(collocate);
    h += (h << 5) + Objects.hashCode(pluginJar);
    return h;
  }

  /**
   * Prints the immutable value {@code PluginDescriptor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginDescriptor")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("properties", properties)
        .add("instrumentationConfigs", instrumentationConfigs)
        .add("aspects", aspects)
        .add("collocate", collocate)
        .add("pluginJar", pluginJar)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDescriptor", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PluginDescriptor {
    @Nullable String id;
    @Nullable String name;
    @Nullable ImmutableList<PropertyDescriptor> properties = ImmutableList.of();
    @Nullable ImmutableList<InstrumentationConfig> instrumentationConfigs = ImmutableList.of();
    @Nullable ImmutableList<String> aspects = ImmutableList.of();
    boolean collocate;
    boolean collocateIsSet;
    @Nullable File pluginJar;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("properties")
    public void setProperties(ImmutableList<PropertyDescriptor> properties) {
      this.properties = properties;
    }
    @JsonProperty("instrumentation")
    public void setInstrumentationConfigs(ImmutableList<InstrumentationConfig> instrumentationConfigs) {
      this.instrumentationConfigs = instrumentationConfigs;
    }
    @JsonProperty("aspects")
    public void setAspects(ImmutableList<String> aspects) {
      this.aspects = aspects;
    }
    @JsonProperty("collocate")
    public void setCollocate(boolean collocate) {
      this.collocate = collocate;
      this.collocateIsSet = true;
    }
    @JsonProperty("pluginJar")
    @JsonIgnore
    public void setPluginJar(@Nullable File pluginJar) {
      this.pluginJar = pluginJar;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<PropertyDescriptor> properties() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<InstrumentationConfig> instrumentationConfigs() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<String> aspects() { throw new UnsupportedOperationException(); }
    @Override
    public boolean collocate() { throw new UnsupportedOperationException(); }
    @Override
    public File pluginJar() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePluginDescriptor fromJson(Json json) {
    ImmutablePluginDescriptor.Builder builder = ImmutablePluginDescriptor.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.properties != null) {
      builder.addAllProperties(json.properties);
    }
    if (json.instrumentationConfigs != null) {
      builder.addAllInstrumentationConfigs(json.instrumentationConfigs);
    }
    if (json.aspects != null) {
      builder.addAllAspects(json.aspects);
    }
    if (json.collocateIsSet) {
      builder.collocate(json.collocate);
    }
    if (json.pluginJar != null) {
      builder.pluginJar(json.pluginJar);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDescriptor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PluginDescriptor instance
   */
  public static ImmutablePluginDescriptor copyOf(PluginDescriptor instance) {
    if (instance instanceof ImmutablePluginDescriptor) {
      return (ImmutablePluginDescriptor) instance;
    }
    return ImmutablePluginDescriptor.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePluginDescriptor ImmutablePluginDescriptor}.
   * <pre>
   * ImmutablePluginDescriptor.builder()
   *    .id(String) // required {@link PluginDescriptor#id() id}
   *    .name(String) // required {@link PluginDescriptor#name() name}
   *    .addProperties|addAllProperties(org.glowroot.agent.config.PropertyDescriptor) // {@link PluginDescriptor#properties() properties} elements
   *    .addInstrumentationConfigs|addAllInstrumentationConfigs(org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig) // {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs} elements
   *    .addAspects|addAllAspects(String) // {@link PluginDescriptor#aspects() aspects} elements
   *    .collocate(boolean) // optional {@link PluginDescriptor#collocate() collocate}
   *    .pluginJar(java.io.File | null) // nullable {@link PluginDescriptor#pluginJar() pluginJar}
   *    .build();
   * </pre>
   * @return A new ImmutablePluginDescriptor builder
   */
  public static ImmutablePluginDescriptor.Builder builder() {
    return new ImmutablePluginDescriptor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePluginDescriptor ImmutablePluginDescriptor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDescriptor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long OPT_BIT_COLLOCATE = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String id;
    private @Nullable String name;
    private ImmutableList.Builder<PropertyDescriptor> properties = ImmutableList.builder();
    private ImmutableList.Builder<InstrumentationConfig> instrumentationConfigs = ImmutableList.builder();
    private ImmutableList.Builder<String> aspects = ImmutableList.builder();
    private boolean collocate;
    private @Nullable File pluginJar;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PluginDescriptor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDescriptor instance) {
      Preconditions.checkNotNull(instance, "instance");
      id(instance.id());
      name(instance.name());
      addAllProperties(instance.properties());
      addAllInstrumentationConfigs(instance.instrumentationConfigs());
      addAllAspects(instance.aspects());
      collocate(instance.collocate());
      @Nullable File pluginJarValue = instance.pluginJar();
      if (pluginJarValue != null) {
        pluginJar(pluginJarValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDescriptor#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDescriptor#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link PluginDescriptor#properties() properties} list.
     * @param element A properties element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProperties(PropertyDescriptor element) {
      this.properties.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDescriptor#properties() properties} list.
     * @param elements An array of properties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProperties(PropertyDescriptor... elements) {
      this.properties.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDescriptor#properties() properties} list.
     * @param elements An iterable of properties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder properties(Iterable<? extends PropertyDescriptor> elements) {
      this.properties = ImmutableList.builder();
      return addAllProperties(elements);
    }

    /**
     * Adds elements to {@link PluginDescriptor#properties() properties} list.
     * @param elements An iterable of properties elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllProperties(Iterable<? extends PropertyDescriptor> elements) {
      this.properties.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs} list.
     * @param element A instrumentationConfigs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstrumentationConfigs(InstrumentationConfig element) {
      this.instrumentationConfigs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements An array of instrumentationConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInstrumentationConfigs(InstrumentationConfig... elements) {
      this.instrumentationConfigs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements An iterable of instrumentationConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder instrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
      this.instrumentationConfigs = ImmutableList.builder();
      return addAllInstrumentationConfigs(elements);
    }

    /**
     * Adds elements to {@link PluginDescriptor#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements An iterable of instrumentationConfigs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
      this.instrumentationConfigs.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link PluginDescriptor#aspects() aspects} list.
     * @param element A aspects element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAspects(String element) {
      this.aspects.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDescriptor#aspects() aspects} list.
     * @param elements An array of aspects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAspects(String... elements) {
      this.aspects.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDescriptor#aspects() aspects} list.
     * @param elements An iterable of aspects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aspects(Iterable<String> elements) {
      this.aspects = ImmutableList.builder();
      return addAllAspects(elements);
    }

    /**
     * Adds elements to {@link PluginDescriptor#aspects() aspects} list.
     * @param elements An iterable of aspects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAspects(Iterable<String> elements) {
      this.aspects.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDescriptor#collocate() collocate} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PluginDescriptor#collocate() collocate}.</em>
     * @param collocate The value for collocate 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder collocate(boolean collocate) {
      this.collocate = collocate;
      optBits |= OPT_BIT_COLLOCATE;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDescriptor#pluginJar() pluginJar} attribute.
     * @param pluginJar The value for pluginJar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pluginJar(@Nullable File pluginJar) {
      this.pluginJar = pluginJar;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePluginDescriptor ImmutablePluginDescriptor}.
     * @return An immutable instance of PluginDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePluginDescriptor build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePluginDescriptor(this);
    }

    private boolean collocateIsSet() {
      return (optBits & OPT_BIT_COLLOCATE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build PluginDescriptor, some of required attributes are not set " + attributes;
    }
  }
}
