package org.glowroot.agent.model;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ErrorMessage.StackTraceWithoutCommonFrames}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStackTraceWithoutCommonFrames.builder()}.
 */
@Generated(from = "ErrorMessage.StackTraceWithoutCommonFrames", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableStackTraceWithoutCommonFrames
    extends ErrorMessage.StackTraceWithoutCommonFrames {
  private final ImmutableList<StackTraceElement> stackTrace;
  private final int framesInCommonWithEnclosing;

  private ImmutableStackTraceWithoutCommonFrames(ImmutableStackTraceWithoutCommonFrames.Builder builder) {
    this.stackTrace = builder.stackTrace.build();
    this.framesInCommonWithEnclosing = builder.framesInCommonWithEnclosingIsSet()
        ? builder.framesInCommonWithEnclosing
        : super.framesInCommonWithEnclosing();
  }

  private ImmutableStackTraceWithoutCommonFrames(
      ImmutableList<StackTraceElement> stackTrace,
      int framesInCommonWithEnclosing) {
    this.stackTrace = stackTrace;
    this.framesInCommonWithEnclosing = framesInCommonWithEnclosing;
  }

  /**
   * @return The value of the {@code stackTrace} attribute
   */
  @JsonProperty("stackTrace")
  @Override
  ImmutableList<StackTraceElement> stackTrace() {
    return stackTrace;
  }

  /**
   * @return The value of the {@code framesInCommonWithEnclosing} attribute
   */
  @JsonProperty("framesInCommonWithEnclosing")
  @Override
  public int framesInCommonWithEnclosing() {
    return framesInCommonWithEnclosing;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStackTraceWithoutCommonFrames withStackTrace(StackTraceElement... elements) {
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStackTraceWithoutCommonFrames(newValue, this.framesInCommonWithEnclosing);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of stackTrace elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStackTraceWithoutCommonFrames withStackTrace(Iterable<? extends StackTraceElement> elements) {
    if (this.stackTrace == elements) return this;
    ImmutableList<StackTraceElement> newValue = ImmutableList.copyOf(elements);
    return new ImmutableStackTraceWithoutCommonFrames(newValue, this.framesInCommonWithEnclosing);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ErrorMessage.StackTraceWithoutCommonFrames#framesInCommonWithEnclosing() framesInCommonWithEnclosing} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for framesInCommonWithEnclosing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStackTraceWithoutCommonFrames withFramesInCommonWithEnclosing(int value) {
    if (this.framesInCommonWithEnclosing == value) return this;
    return new ImmutableStackTraceWithoutCommonFrames(this.stackTrace, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStackTraceWithoutCommonFrames} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStackTraceWithoutCommonFrames
        && equalTo((ImmutableStackTraceWithoutCommonFrames) another);
  }

  private boolean equalTo(ImmutableStackTraceWithoutCommonFrames another) {
    return stackTrace.equals(another.stackTrace)
        && framesInCommonWithEnclosing == another.framesInCommonWithEnclosing;
  }

  /**
   * Computes a hash code from attributes: {@code stackTrace}, {@code framesInCommonWithEnclosing}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + stackTrace.hashCode();
    h += (h << 5) + framesInCommonWithEnclosing;
    return h;
  }

  /**
   * Prints the immutable value {@code StackTraceWithoutCommonFrames} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StackTraceWithoutCommonFrames")
        .omitNullValues()
        .add("stackTrace", stackTrace)
        .add("framesInCommonWithEnclosing", framesInCommonWithEnclosing)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ErrorMessage.StackTraceWithoutCommonFrames", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ErrorMessage.StackTraceWithoutCommonFrames {
    @Nullable List<StackTraceElement> stackTrace = ImmutableList.of();
    int framesInCommonWithEnclosing;
    boolean framesInCommonWithEnclosingIsSet;
    @JsonProperty("stackTrace")
    public void setStackTrace(List<StackTraceElement> stackTrace) {
      this.stackTrace = stackTrace;
    }
    @JsonProperty("framesInCommonWithEnclosing")
    public void setFramesInCommonWithEnclosing(int framesInCommonWithEnclosing) {
      this.framesInCommonWithEnclosing = framesInCommonWithEnclosing;
      this.framesInCommonWithEnclosingIsSet = true;
    }
    @Override
    List<StackTraceElement> stackTrace() { throw new UnsupportedOperationException(); }
    @Override
    public int framesInCommonWithEnclosing() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStackTraceWithoutCommonFrames fromJson(Json json) {
    ImmutableStackTraceWithoutCommonFrames.Builder builder = ImmutableStackTraceWithoutCommonFrames.builder();
    if (json.stackTrace != null) {
      builder.addAllStackTrace(json.stackTrace);
    }
    if (json.framesInCommonWithEnclosingIsSet) {
      builder.framesInCommonWithEnclosing(json.framesInCommonWithEnclosing);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ErrorMessage.StackTraceWithoutCommonFrames} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StackTraceWithoutCommonFrames instance
   */
  public static ImmutableStackTraceWithoutCommonFrames copyOf(ErrorMessage.StackTraceWithoutCommonFrames instance) {
    if (instance instanceof ImmutableStackTraceWithoutCommonFrames) {
      return (ImmutableStackTraceWithoutCommonFrames) instance;
    }
    return ImmutableStackTraceWithoutCommonFrames.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStackTraceWithoutCommonFrames ImmutableStackTraceWithoutCommonFrames}.
   * <pre>
   * ImmutableStackTraceWithoutCommonFrames.builder()
   *    .addStackTrace|addAllStackTrace(StackTraceElement) // {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace} elements
   *    .framesInCommonWithEnclosing(int) // optional {@link ErrorMessage.StackTraceWithoutCommonFrames#framesInCommonWithEnclosing() framesInCommonWithEnclosing}
   *    .build();
   * </pre>
   * @return A new ImmutableStackTraceWithoutCommonFrames builder
   */
  public static ImmutableStackTraceWithoutCommonFrames.Builder builder() {
    return new ImmutableStackTraceWithoutCommonFrames.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStackTraceWithoutCommonFrames ImmutableStackTraceWithoutCommonFrames}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ErrorMessage.StackTraceWithoutCommonFrames", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_FRAMES_IN_COMMON_WITH_ENCLOSING = 0x1L;
    private long optBits;

    private ImmutableList.Builder<StackTraceElement> stackTrace = ImmutableList.builder();
    private int framesInCommonWithEnclosing;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StackTraceWithoutCommonFrames} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(ErrorMessage.StackTraceWithoutCommonFrames instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllStackTrace(instance.stackTrace());
      framesInCommonWithEnclosing(instance.framesInCommonWithEnclosing());
      return this;
    }

    /**
     * Adds one element to {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace} list.
     * @param element A stackTrace element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStackTrace(StackTraceElement element) {
      this.stackTrace.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace} list.
     * @param elements An array of stackTrace elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStackTrace(StackTraceElement... elements) {
      this.stackTrace.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace} list.
     * @param elements An iterable of stackTrace elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder stackTrace(Iterable<? extends StackTraceElement> elements) {
      this.stackTrace = ImmutableList.builder();
      return addAllStackTrace(elements);
    }

    /**
     * Adds elements to {@link ErrorMessage.StackTraceWithoutCommonFrames#stackTrace() stackTrace} list.
     * @param elements An iterable of stackTrace elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStackTrace(Iterable<? extends StackTraceElement> elements) {
      this.stackTrace.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ErrorMessage.StackTraceWithoutCommonFrames#framesInCommonWithEnclosing() framesInCommonWithEnclosing} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ErrorMessage.StackTraceWithoutCommonFrames#framesInCommonWithEnclosing() framesInCommonWithEnclosing}.</em>
     * @param framesInCommonWithEnclosing The value for framesInCommonWithEnclosing 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder framesInCommonWithEnclosing(int framesInCommonWithEnclosing) {
      this.framesInCommonWithEnclosing = framesInCommonWithEnclosing;
      optBits |= OPT_BIT_FRAMES_IN_COMMON_WITH_ENCLOSING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStackTraceWithoutCommonFrames ImmutableStackTraceWithoutCommonFrames}.
     * @return An immutable instance of StackTraceWithoutCommonFrames
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStackTraceWithoutCommonFrames build() {
      return new ImmutableStackTraceWithoutCommonFrames(this);
    }

    private boolean framesInCommonWithEnclosingIsSet() {
      return (optBits & OPT_BIT_FRAMES_IN_COMMON_WITH_ENCLOSING) != 0;
    }
  }
}
