/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.glowroot.agent.shaded.net.logstash.logback.encoder;

import org.glowroot.agent.shaded.net.logstash.logback.composite.CompositeJsonFormatter;
import org.glowroot.agent.shaded.net.logstash.logback.composite.JsonProviders;
import org.glowroot.agent.shaded.net.logstash.logback.composite.accessevent.AccessEventJsonProviders;
import org.glowroot.agent.shaded.net.logstash.logback.composite.accessevent.AccessEventCompositeJsonFormatter;
import org.glowroot.agent.shaded.ch.qos.logback.access.spi.IAccessEvent;
import org.glowroot.agent.shaded.ch.qos.logback.core.joran.spi.DefaultClass;

public class AccessEventCompositeJsonEncoder extends CompositeJsonEncoder<IAccessEvent> {
    
    
    @Override
    protected CompositeJsonFormatter<IAccessEvent> createFormatter() {
        return new AccessEventCompositeJsonFormatter(this);
    }
    
    @Override
    @DefaultClass(AccessEventJsonProviders.class)
    public void setProviders(JsonProviders<IAccessEvent> jsonProviders) {
        super.setProviders(jsonProviders);
    }
}
