package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AdvancedConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAdvancedConfig.builder()}.
 */
@Generated(from = "AdvancedConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAdvancedConfig extends AdvancedConfig {
  private final int immediatePartialStoreThresholdSeconds;
  private final int maxTransactionAggregates;
  private final int maxQueryAggregates;
  private final int maxServiceCallAggregates;
  private final int maxTraceEntriesPerTransaction;
  private final int maxProfileSamplesPerTransaction;
  private final int mbeanGaugeNotFoundDelaySeconds;
  private final boolean weavingTimer;

  private ImmutableAdvancedConfig(ImmutableAdvancedConfig.Builder builder) {
    if (builder.immediatePartialStoreThresholdSecondsIsSet()) {
      initShim.immediatePartialStoreThresholdSeconds(builder.immediatePartialStoreThresholdSeconds);
    }
    if (builder.maxTransactionAggregatesIsSet()) {
      initShim.maxTransactionAggregates(builder.maxTransactionAggregates);
    }
    if (builder.maxQueryAggregatesIsSet()) {
      initShim.maxQueryAggregates(builder.maxQueryAggregates);
    }
    if (builder.maxServiceCallAggregatesIsSet()) {
      initShim.maxServiceCallAggregates(builder.maxServiceCallAggregates);
    }
    if (builder.maxTraceEntriesPerTransactionIsSet()) {
      initShim.maxTraceEntriesPerTransaction(builder.maxTraceEntriesPerTransaction);
    }
    if (builder.maxProfileSamplesPerTransactionIsSet()) {
      initShim.maxProfileSamplesPerTransaction(builder.maxProfileSamplesPerTransaction);
    }
    if (builder.mbeanGaugeNotFoundDelaySecondsIsSet()) {
      initShim.mbeanGaugeNotFoundDelaySeconds(builder.mbeanGaugeNotFoundDelaySeconds);
    }
    if (builder.weavingTimerIsSet()) {
      initShim.weavingTimer(builder.weavingTimer);
    }
    this.immediatePartialStoreThresholdSeconds = initShim.immediatePartialStoreThresholdSeconds();
    this.maxTransactionAggregates = initShim.maxTransactionAggregates();
    this.maxQueryAggregates = initShim.maxQueryAggregates();
    this.maxServiceCallAggregates = initShim.maxServiceCallAggregates();
    this.maxTraceEntriesPerTransaction = initShim.maxTraceEntriesPerTransaction();
    this.maxProfileSamplesPerTransaction = initShim.maxProfileSamplesPerTransaction();
    this.mbeanGaugeNotFoundDelaySeconds = initShim.mbeanGaugeNotFoundDelaySeconds();
    this.weavingTimer = initShim.weavingTimer();
    this.initShim = null;
  }

  private ImmutableAdvancedConfig(
      int immediatePartialStoreThresholdSeconds,
      int maxTransactionAggregates,
      int maxQueryAggregates,
      int maxServiceCallAggregates,
      int maxTraceEntriesPerTransaction,
      int maxProfileSamplesPerTransaction,
      int mbeanGaugeNotFoundDelaySeconds,
      boolean weavingTimer) {
    this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
    this.maxTransactionAggregates = maxTransactionAggregates;
    this.maxQueryAggregates = maxQueryAggregates;
    this.maxServiceCallAggregates = maxServiceCallAggregates;
    this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
    this.maxProfileSamplesPerTransaction = maxProfileSamplesPerTransaction;
    this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
    this.weavingTimer = weavingTimer;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "AdvancedConfig", generator = "Immutables")
  private final class InitShim {
    private byte immediatePartialStoreThresholdSecondsBuildStage = STAGE_UNINITIALIZED;
    private int immediatePartialStoreThresholdSeconds;

    int immediatePartialStoreThresholdSeconds() {
      if (immediatePartialStoreThresholdSecondsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (immediatePartialStoreThresholdSecondsBuildStage == STAGE_UNINITIALIZED) {
        immediatePartialStoreThresholdSecondsBuildStage = STAGE_INITIALIZING;
        this.immediatePartialStoreThresholdSeconds = ImmutableAdvancedConfig.super.immediatePartialStoreThresholdSeconds();
        immediatePartialStoreThresholdSecondsBuildStage = STAGE_INITIALIZED;
      }
      return this.immediatePartialStoreThresholdSeconds;
    }

    void immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
      this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
      immediatePartialStoreThresholdSecondsBuildStage = STAGE_INITIALIZED;
    }

    private byte maxTransactionAggregatesBuildStage = STAGE_UNINITIALIZED;
    private int maxTransactionAggregates;

    int maxTransactionAggregates() {
      if (maxTransactionAggregatesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxTransactionAggregatesBuildStage == STAGE_UNINITIALIZED) {
        maxTransactionAggregatesBuildStage = STAGE_INITIALIZING;
        this.maxTransactionAggregates = ImmutableAdvancedConfig.super.maxTransactionAggregates();
        maxTransactionAggregatesBuildStage = STAGE_INITIALIZED;
      }
      return this.maxTransactionAggregates;
    }

    void maxTransactionAggregates(int maxTransactionAggregates) {
      this.maxTransactionAggregates = maxTransactionAggregates;
      maxTransactionAggregatesBuildStage = STAGE_INITIALIZED;
    }

    private byte maxQueryAggregatesBuildStage = STAGE_UNINITIALIZED;
    private int maxQueryAggregates;

    int maxQueryAggregates() {
      if (maxQueryAggregatesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxQueryAggregatesBuildStage == STAGE_UNINITIALIZED) {
        maxQueryAggregatesBuildStage = STAGE_INITIALIZING;
        this.maxQueryAggregates = ImmutableAdvancedConfig.super.maxQueryAggregates();
        maxQueryAggregatesBuildStage = STAGE_INITIALIZED;
      }
      return this.maxQueryAggregates;
    }

    void maxQueryAggregates(int maxQueryAggregates) {
      this.maxQueryAggregates = maxQueryAggregates;
      maxQueryAggregatesBuildStage = STAGE_INITIALIZED;
    }

    private byte maxServiceCallAggregatesBuildStage = STAGE_UNINITIALIZED;
    private int maxServiceCallAggregates;

    int maxServiceCallAggregates() {
      if (maxServiceCallAggregatesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxServiceCallAggregatesBuildStage == STAGE_UNINITIALIZED) {
        maxServiceCallAggregatesBuildStage = STAGE_INITIALIZING;
        this.maxServiceCallAggregates = ImmutableAdvancedConfig.super.maxServiceCallAggregates();
        maxServiceCallAggregatesBuildStage = STAGE_INITIALIZED;
      }
      return this.maxServiceCallAggregates;
    }

    void maxServiceCallAggregates(int maxServiceCallAggregates) {
      this.maxServiceCallAggregates = maxServiceCallAggregates;
      maxServiceCallAggregatesBuildStage = STAGE_INITIALIZED;
    }

    private byte maxTraceEntriesPerTransactionBuildStage = STAGE_UNINITIALIZED;
    private int maxTraceEntriesPerTransaction;

    int maxTraceEntriesPerTransaction() {
      if (maxTraceEntriesPerTransactionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxTraceEntriesPerTransactionBuildStage == STAGE_UNINITIALIZED) {
        maxTraceEntriesPerTransactionBuildStage = STAGE_INITIALIZING;
        this.maxTraceEntriesPerTransaction = ImmutableAdvancedConfig.super.maxTraceEntriesPerTransaction();
        maxTraceEntriesPerTransactionBuildStage = STAGE_INITIALIZED;
      }
      return this.maxTraceEntriesPerTransaction;
    }

    void maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
      this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
      maxTraceEntriesPerTransactionBuildStage = STAGE_INITIALIZED;
    }

    private byte maxProfileSamplesPerTransactionBuildStage = STAGE_UNINITIALIZED;
    private int maxProfileSamplesPerTransaction;

    int maxProfileSamplesPerTransaction() {
      if (maxProfileSamplesPerTransactionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxProfileSamplesPerTransactionBuildStage == STAGE_UNINITIALIZED) {
        maxProfileSamplesPerTransactionBuildStage = STAGE_INITIALIZING;
        this.maxProfileSamplesPerTransaction = ImmutableAdvancedConfig.super.maxProfileSamplesPerTransaction();
        maxProfileSamplesPerTransactionBuildStage = STAGE_INITIALIZED;
      }
      return this.maxProfileSamplesPerTransaction;
    }

    void maxProfileSamplesPerTransaction(int maxProfileSamplesPerTransaction) {
      this.maxProfileSamplesPerTransaction = maxProfileSamplesPerTransaction;
      maxProfileSamplesPerTransactionBuildStage = STAGE_INITIALIZED;
    }

    private byte mbeanGaugeNotFoundDelaySecondsBuildStage = STAGE_UNINITIALIZED;
    private int mbeanGaugeNotFoundDelaySeconds;

    int mbeanGaugeNotFoundDelaySeconds() {
      if (mbeanGaugeNotFoundDelaySecondsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (mbeanGaugeNotFoundDelaySecondsBuildStage == STAGE_UNINITIALIZED) {
        mbeanGaugeNotFoundDelaySecondsBuildStage = STAGE_INITIALIZING;
        this.mbeanGaugeNotFoundDelaySeconds = ImmutableAdvancedConfig.super.mbeanGaugeNotFoundDelaySeconds();
        mbeanGaugeNotFoundDelaySecondsBuildStage = STAGE_INITIALIZED;
      }
      return this.mbeanGaugeNotFoundDelaySeconds;
    }

    void mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
      this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
      mbeanGaugeNotFoundDelaySecondsBuildStage = STAGE_INITIALIZED;
    }

    private byte weavingTimerBuildStage = STAGE_UNINITIALIZED;
    private boolean weavingTimer;

    boolean weavingTimer() {
      if (weavingTimerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (weavingTimerBuildStage == STAGE_UNINITIALIZED) {
        weavingTimerBuildStage = STAGE_INITIALIZING;
        this.weavingTimer = ImmutableAdvancedConfig.super.weavingTimer();
        weavingTimerBuildStage = STAGE_INITIALIZED;
      }
      return this.weavingTimer;
    }

    void weavingTimer(boolean weavingTimer) {
      this.weavingTimer = weavingTimer;
      weavingTimerBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<String>();
      if (immediatePartialStoreThresholdSecondsBuildStage == STAGE_INITIALIZING) attributes.add("immediatePartialStoreThresholdSeconds");
      if (maxTransactionAggregatesBuildStage == STAGE_INITIALIZING) attributes.add("maxTransactionAggregates");
      if (maxQueryAggregatesBuildStage == STAGE_INITIALIZING) attributes.add("maxQueryAggregates");
      if (maxServiceCallAggregatesBuildStage == STAGE_INITIALIZING) attributes.add("maxServiceCallAggregates");
      if (maxTraceEntriesPerTransactionBuildStage == STAGE_INITIALIZING) attributes.add("maxTraceEntriesPerTransaction");
      if (maxProfileSamplesPerTransactionBuildStage == STAGE_INITIALIZING) attributes.add("maxProfileSamplesPerTransaction");
      if (mbeanGaugeNotFoundDelaySecondsBuildStage == STAGE_INITIALIZING) attributes.add("mbeanGaugeNotFoundDelaySeconds");
      if (weavingTimerBuildStage == STAGE_INITIALIZING) attributes.add("weavingTimer");
      return "Cannot build AdvancedConfig, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code immediatePartialStoreThresholdSeconds} attribute
   */
  @JsonProperty("immediatePartialStoreThresholdSeconds")
  @Override
  public int immediatePartialStoreThresholdSeconds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.immediatePartialStoreThresholdSeconds()
        : this.immediatePartialStoreThresholdSeconds;
  }

  /**
   * @return The value of the {@code maxTransactionAggregates} attribute
   */
  @JsonProperty("maxTransactionAggregates")
  @Override
  public int maxTransactionAggregates() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxTransactionAggregates()
        : this.maxTransactionAggregates;
  }

  /**
   * @return The value of the {@code maxQueryAggregates} attribute
   */
  @JsonProperty("maxQueryAggregates")
  @Override
  public int maxQueryAggregates() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxQueryAggregates()
        : this.maxQueryAggregates;
  }

  /**
   * @return The value of the {@code maxServiceCallAggregates} attribute
   */
  @JsonProperty("maxServiceCallAggregates")
  @Override
  public int maxServiceCallAggregates() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxServiceCallAggregates()
        : this.maxServiceCallAggregates;
  }

  /**
   * @return The value of the {@code maxTraceEntriesPerTransaction} attribute
   */
  @JsonProperty("maxTraceEntriesPerTransaction")
  @Override
  public int maxTraceEntriesPerTransaction() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxTraceEntriesPerTransaction()
        : this.maxTraceEntriesPerTransaction;
  }

  /**
   * @return The value of the {@code maxProfileSamplesPerTransaction} attribute
   */
  @JsonProperty("maxProfileSamplesPerTransaction")
  @Override
  public int maxProfileSamplesPerTransaction() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxProfileSamplesPerTransaction()
        : this.maxProfileSamplesPerTransaction;
  }

  /**
   * @return The value of the {@code mbeanGaugeNotFoundDelaySeconds} attribute
   */
  @JsonProperty("mbeanGaugeNotFoundDelaySeconds")
  @Override
  public int mbeanGaugeNotFoundDelaySeconds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.mbeanGaugeNotFoundDelaySeconds()
        : this.mbeanGaugeNotFoundDelaySeconds;
  }

  /**
   * @return The value of the {@code weavingTimer} attribute
   */
  @JsonProperty("weavingTimer")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public boolean weavingTimer() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.weavingTimer()
        : this.weavingTimer;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for immediatePartialStoreThresholdSeconds
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withImmediatePartialStoreThresholdSeconds(int value) {
    if (this.immediatePartialStoreThresholdSeconds == value) return this;
    return new ImmutableAdvancedConfig(
        value,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#maxTransactionAggregates() maxTransactionAggregates} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxTransactionAggregates
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMaxTransactionAggregates(int value) {
    if (this.maxTransactionAggregates == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        value,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#maxQueryAggregates() maxQueryAggregates} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxQueryAggregates
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMaxQueryAggregates(int value) {
    if (this.maxQueryAggregates == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        value,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#maxServiceCallAggregates() maxServiceCallAggregates} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxServiceCallAggregates
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMaxServiceCallAggregates(int value) {
    if (this.maxServiceCallAggregates == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        value,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxTraceEntriesPerTransaction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMaxTraceEntriesPerTransaction(int value) {
    if (this.maxTraceEntriesPerTransaction == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        value,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#maxProfileSamplesPerTransaction() maxProfileSamplesPerTransaction} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxProfileSamplesPerTransaction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMaxProfileSamplesPerTransaction(int value) {
    if (this.maxProfileSamplesPerTransaction == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        value,
        this.mbeanGaugeNotFoundDelaySeconds,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mbeanGaugeNotFoundDelaySeconds
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withMbeanGaugeNotFoundDelaySeconds(int value) {
    if (this.mbeanGaugeNotFoundDelaySeconds == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        value,
        this.weavingTimer);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AdvancedConfig#weavingTimer() weavingTimer} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for weavingTimer
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvancedConfig withWeavingTimer(boolean value) {
    if (this.weavingTimer == value) return this;
    return new ImmutableAdvancedConfig(
        this.immediatePartialStoreThresholdSeconds,
        this.maxTransactionAggregates,
        this.maxQueryAggregates,
        this.maxServiceCallAggregates,
        this.maxTraceEntriesPerTransaction,
        this.maxProfileSamplesPerTransaction,
        this.mbeanGaugeNotFoundDelaySeconds,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAdvancedConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAdvancedConfig
        && equalTo((ImmutableAdvancedConfig) another);
  }

  private boolean equalTo(ImmutableAdvancedConfig another) {
    return immediatePartialStoreThresholdSeconds == another.immediatePartialStoreThresholdSeconds
        && maxTransactionAggregates == another.maxTransactionAggregates
        && maxQueryAggregates == another.maxQueryAggregates
        && maxServiceCallAggregates == another.maxServiceCallAggregates
        && maxTraceEntriesPerTransaction == another.maxTraceEntriesPerTransaction
        && maxProfileSamplesPerTransaction == another.maxProfileSamplesPerTransaction
        && mbeanGaugeNotFoundDelaySeconds == another.mbeanGaugeNotFoundDelaySeconds
        && weavingTimer == another.weavingTimer;
  }

  /**
   * Computes a hash code from attributes: {@code immediatePartialStoreThresholdSeconds}, {@code maxTransactionAggregates}, {@code maxQueryAggregates}, {@code maxServiceCallAggregates}, {@code maxTraceEntriesPerTransaction}, {@code maxProfileSamplesPerTransaction}, {@code mbeanGaugeNotFoundDelaySeconds}, {@code weavingTimer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + immediatePartialStoreThresholdSeconds;
    h += (h << 5) + maxTransactionAggregates;
    h += (h << 5) + maxQueryAggregates;
    h += (h << 5) + maxServiceCallAggregates;
    h += (h << 5) + maxTraceEntriesPerTransaction;
    h += (h << 5) + maxProfileSamplesPerTransaction;
    h += (h << 5) + mbeanGaugeNotFoundDelaySeconds;
    h += (h << 5) + Booleans.hashCode(weavingTimer);
    return h;
  }

  /**
   * Prints the immutable value {@code AdvancedConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AdvancedConfig")
        .omitNullValues()
        .add("immediatePartialStoreThresholdSeconds", immediatePartialStoreThresholdSeconds)
        .add("maxTransactionAggregates", maxTransactionAggregates)
        .add("maxQueryAggregates", maxQueryAggregates)
        .add("maxServiceCallAggregates", maxServiceCallAggregates)
        .add("maxTraceEntriesPerTransaction", maxTraceEntriesPerTransaction)
        .add("maxProfileSamplesPerTransaction", maxProfileSamplesPerTransaction)
        .add("mbeanGaugeNotFoundDelaySeconds", mbeanGaugeNotFoundDelaySeconds)
        .add("weavingTimer", weavingTimer)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AdvancedConfig", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AdvancedConfig {
    int immediatePartialStoreThresholdSeconds;
    boolean immediatePartialStoreThresholdSecondsIsSet;
    int maxTransactionAggregates;
    boolean maxTransactionAggregatesIsSet;
    int maxQueryAggregates;
    boolean maxQueryAggregatesIsSet;
    int maxServiceCallAggregates;
    boolean maxServiceCallAggregatesIsSet;
    int maxTraceEntriesPerTransaction;
    boolean maxTraceEntriesPerTransactionIsSet;
    int maxProfileSamplesPerTransaction;
    boolean maxProfileSamplesPerTransactionIsSet;
    int mbeanGaugeNotFoundDelaySeconds;
    boolean mbeanGaugeNotFoundDelaySecondsIsSet;
    boolean weavingTimer;
    boolean weavingTimerIsSet;
    @JsonProperty("immediatePartialStoreThresholdSeconds")
    public void setImmediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
      this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
      this.immediatePartialStoreThresholdSecondsIsSet = true;
    }
    @JsonProperty("maxTransactionAggregates")
    public void setMaxTransactionAggregates(int maxTransactionAggregates) {
      this.maxTransactionAggregates = maxTransactionAggregates;
      this.maxTransactionAggregatesIsSet = true;
    }
    @JsonProperty("maxQueryAggregates")
    public void setMaxQueryAggregates(int maxQueryAggregates) {
      this.maxQueryAggregates = maxQueryAggregates;
      this.maxQueryAggregatesIsSet = true;
    }
    @JsonProperty("maxServiceCallAggregates")
    public void setMaxServiceCallAggregates(int maxServiceCallAggregates) {
      this.maxServiceCallAggregates = maxServiceCallAggregates;
      this.maxServiceCallAggregatesIsSet = true;
    }
    @JsonProperty("maxTraceEntriesPerTransaction")
    public void setMaxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
      this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
      this.maxTraceEntriesPerTransactionIsSet = true;
    }
    @JsonProperty("maxProfileSamplesPerTransaction")
    public void setMaxProfileSamplesPerTransaction(int maxProfileSamplesPerTransaction) {
      this.maxProfileSamplesPerTransaction = maxProfileSamplesPerTransaction;
      this.maxProfileSamplesPerTransactionIsSet = true;
    }
    @JsonProperty("mbeanGaugeNotFoundDelaySeconds")
    public void setMbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
      this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
      this.mbeanGaugeNotFoundDelaySecondsIsSet = true;
    }
    @JsonProperty("weavingTimer")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setWeavingTimer(boolean weavingTimer) {
      this.weavingTimer = weavingTimer;
      this.weavingTimerIsSet = true;
    }
    @Override
    public int immediatePartialStoreThresholdSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public int maxTransactionAggregates() { throw new UnsupportedOperationException(); }
    @Override
    public int maxQueryAggregates() { throw new UnsupportedOperationException(); }
    @Override
    public int maxServiceCallAggregates() { throw new UnsupportedOperationException(); }
    @Override
    public int maxTraceEntriesPerTransaction() { throw new UnsupportedOperationException(); }
    @Override
    public int maxProfileSamplesPerTransaction() { throw new UnsupportedOperationException(); }
    @Override
    public int mbeanGaugeNotFoundDelaySeconds() { throw new UnsupportedOperationException(); }
    @Override
    public boolean weavingTimer() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAdvancedConfig fromJson(Json json) {
    ImmutableAdvancedConfig.Builder builder = ImmutableAdvancedConfig.builder();
    if (json.immediatePartialStoreThresholdSecondsIsSet) {
      builder.immediatePartialStoreThresholdSeconds(json.immediatePartialStoreThresholdSeconds);
    }
    if (json.maxTransactionAggregatesIsSet) {
      builder.maxTransactionAggregates(json.maxTransactionAggregates);
    }
    if (json.maxQueryAggregatesIsSet) {
      builder.maxQueryAggregates(json.maxQueryAggregates);
    }
    if (json.maxServiceCallAggregatesIsSet) {
      builder.maxServiceCallAggregates(json.maxServiceCallAggregates);
    }
    if (json.maxTraceEntriesPerTransactionIsSet) {
      builder.maxTraceEntriesPerTransaction(json.maxTraceEntriesPerTransaction);
    }
    if (json.maxProfileSamplesPerTransactionIsSet) {
      builder.maxProfileSamplesPerTransaction(json.maxProfileSamplesPerTransaction);
    }
    if (json.mbeanGaugeNotFoundDelaySecondsIsSet) {
      builder.mbeanGaugeNotFoundDelaySeconds(json.mbeanGaugeNotFoundDelaySeconds);
    }
    if (json.weavingTimerIsSet) {
      builder.weavingTimer(json.weavingTimer);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AdvancedConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AdvancedConfig instance
   */
  public static ImmutableAdvancedConfig copyOf(AdvancedConfig instance) {
    if (instance instanceof ImmutableAdvancedConfig) {
      return (ImmutableAdvancedConfig) instance;
    }
    return ImmutableAdvancedConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAdvancedConfig ImmutableAdvancedConfig}.
   * <pre>
   * ImmutableAdvancedConfig.builder()
   *    .immediatePartialStoreThresholdSeconds(int) // optional {@link AdvancedConfig#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}
   *    .maxTransactionAggregates(int) // optional {@link AdvancedConfig#maxTransactionAggregates() maxTransactionAggregates}
   *    .maxQueryAggregates(int) // optional {@link AdvancedConfig#maxQueryAggregates() maxQueryAggregates}
   *    .maxServiceCallAggregates(int) // optional {@link AdvancedConfig#maxServiceCallAggregates() maxServiceCallAggregates}
   *    .maxTraceEntriesPerTransaction(int) // optional {@link AdvancedConfig#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}
   *    .maxProfileSamplesPerTransaction(int) // optional {@link AdvancedConfig#maxProfileSamplesPerTransaction() maxProfileSamplesPerTransaction}
   *    .mbeanGaugeNotFoundDelaySeconds(int) // optional {@link AdvancedConfig#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}
   *    .weavingTimer(boolean) // optional {@link AdvancedConfig#weavingTimer() weavingTimer}
   *    .build();
   * </pre>
   * @return A new ImmutableAdvancedConfig builder
   */
  public static ImmutableAdvancedConfig.Builder builder() {
    return new ImmutableAdvancedConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAdvancedConfig ImmutableAdvancedConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AdvancedConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS = 0x1L;
    private static final long OPT_BIT_MAX_TRANSACTION_AGGREGATES = 0x2L;
    private static final long OPT_BIT_MAX_QUERY_AGGREGATES = 0x4L;
    private static final long OPT_BIT_MAX_SERVICE_CALL_AGGREGATES = 0x8L;
    private static final long OPT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION = 0x10L;
    private static final long OPT_BIT_MAX_PROFILE_SAMPLES_PER_TRANSACTION = 0x20L;
    private static final long OPT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS = 0x40L;
    private static final long OPT_BIT_WEAVING_TIMER = 0x80L;
    private long optBits;

    private int immediatePartialStoreThresholdSeconds;
    private int maxTransactionAggregates;
    private int maxQueryAggregates;
    private int maxServiceCallAggregates;
    private int maxTraceEntriesPerTransaction;
    private int maxProfileSamplesPerTransaction;
    private int mbeanGaugeNotFoundDelaySeconds;
    private boolean weavingTimer;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AdvancedConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(AdvancedConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      immediatePartialStoreThresholdSeconds(instance.immediatePartialStoreThresholdSeconds());
      maxTransactionAggregates(instance.maxTransactionAggregates());
      maxQueryAggregates(instance.maxQueryAggregates());
      maxServiceCallAggregates(instance.maxServiceCallAggregates());
      maxTraceEntriesPerTransaction(instance.maxTraceEntriesPerTransaction());
      maxProfileSamplesPerTransaction(instance.maxProfileSamplesPerTransaction());
      mbeanGaugeNotFoundDelaySeconds(instance.mbeanGaugeNotFoundDelaySeconds());
      weavingTimer(instance.weavingTimer());
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#immediatePartialStoreThresholdSeconds() immediatePartialStoreThresholdSeconds}.</em>
     * @param immediatePartialStoreThresholdSeconds The value for immediatePartialStoreThresholdSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder immediatePartialStoreThresholdSeconds(int immediatePartialStoreThresholdSeconds) {
      this.immediatePartialStoreThresholdSeconds = immediatePartialStoreThresholdSeconds;
      optBits |= OPT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#maxTransactionAggregates() maxTransactionAggregates} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#maxTransactionAggregates() maxTransactionAggregates}.</em>
     * @param maxTransactionAggregates The value for maxTransactionAggregates 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxTransactionAggregates(int maxTransactionAggregates) {
      this.maxTransactionAggregates = maxTransactionAggregates;
      optBits |= OPT_BIT_MAX_TRANSACTION_AGGREGATES;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#maxQueryAggregates() maxQueryAggregates} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#maxQueryAggregates() maxQueryAggregates}.</em>
     * @param maxQueryAggregates The value for maxQueryAggregates 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxQueryAggregates(int maxQueryAggregates) {
      this.maxQueryAggregates = maxQueryAggregates;
      optBits |= OPT_BIT_MAX_QUERY_AGGREGATES;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#maxServiceCallAggregates() maxServiceCallAggregates} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#maxServiceCallAggregates() maxServiceCallAggregates}.</em>
     * @param maxServiceCallAggregates The value for maxServiceCallAggregates 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxServiceCallAggregates(int maxServiceCallAggregates) {
      this.maxServiceCallAggregates = maxServiceCallAggregates;
      optBits |= OPT_BIT_MAX_SERVICE_CALL_AGGREGATES;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#maxTraceEntriesPerTransaction() maxTraceEntriesPerTransaction}.</em>
     * @param maxTraceEntriesPerTransaction The value for maxTraceEntriesPerTransaction 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxTraceEntriesPerTransaction(int maxTraceEntriesPerTransaction) {
      this.maxTraceEntriesPerTransaction = maxTraceEntriesPerTransaction;
      optBits |= OPT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#maxProfileSamplesPerTransaction() maxProfileSamplesPerTransaction} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#maxProfileSamplesPerTransaction() maxProfileSamplesPerTransaction}.</em>
     * @param maxProfileSamplesPerTransaction The value for maxProfileSamplesPerTransaction 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxProfileSamplesPerTransaction(int maxProfileSamplesPerTransaction) {
      this.maxProfileSamplesPerTransaction = maxProfileSamplesPerTransaction;
      optBits |= OPT_BIT_MAX_PROFILE_SAMPLES_PER_TRANSACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#mbeanGaugeNotFoundDelaySeconds() mbeanGaugeNotFoundDelaySeconds}.</em>
     * @param mbeanGaugeNotFoundDelaySeconds The value for mbeanGaugeNotFoundDelaySeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mbeanGaugeNotFoundDelaySeconds(int mbeanGaugeNotFoundDelaySeconds) {
      this.mbeanGaugeNotFoundDelaySeconds = mbeanGaugeNotFoundDelaySeconds;
      optBits |= OPT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link AdvancedConfig#weavingTimer() weavingTimer} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AdvancedConfig#weavingTimer() weavingTimer}.</em>
     * @param weavingTimer The value for weavingTimer 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder weavingTimer(boolean weavingTimer) {
      this.weavingTimer = weavingTimer;
      optBits |= OPT_BIT_WEAVING_TIMER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAdvancedConfig ImmutableAdvancedConfig}.
     * @return An immutable instance of AdvancedConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAdvancedConfig build() {
      return new ImmutableAdvancedConfig(this);
    }

    private boolean immediatePartialStoreThresholdSecondsIsSet() {
      return (optBits & OPT_BIT_IMMEDIATE_PARTIAL_STORE_THRESHOLD_SECONDS) != 0;
    }

    private boolean maxTransactionAggregatesIsSet() {
      return (optBits & OPT_BIT_MAX_TRANSACTION_AGGREGATES) != 0;
    }

    private boolean maxQueryAggregatesIsSet() {
      return (optBits & OPT_BIT_MAX_QUERY_AGGREGATES) != 0;
    }

    private boolean maxServiceCallAggregatesIsSet() {
      return (optBits & OPT_BIT_MAX_SERVICE_CALL_AGGREGATES) != 0;
    }

    private boolean maxTraceEntriesPerTransactionIsSet() {
      return (optBits & OPT_BIT_MAX_TRACE_ENTRIES_PER_TRANSACTION) != 0;
    }

    private boolean maxProfileSamplesPerTransactionIsSet() {
      return (optBits & OPT_BIT_MAX_PROFILE_SAMPLES_PER_TRANSACTION) != 0;
    }

    private boolean mbeanGaugeNotFoundDelaySecondsIsSet() {
      return (optBits & OPT_BIT_MBEAN_GAUGE_NOT_FOUND_DELAY_SECONDS) != 0;
    }

    private boolean weavingTimerIsSet() {
      return (optBits & OPT_BIT_WEAVING_TIMER) != 0;
    }
  }
}
