package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JvmConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJvmConfig.builder()}.
 */
@Generated(from = "JvmConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableJvmConfig extends JvmConfig {
  private final ImmutableList<String> maskSystemProperties;
  private final ImmutableList<String> maskMBeanAttributes;

  private ImmutableJvmConfig(ImmutableJvmConfig.Builder builder) {
    if (builder.maskSystemPropertiesIsSet()) {
      initShim.maskSystemProperties(builder.maskSystemProperties.build());
    }
    if (builder.maskMBeanAttributesIsSet()) {
      initShim.maskMBeanAttributes(builder.maskMBeanAttributes.build());
    }
    this.maskSystemProperties = initShim.maskSystemProperties();
    this.maskMBeanAttributes = initShim.maskMBeanAttributes();
    this.initShim = null;
  }

  private ImmutableJvmConfig(
      ImmutableList<String> maskSystemProperties,
      ImmutableList<String> maskMBeanAttributes) {
    this.maskSystemProperties = maskSystemProperties;
    this.maskMBeanAttributes = maskMBeanAttributes;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "JvmConfig", generator = "Immutables")
  private final class InitShim {
    private byte maskSystemPropertiesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> maskSystemProperties;

    ImmutableList<String> maskSystemProperties() {
      if (maskSystemPropertiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maskSystemPropertiesBuildStage == STAGE_UNINITIALIZED) {
        maskSystemPropertiesBuildStage = STAGE_INITIALIZING;
        this.maskSystemProperties = Preconditions.checkNotNull(ImmutableJvmConfig.super.maskSystemProperties(), "maskSystemProperties");
        maskSystemPropertiesBuildStage = STAGE_INITIALIZED;
      }
      return this.maskSystemProperties;
    }

    void maskSystemProperties(ImmutableList<String> maskSystemProperties) {
      this.maskSystemProperties = maskSystemProperties;
      maskSystemPropertiesBuildStage = STAGE_INITIALIZED;
    }

    private byte maskMBeanAttributesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> maskMBeanAttributes;

    ImmutableList<String> maskMBeanAttributes() {
      if (maskMBeanAttributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maskMBeanAttributesBuildStage == STAGE_UNINITIALIZED) {
        maskMBeanAttributesBuildStage = STAGE_INITIALIZING;
        this.maskMBeanAttributes = Preconditions.checkNotNull(ImmutableJvmConfig.super.maskMBeanAttributes(), "maskMBeanAttributes");
        maskMBeanAttributesBuildStage = STAGE_INITIALIZED;
      }
      return this.maskMBeanAttributes;
    }

    void maskMBeanAttributes(ImmutableList<String> maskMBeanAttributes) {
      this.maskMBeanAttributes = maskMBeanAttributes;
      maskMBeanAttributesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<String>();
      if (maskSystemPropertiesBuildStage == STAGE_INITIALIZING) attributes.add("maskSystemProperties");
      if (maskMBeanAttributesBuildStage == STAGE_INITIALIZING) attributes.add("maskMBeanAttributes");
      return "Cannot build JvmConfig, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code maskSystemProperties} attribute
   */
  @JsonProperty("maskSystemProperties")
  @Override
  public ImmutableList<String> maskSystemProperties() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maskSystemProperties()
        : this.maskSystemProperties;
  }

  /**
   * @return The value of the {@code maskMBeanAttributes} attribute
   */
  @JsonProperty("maskMBeanAttributes")
  @Override
  public ImmutableList<String> maskMBeanAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maskMBeanAttributes()
        : this.maskMBeanAttributes;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JvmConfig#maskSystemProperties() maskSystemProperties}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJvmConfig withMaskSystemProperties(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableJvmConfig(newValue, this.maskMBeanAttributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JvmConfig#maskSystemProperties() maskSystemProperties}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of maskSystemProperties elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJvmConfig withMaskSystemProperties(Iterable<String> elements) {
    if (this.maskSystemProperties == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableJvmConfig(newValue, this.maskMBeanAttributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJvmConfig withMaskMBeanAttributes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableJvmConfig(this.maskSystemProperties, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of maskMBeanAttributes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJvmConfig withMaskMBeanAttributes(Iterable<String> elements) {
    if (this.maskMBeanAttributes == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableJvmConfig(this.maskSystemProperties, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJvmConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJvmConfig
        && equalTo((ImmutableJvmConfig) another);
  }

  private boolean equalTo(ImmutableJvmConfig another) {
    return maskSystemProperties.equals(another.maskSystemProperties)
        && maskMBeanAttributes.equals(another.maskMBeanAttributes);
  }

  /**
   * Computes a hash code from attributes: {@code maskSystemProperties}, {@code maskMBeanAttributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + maskSystemProperties.hashCode();
    h += (h << 5) + maskMBeanAttributes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JvmConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JvmConfig")
        .omitNullValues()
        .add("maskSystemProperties", maskSystemProperties)
        .add("maskMBeanAttributes", maskMBeanAttributes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JvmConfig", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends JvmConfig {
    @Nullable ImmutableList<String> maskSystemProperties = ImmutableList.of();
    boolean maskSystemPropertiesIsSet;
    @Nullable ImmutableList<String> maskMBeanAttributes = ImmutableList.of();
    boolean maskMBeanAttributesIsSet;
    @JsonProperty("maskSystemProperties")
    public void setMaskSystemProperties(ImmutableList<String> maskSystemProperties) {
      this.maskSystemProperties = maskSystemProperties;
      this.maskSystemPropertiesIsSet = true;
    }
    @JsonProperty("maskMBeanAttributes")
    public void setMaskMBeanAttributes(ImmutableList<String> maskMBeanAttributes) {
      this.maskMBeanAttributes = maskMBeanAttributes;
      this.maskMBeanAttributesIsSet = true;
    }
    @Override
    public ImmutableList<String> maskSystemProperties() { throw new UnsupportedOperationException(); }
    @Override
    public ImmutableList<String> maskMBeanAttributes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJvmConfig fromJson(Json json) {
    ImmutableJvmConfig.Builder builder = ImmutableJvmConfig.builder();
    if (json.maskSystemPropertiesIsSet) {
      builder.addAllMaskSystemProperties(json.maskSystemProperties);
    }
    if (json.maskMBeanAttributesIsSet) {
      builder.addAllMaskMBeanAttributes(json.maskMBeanAttributes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JvmConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JvmConfig instance
   */
  public static ImmutableJvmConfig copyOf(JvmConfig instance) {
    if (instance instanceof ImmutableJvmConfig) {
      return (ImmutableJvmConfig) instance;
    }
    return ImmutableJvmConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJvmConfig ImmutableJvmConfig}.
   * <pre>
   * ImmutableJvmConfig.builder()
   *    .addMaskSystemProperties|addAllMaskSystemProperties(String) // {@link JvmConfig#maskSystemProperties() maskSystemProperties} elements
   *    .addMaskMBeanAttributes|addAllMaskMBeanAttributes(String) // {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJvmConfig builder
   */
  public static ImmutableJvmConfig.Builder builder() {
    return new ImmutableJvmConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJvmConfig ImmutableJvmConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JvmConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_MASK_SYSTEM_PROPERTIES = 0x1L;
    private static final long OPT_BIT_MASK_M_BEAN_ATTRIBUTES = 0x2L;
    private long optBits;

    private ImmutableList.Builder<String> maskSystemProperties = ImmutableList.builder();
    private ImmutableList.Builder<String> maskMBeanAttributes = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JvmConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(JvmConfig instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllMaskSystemProperties(instance.maskSystemProperties());
      addAllMaskMBeanAttributes(instance.maskMBeanAttributes());
      return this;
    }

    /**
     * Adds one element to {@link JvmConfig#maskSystemProperties() maskSystemProperties} list.
     * @param element A maskSystemProperties element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMaskSystemProperties(String element) {
      this.maskSystemProperties.add(element);
      optBits |= OPT_BIT_MASK_SYSTEM_PROPERTIES;
      return this;
    }

    /**
     * Adds elements to {@link JvmConfig#maskSystemProperties() maskSystemProperties} list.
     * @param elements An array of maskSystemProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMaskSystemProperties(String... elements) {
      this.maskSystemProperties.add(elements);
      optBits |= OPT_BIT_MASK_SYSTEM_PROPERTIES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JvmConfig#maskSystemProperties() maskSystemProperties} list.
     * @param elements An iterable of maskSystemProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maskSystemProperties(Iterable<String> elements) {
      this.maskSystemProperties = ImmutableList.builder();
      return addAllMaskSystemProperties(elements);
    }

    /**
     * Adds elements to {@link JvmConfig#maskSystemProperties() maskSystemProperties} list.
     * @param elements An iterable of maskSystemProperties elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMaskSystemProperties(Iterable<String> elements) {
      this.maskSystemProperties.addAll(elements);
      optBits |= OPT_BIT_MASK_SYSTEM_PROPERTIES;
      return this;
    }

    /**
     * Adds one element to {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes} list.
     * @param element A maskMBeanAttributes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMaskMBeanAttributes(String element) {
      this.maskMBeanAttributes.add(element);
      optBits |= OPT_BIT_MASK_M_BEAN_ATTRIBUTES;
      return this;
    }

    /**
     * Adds elements to {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes} list.
     * @param elements An array of maskMBeanAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMaskMBeanAttributes(String... elements) {
      this.maskMBeanAttributes.add(elements);
      optBits |= OPT_BIT_MASK_M_BEAN_ATTRIBUTES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes} list.
     * @param elements An iterable of maskMBeanAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maskMBeanAttributes(Iterable<String> elements) {
      this.maskMBeanAttributes = ImmutableList.builder();
      return addAllMaskMBeanAttributes(elements);
    }

    /**
     * Adds elements to {@link JvmConfig#maskMBeanAttributes() maskMBeanAttributes} list.
     * @param elements An iterable of maskMBeanAttributes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMaskMBeanAttributes(Iterable<String> elements) {
      this.maskMBeanAttributes.addAll(elements);
      optBits |= OPT_BIT_MASK_M_BEAN_ATTRIBUTES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJvmConfig ImmutableJvmConfig}.
     * @return An immutable instance of JvmConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJvmConfig build() {
      return new ImmutableJvmConfig(this);
    }

    private boolean maskSystemPropertiesIsSet() {
      return (optBits & OPT_BIT_MASK_SYSTEM_PROPERTIES) != 0;
    }

    private boolean maskMBeanAttributesIsSet() {
      return (optBits & OPT_BIT_MASK_M_BEAN_ATTRIBUTES) != 0;
    }
  }
}
