package org.glowroot.agent.shaded.org.glowroot.common.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveAggregateRepository.OverviewAggregate}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOverviewAggregate.builder()}.
 */
@Generated(from = "LiveAggregateRepository.OverviewAggregate", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOverviewAggregate
    implements LiveAggregateRepository.OverviewAggregate {
  private final long captureTime;
  private final double totalDurationNanos;
  private final long transactionCount;
  private final boolean asyncTransactions;
  private final ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers;
  private final AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
  private final @Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
  private final @Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
  private final ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers;

  private ImmutableOverviewAggregate(
      long captureTime,
      double totalDurationNanos,
      long transactionCount,
      boolean asyncTransactions,
      ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers,
      AggregateOuterClass.Aggregate.ThreadStats mainThreadStats,
      @Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer,
      @Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats,
      ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers) {
    this.captureTime = captureTime;
    this.totalDurationNanos = totalDurationNanos;
    this.transactionCount = transactionCount;
    this.asyncTransactions = asyncTransactions;
    this.mainThreadRootTimers = mainThreadRootTimers;
    this.mainThreadStats = mainThreadStats;
    this.auxThreadRootTimer = auxThreadRootTimer;
    this.auxThreadStats = auxThreadStats;
    this.asyncTimers = asyncTimers;
  }

  /**
   * @return The value of the {@code captureTime} attribute
   */
  @JsonProperty("captureTime")
  @Override
  public long captureTime() {
    return captureTime;
  }

  /**
   * @return The value of the {@code totalDurationNanos} attribute
   */
  @JsonProperty("totalDurationNanos")
  @Override
  public double totalDurationNanos() {
    return totalDurationNanos;
  }

  /**
   * @return The value of the {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }

  /**
   * @return The value of the {@code asyncTransactions} attribute
   */
  @JsonProperty("asyncTransactions")
  @Override
  public boolean asyncTransactions() {
    return asyncTransactions;
  }

  /**
   * @return The value of the {@code mainThreadRootTimers} attribute
   */
  @JsonProperty("mainThreadRootTimers")
  @Override
  public ImmutableList<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers() {
    return mainThreadRootTimers;
  }

  /**
   * @return The value of the {@code mainThreadStats} attribute
   */
  @JsonProperty("mainThreadStats")
  @Override
  public AggregateOuterClass.Aggregate.ThreadStats mainThreadStats() {
    return mainThreadStats;
  }

  /**
   * @return The value of the {@code auxThreadRootTimer} attribute
   */
  @JsonProperty("auxThreadRootTimer")
  @Override
  public @Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer() {
    return auxThreadRootTimer;
  }

  /**
   * @return The value of the {@code auxThreadStats} attribute
   */
  @JsonProperty("auxThreadStats")
  @Override
  public @Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats() {
    return auxThreadStats;
  }

  /**
   * @return The value of the {@code asyncTimers} attribute
   */
  @JsonProperty("asyncTimers")
  @Override
  public ImmutableList<AggregateOuterClass.Aggregate.Timer> asyncTimers() {
    return asyncTimers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#captureTime() captureTime} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for captureTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withCaptureTime(long value) {
    if (this.captureTime == value) return this;
    return new ImmutableOverviewAggregate(
        value,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#totalDurationNanos() totalDurationNanos} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalDurationNanos
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withTotalDurationNanos(double value) {
    if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) return this;
    return new ImmutableOverviewAggregate(
        this.captureTime,
        value,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#transactionCount() transactionCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withTransactionCount(long value) {
    if (this.transactionCount == value) return this;
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        value,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#asyncTransactions() asyncTransactions} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for asyncTransactions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withAsyncTransactions(boolean value) {
    if (this.asyncTransactions == value) return this;
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        value,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOverviewAggregate withMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer... elements) {
    ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        newValue,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mainThreadRootTimers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOverviewAggregate withMainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
    if (this.mainThreadRootTimers == elements) return this;
    ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        newValue,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#mainThreadStats() mainThreadStats} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mainThreadStats
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withMainThreadStats(AggregateOuterClass.Aggregate.ThreadStats value) {
    if (this.mainThreadStats == value) return this;
    AggregateOuterClass.Aggregate.ThreadStats newValue = Preconditions.checkNotNull(value, "mainThreadStats");
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        newValue,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#auxThreadRootTimer() auxThreadRootTimer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for auxThreadRootTimer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withAuxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer value) {
    if (this.auxThreadRootTimer == value) return this;
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        value,
        this.auxThreadStats,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveAggregateRepository.OverviewAggregate#auxThreadStats() auxThreadStats} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for auxThreadStats (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOverviewAggregate withAuxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats value) {
    if (this.auxThreadStats == value) return this;
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        value,
        this.asyncTimers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOverviewAggregate withAsyncTimers(AggregateOuterClass.Aggregate.Timer... elements) {
    ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of asyncTimers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOverviewAggregate withAsyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
    if (this.asyncTimers == elements) return this;
    ImmutableList<AggregateOuterClass.Aggregate.Timer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableOverviewAggregate(
        this.captureTime,
        this.totalDurationNanos,
        this.transactionCount,
        this.asyncTransactions,
        this.mainThreadRootTimers,
        this.mainThreadStats,
        this.auxThreadRootTimer,
        this.auxThreadStats,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOverviewAggregate} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOverviewAggregate
        && equalTo((ImmutableOverviewAggregate) another);
  }

  private boolean equalTo(ImmutableOverviewAggregate another) {
    return captureTime == another.captureTime
        && Double.doubleToLongBits(totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos)
        && transactionCount == another.transactionCount
        && asyncTransactions == another.asyncTransactions
        && mainThreadRootTimers.equals(another.mainThreadRootTimers)
        && mainThreadStats.equals(another.mainThreadStats)
        && Objects.equal(auxThreadRootTimer, another.auxThreadRootTimer)
        && Objects.equal(auxThreadStats, another.auxThreadStats)
        && asyncTimers.equals(another.asyncTimers);
  }

  /**
   * Computes a hash code from attributes: {@code captureTime}, {@code totalDurationNanos}, {@code transactionCount}, {@code asyncTransactions}, {@code mainThreadRootTimers}, {@code mainThreadStats}, {@code auxThreadRootTimer}, {@code auxThreadStats}, {@code asyncTimers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Longs.hashCode(captureTime);
    h += (h << 5) + Doubles.hashCode(totalDurationNanos);
    h += (h << 5) + Longs.hashCode(transactionCount);
    h += (h << 5) + Booleans.hashCode(asyncTransactions);
    h += (h << 5) + mainThreadRootTimers.hashCode();
    h += (h << 5) + mainThreadStats.hashCode();
    h += (h << 5) + Objects.hashCode(auxThreadRootTimer);
    h += (h << 5) + Objects.hashCode(auxThreadStats);
    h += (h << 5) + asyncTimers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OverviewAggregate} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OverviewAggregate")
        .omitNullValues()
        .add("captureTime", captureTime)
        .add("totalDurationNanos", totalDurationNanos)
        .add("transactionCount", transactionCount)
        .add("asyncTransactions", asyncTransactions)
        .add("mainThreadRootTimers", mainThreadRootTimers)
        .add("mainThreadStats", mainThreadStats)
        .add("auxThreadRootTimer", auxThreadRootTimer)
        .add("auxThreadStats", auxThreadStats)
        .add("asyncTimers", asyncTimers)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveAggregateRepository.OverviewAggregate", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LiveAggregateRepository.OverviewAggregate {
    long captureTime;
    boolean captureTimeIsSet;
    double totalDurationNanos;
    boolean totalDurationNanosIsSet;
    long transactionCount;
    boolean transactionCountIsSet;
    boolean asyncTransactions;
    boolean asyncTransactionsIsSet;
    @org.glowroot.agent.shaded.javax.annotation.Nullable List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers = ImmutableList.of();
    @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
    @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
    @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
    @org.glowroot.agent.shaded.javax.annotation.Nullable List<AggregateOuterClass.Aggregate.Timer> asyncTimers = ImmutableList.of();
    @JsonProperty("captureTime")
    public void setCaptureTime(long captureTime) {
      this.captureTime = captureTime;
      this.captureTimeIsSet = true;
    }
    @JsonProperty("totalDurationNanos")
    public void setTotalDurationNanos(double totalDurationNanos) {
      this.totalDurationNanos = totalDurationNanos;
      this.totalDurationNanosIsSet = true;
    }
    @JsonProperty("transactionCount")
    public void setTransactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      this.transactionCountIsSet = true;
    }
    @JsonProperty("asyncTransactions")
    public void setAsyncTransactions(boolean asyncTransactions) {
      this.asyncTransactions = asyncTransactions;
      this.asyncTransactionsIsSet = true;
    }
    @JsonProperty("mainThreadRootTimers")
    public void setMainThreadRootTimers(List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers) {
      this.mainThreadRootTimers = mainThreadRootTimers;
    }
    @JsonProperty("mainThreadStats")
    public void setMainThreadStats(AggregateOuterClass.Aggregate.ThreadStats mainThreadStats) {
      this.mainThreadStats = mainThreadStats;
    }
    @JsonProperty("auxThreadRootTimer")
    public void setAuxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer) {
      this.auxThreadRootTimer = auxThreadRootTimer;
    }
    @JsonProperty("auxThreadStats")
    public void setAuxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats) {
      this.auxThreadStats = auxThreadStats;
    }
    @JsonProperty("asyncTimers")
    public void setAsyncTimers(List<AggregateOuterClass.Aggregate.Timer> asyncTimers) {
      this.asyncTimers = asyncTimers;
    }
    @Override
    public long captureTime() { throw new UnsupportedOperationException(); }
    @Override
    public double totalDurationNanos() { throw new UnsupportedOperationException(); }
    @Override
    public long transactionCount() { throw new UnsupportedOperationException(); }
    @Override
    public boolean asyncTransactions() { throw new UnsupportedOperationException(); }
    @Override
    public List<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers() { throw new UnsupportedOperationException(); }
    @Override
    public AggregateOuterClass.Aggregate.ThreadStats mainThreadStats() { throw new UnsupportedOperationException(); }
    @Override
    public AggregateOuterClass.Aggregate.Timer auxThreadRootTimer() { throw new UnsupportedOperationException(); }
    @Override
    public AggregateOuterClass.Aggregate.ThreadStats auxThreadStats() { throw new UnsupportedOperationException(); }
    @Override
    public List<AggregateOuterClass.Aggregate.Timer> asyncTimers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOverviewAggregate fromJson(Json json) {
    ImmutableOverviewAggregate.Builder builder = ImmutableOverviewAggregate.builder();
    if (json.captureTimeIsSet) {
      builder.captureTime(json.captureTime);
    }
    if (json.totalDurationNanosIsSet) {
      builder.totalDurationNanos(json.totalDurationNanos);
    }
    if (json.transactionCountIsSet) {
      builder.transactionCount(json.transactionCount);
    }
    if (json.asyncTransactionsIsSet) {
      builder.asyncTransactions(json.asyncTransactions);
    }
    if (json.mainThreadRootTimers != null) {
      builder.addAllMainThreadRootTimers(json.mainThreadRootTimers);
    }
    if (json.mainThreadStats != null) {
      builder.mainThreadStats(json.mainThreadStats);
    }
    if (json.auxThreadRootTimer != null) {
      builder.auxThreadRootTimer(json.auxThreadRootTimer);
    }
    if (json.auxThreadStats != null) {
      builder.auxThreadStats(json.auxThreadStats);
    }
    if (json.asyncTimers != null) {
      builder.addAllAsyncTimers(json.asyncTimers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveAggregateRepository.OverviewAggregate} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OverviewAggregate instance
   */
  public static ImmutableOverviewAggregate copyOf(LiveAggregateRepository.OverviewAggregate instance) {
    if (instance instanceof ImmutableOverviewAggregate) {
      return (ImmutableOverviewAggregate) instance;
    }
    return ImmutableOverviewAggregate.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOverviewAggregate ImmutableOverviewAggregate}.
   * <pre>
   * ImmutableOverviewAggregate.builder()
   *    .captureTime(long) // required {@link LiveAggregateRepository.OverviewAggregate#captureTime() captureTime}
   *    .totalDurationNanos(double) // required {@link LiveAggregateRepository.OverviewAggregate#totalDurationNanos() totalDurationNanos}
   *    .transactionCount(long) // required {@link LiveAggregateRepository.OverviewAggregate#transactionCount() transactionCount}
   *    .asyncTransactions(boolean) // required {@link LiveAggregateRepository.OverviewAggregate#asyncTransactions() asyncTransactions}
   *    .addMainThreadRootTimers|addAllMainThreadRootTimers(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.Timer) // {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers} elements
   *    .mainThreadStats(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.ThreadStats) // required {@link LiveAggregateRepository.OverviewAggregate#mainThreadStats() mainThreadStats}
   *    .auxThreadRootTimer(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.Timer | null) // nullable {@link LiveAggregateRepository.OverviewAggregate#auxThreadRootTimer() auxThreadRootTimer}
   *    .auxThreadStats(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.ThreadStats | null) // nullable {@link LiveAggregateRepository.OverviewAggregate#auxThreadStats() auxThreadStats}
   *    .addAsyncTimers|addAllAsyncTimers(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.Timer) // {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOverviewAggregate builder
   */
  public static ImmutableOverviewAggregate.Builder builder() {
    return new ImmutableOverviewAggregate.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOverviewAggregate ImmutableOverviewAggregate}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveAggregateRepository.OverviewAggregate", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CAPTURE_TIME = 0x1L;
    private static final long INIT_BIT_TOTAL_DURATION_NANOS = 0x2L;
    private static final long INIT_BIT_TRANSACTION_COUNT = 0x4L;
    private static final long INIT_BIT_ASYNC_TRANSACTIONS = 0x8L;
    private static final long INIT_BIT_MAIN_THREAD_STATS = 0x10L;
    private long initBits = 0x1fL;

    private long captureTime;
    private double totalDurationNanos;
    private long transactionCount;
    private boolean asyncTransactions;
    private ImmutableList.Builder<AggregateOuterClass.Aggregate.Timer> mainThreadRootTimers = ImmutableList.builder();
    private @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.ThreadStats mainThreadStats;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer;
    private @org.glowroot.agent.shaded.javax.annotation.Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats;
    private ImmutableList.Builder<AggregateOuterClass.Aggregate.Timer> asyncTimers = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OverviewAggregate} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(LiveAggregateRepository.OverviewAggregate instance) {
      Preconditions.checkNotNull(instance, "instance");
      captureTime(instance.captureTime());
      totalDurationNanos(instance.totalDurationNanos());
      transactionCount(instance.transactionCount());
      asyncTransactions(instance.asyncTransactions());
      addAllMainThreadRootTimers(instance.mainThreadRootTimers());
      mainThreadStats(instance.mainThreadStats());
      @Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimerValue = instance.auxThreadRootTimer();
      if (auxThreadRootTimerValue != null) {
        auxThreadRootTimer(auxThreadRootTimerValue);
      }
      @Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStatsValue = instance.auxThreadStats();
      if (auxThreadStatsValue != null) {
        auxThreadStats(auxThreadStatsValue);
      }
      addAllAsyncTimers(instance.asyncTimers());
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#captureTime() captureTime} attribute.
     * @param captureTime The value for captureTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initBits &= ~INIT_BIT_CAPTURE_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#totalDurationNanos() totalDurationNanos} attribute.
     * @param totalDurationNanos The value for totalDurationNanos 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalDurationNanos(double totalDurationNanos) {
      this.totalDurationNanos = totalDurationNanos;
      initBits &= ~INIT_BIT_TOTAL_DURATION_NANOS;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#transactionCount() transactionCount} attribute.
     * @param transactionCount The value for transactionCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initBits &= ~INIT_BIT_TRANSACTION_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#asyncTransactions() asyncTransactions} attribute.
     * @param asyncTransactions The value for asyncTransactions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder asyncTransactions(boolean asyncTransactions) {
      this.asyncTransactions = asyncTransactions;
      initBits &= ~INIT_BIT_ASYNC_TRANSACTIONS;
      return this;
    }

    /**
     * Adds one element to {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers} list.
     * @param element A mainThreadRootTimers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer element) {
      this.mainThreadRootTimers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers} list.
     * @param elements An array of mainThreadRootTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMainThreadRootTimers(AggregateOuterClass.Aggregate.Timer... elements) {
      this.mainThreadRootTimers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers} list.
     * @param elements An iterable of mainThreadRootTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
      this.mainThreadRootTimers = ImmutableList.builder();
      return addAllMainThreadRootTimers(elements);
    }

    /**
     * Adds elements to {@link LiveAggregateRepository.OverviewAggregate#mainThreadRootTimers() mainThreadRootTimers} list.
     * @param elements An iterable of mainThreadRootTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMainThreadRootTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
      this.mainThreadRootTimers.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#mainThreadStats() mainThreadStats} attribute.
     * @param mainThreadStats The value for mainThreadStats 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mainThreadStats(AggregateOuterClass.Aggregate.ThreadStats mainThreadStats) {
      this.mainThreadStats = Preconditions.checkNotNull(mainThreadStats, "mainThreadStats");
      initBits &= ~INIT_BIT_MAIN_THREAD_STATS;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#auxThreadRootTimer() auxThreadRootTimer} attribute.
     * @param auxThreadRootTimer The value for auxThreadRootTimer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auxThreadRootTimer(@Nullable AggregateOuterClass.Aggregate.Timer auxThreadRootTimer) {
      this.auxThreadRootTimer = auxThreadRootTimer;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveAggregateRepository.OverviewAggregate#auxThreadStats() auxThreadStats} attribute.
     * @param auxThreadStats The value for auxThreadStats (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auxThreadStats(@Nullable AggregateOuterClass.Aggregate.ThreadStats auxThreadStats) {
      this.auxThreadStats = auxThreadStats;
      return this;
    }

    /**
     * Adds one element to {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers} list.
     * @param element A asyncTimers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAsyncTimers(AggregateOuterClass.Aggregate.Timer element) {
      this.asyncTimers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers} list.
     * @param elements An array of asyncTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAsyncTimers(AggregateOuterClass.Aggregate.Timer... elements) {
      this.asyncTimers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers} list.
     * @param elements An iterable of asyncTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder asyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
      this.asyncTimers = ImmutableList.builder();
      return addAllAsyncTimers(elements);
    }

    /**
     * Adds elements to {@link LiveAggregateRepository.OverviewAggregate#asyncTimers() asyncTimers} list.
     * @param elements An iterable of asyncTimers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAsyncTimers(Iterable<? extends AggregateOuterClass.Aggregate.Timer> elements) {
      this.asyncTimers.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOverviewAggregate ImmutableOverviewAggregate}.
     * @return An immutable instance of OverviewAggregate
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOverviewAggregate build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOverviewAggregate(
          captureTime,
          totalDurationNanos,
          transactionCount,
          asyncTransactions,
          mainThreadRootTimers.build(),
          mainThreadStats,
          auxThreadRootTimer,
          auxThreadStats,
          asyncTimers.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CAPTURE_TIME) != 0) attributes.add("captureTime");
      if ((initBits & INIT_BIT_TOTAL_DURATION_NANOS) != 0) attributes.add("totalDurationNanos");
      if ((initBits & INIT_BIT_TRANSACTION_COUNT) != 0) attributes.add("transactionCount");
      if ((initBits & INIT_BIT_ASYNC_TRANSACTIONS) != 0) attributes.add("asyncTransactions");
      if ((initBits & INIT_BIT_MAIN_THREAD_STATS) != 0) attributes.add("mainThreadStats");
      return "Cannot build OverviewAggregate, some of required attributes are not set " + attributes;
    }
  }
}
