package org.glowroot.agent.shaded.org.glowroot.common.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveTraceRepository.Queries}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueries.builder()}.
 */
@Generated(from = "LiveTraceRepository.Queries", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQueries implements LiveTraceRepository.Queries {
  private final ImmutableList<AggregateOuterClass.Aggregate.Query> queries;
  private final ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts;

  private ImmutableQueries(
      ImmutableList<AggregateOuterClass.Aggregate.Query> queries,
      ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) {
    this.queries = queries;
    this.sharedQueryTexts = sharedQueryTexts;
  }

  /**
   * @return The value of the {@code queries} attribute
   */
  @JsonProperty("queries")
  @Override
  public ImmutableList<AggregateOuterClass.Aggregate.Query> queries() {
    return queries;
  }

  /**
   * @return The value of the {@code sharedQueryTexts} attribute
   */
  @JsonProperty("sharedQueryTexts")
  @Override
  public ImmutableList<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts() {
    return sharedQueryTexts;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.Queries#queries() queries}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueries withQueries(AggregateOuterClass.Aggregate.Query... elements) {
    ImmutableList<AggregateOuterClass.Aggregate.Query> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueries(newValue, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.Queries#queries() queries}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of queries elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueries withQueries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
    if (this.queries == elements) return this;
    ImmutableList<AggregateOuterClass.Aggregate.Query> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueries(newValue, this.sharedQueryTexts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueries withSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText... elements) {
    ImmutableList<TraceOuterClass.Trace.SharedQueryText> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueries(this.queries, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sharedQueryTexts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueries withSharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
    if (this.sharedQueryTexts == elements) return this;
    ImmutableList<TraceOuterClass.Trace.SharedQueryText> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueries(this.queries, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueries} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueries
        && equalTo((ImmutableQueries) another);
  }

  private boolean equalTo(ImmutableQueries another) {
    return queries.equals(another.queries)
        && sharedQueryTexts.equals(another.sharedQueryTexts);
  }

  /**
   * Computes a hash code from attributes: {@code queries}, {@code sharedQueryTexts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + queries.hashCode();
    h += (h << 5) + sharedQueryTexts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Queries} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Queries")
        .omitNullValues()
        .add("queries", queries)
        .add("sharedQueryTexts", sharedQueryTexts)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveTraceRepository.Queries", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LiveTraceRepository.Queries {
    @Nullable List<AggregateOuterClass.Aggregate.Query> queries = ImmutableList.of();
    @Nullable List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts = ImmutableList.of();
    @JsonProperty("queries")
    public void setQueries(List<AggregateOuterClass.Aggregate.Query> queries) {
      this.queries = queries;
    }
    @JsonProperty("sharedQueryTexts")
    public void setSharedQueryTexts(List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts) {
      this.sharedQueryTexts = sharedQueryTexts;
    }
    @Override
    public List<AggregateOuterClass.Aggregate.Query> queries() { throw new UnsupportedOperationException(); }
    @Override
    public List<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQueries fromJson(Json json) {
    ImmutableQueries.Builder builder = ImmutableQueries.builder();
    if (json.queries != null) {
      builder.addAllQueries(json.queries);
    }
    if (json.sharedQueryTexts != null) {
      builder.addAllSharedQueryTexts(json.sharedQueryTexts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveTraceRepository.Queries} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Queries instance
   */
  public static ImmutableQueries copyOf(LiveTraceRepository.Queries instance) {
    if (instance instanceof ImmutableQueries) {
      return (ImmutableQueries) instance;
    }
    return ImmutableQueries.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueries ImmutableQueries}.
   * <pre>
   * ImmutableQueries.builder()
   *    .addQueries|addAllQueries(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass.Aggregate.Query) // {@link LiveTraceRepository.Queries#queries() queries} elements
   *    .addSharedQueryTexts|addAllSharedQueryTexts(org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass.Trace.SharedQueryText) // {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts} elements
   *    .build();
   * </pre>
   * @return A new ImmutableQueries builder
   */
  public static ImmutableQueries.Builder builder() {
    return new ImmutableQueries.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueries ImmutableQueries}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveTraceRepository.Queries", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<AggregateOuterClass.Aggregate.Query> queries = ImmutableList.builder();
    private ImmutableList.Builder<TraceOuterClass.Trace.SharedQueryText> sharedQueryTexts = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Queries} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(LiveTraceRepository.Queries instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllQueries(instance.queries());
      addAllSharedQueryTexts(instance.sharedQueryTexts());
      return this;
    }

    /**
     * Adds one element to {@link LiveTraceRepository.Queries#queries() queries} list.
     * @param element A queries element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueries(AggregateOuterClass.Aggregate.Query element) {
      this.queries.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveTraceRepository.Queries#queries() queries} list.
     * @param elements An array of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addQueries(AggregateOuterClass.Aggregate.Query... elements) {
      this.queries.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveTraceRepository.Queries#queries() queries} list.
     * @param elements An iterable of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder queries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
      this.queries = ImmutableList.builder();
      return addAllQueries(elements);
    }

    /**
     * Adds elements to {@link LiveTraceRepository.Queries#queries() queries} list.
     * @param elements An iterable of queries elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllQueries(Iterable<? extends AggregateOuterClass.Aggregate.Query> elements) {
      this.queries.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts} list.
     * @param element A sharedQueryTexts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText element) {
      this.sharedQueryTexts.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An array of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSharedQueryTexts(TraceOuterClass.Trace.SharedQueryText... elements) {
      this.sharedQueryTexts.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An iterable of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
      this.sharedQueryTexts = ImmutableList.builder();
      return addAllSharedQueryTexts(elements);
    }

    /**
     * Adds elements to {@link LiveTraceRepository.Queries#sharedQueryTexts() sharedQueryTexts} list.
     * @param elements An iterable of sharedQueryTexts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSharedQueryTexts(Iterable<? extends TraceOuterClass.Trace.SharedQueryText> elements) {
      this.sharedQueryTexts.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueries ImmutableQueries}.
     * @return An immutable instance of Queries
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueries build() {
      return new ImmutableQueries(queries.build(), sharedQueryTexts.build());
    }
  }
}
