package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransactionNameErrorSummary.builder()}.
 */
@Generated(from = "TransactionNameErrorSummaryCollector.TransactionNameErrorSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTransactionNameErrorSummary
    implements TransactionNameErrorSummaryCollector.TransactionNameErrorSummary {
  private final String transactionName;
  private final long errorCount;
  private final long transactionCount;

  private ImmutableTransactionNameErrorSummary(String transactionName, long errorCount, long transactionCount) {
    this.transactionName = transactionName;
    this.errorCount = errorCount;
    this.transactionCount = transactionCount;
  }

  /**
   * @return The value of the {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }

  /**
   * @return The value of the {@code errorCount} attribute
   */
  @JsonProperty("errorCount")
  @Override
  public long errorCount() {
    return errorCount;
  }

  /**
   * @return The value of the {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionName() transactionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameErrorSummary withTransactionName(String value) {
    String newValue = Preconditions.checkNotNull(value, "transactionName");
    if (this.transactionName.equals(newValue)) return this;
    return new ImmutableTransactionNameErrorSummary(newValue, this.errorCount, this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#errorCount() errorCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameErrorSummary withErrorCount(long value) {
    if (this.errorCount == value) return this;
    return new ImmutableTransactionNameErrorSummary(this.transactionName, value, this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionCount() transactionCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameErrorSummary withTransactionCount(long value) {
    if (this.transactionCount == value) return this;
    return new ImmutableTransactionNameErrorSummary(this.transactionName, this.errorCount, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransactionNameErrorSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransactionNameErrorSummary
        && equalTo((ImmutableTransactionNameErrorSummary) another);
  }

  private boolean equalTo(ImmutableTransactionNameErrorSummary another) {
    return transactionName.equals(another.transactionName)
        && errorCount == another.errorCount
        && transactionCount == another.transactionCount;
  }

  /**
   * Computes a hash code from attributes: {@code transactionName}, {@code errorCount}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + transactionName.hashCode();
    h += (h << 5) + Longs.hashCode(errorCount);
    h += (h << 5) + Longs.hashCode(transactionCount);
    return h;
  }

  /**
   * Prints the immutable value {@code TransactionNameErrorSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionNameErrorSummary")
        .omitNullValues()
        .add("transactionName", transactionName)
        .add("errorCount", errorCount)
        .add("transactionCount", transactionCount)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransactionNameErrorSummaryCollector.TransactionNameErrorSummary", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements TransactionNameErrorSummaryCollector.TransactionNameErrorSummary {
    @Nullable String transactionName;
    long errorCount;
    boolean errorCountIsSet;
    long transactionCount;
    boolean transactionCountIsSet;
    @JsonProperty("transactionName")
    public void setTransactionName(String transactionName) {
      this.transactionName = transactionName;
    }
    @JsonProperty("errorCount")
    public void setErrorCount(long errorCount) {
      this.errorCount = errorCount;
      this.errorCountIsSet = true;
    }
    @JsonProperty("transactionCount")
    public void setTransactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      this.transactionCountIsSet = true;
    }
    @Override
    public String transactionName() { throw new UnsupportedOperationException(); }
    @Override
    public long errorCount() { throw new UnsupportedOperationException(); }
    @Override
    public long transactionCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransactionNameErrorSummary fromJson(Json json) {
    ImmutableTransactionNameErrorSummary.Builder builder = ImmutableTransactionNameErrorSummary.builder();
    if (json.transactionName != null) {
      builder.transactionName(json.transactionName);
    }
    if (json.errorCountIsSet) {
      builder.errorCount(json.errorCount);
    }
    if (json.transactionCountIsSet) {
      builder.transactionCount(json.transactionCount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransactionNameErrorSummary instance
   */
  public static ImmutableTransactionNameErrorSummary copyOf(TransactionNameErrorSummaryCollector.TransactionNameErrorSummary instance) {
    if (instance instanceof ImmutableTransactionNameErrorSummary) {
      return (ImmutableTransactionNameErrorSummary) instance;
    }
    return ImmutableTransactionNameErrorSummary.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransactionNameErrorSummary ImmutableTransactionNameErrorSummary}.
   * <pre>
   * ImmutableTransactionNameErrorSummary.builder()
   *    .transactionName(String) // required {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionName() transactionName}
   *    .errorCount(long) // required {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#errorCount() errorCount}
   *    .transactionCount(long) // required {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionCount() transactionCount}
   *    .build();
   * </pre>
   * @return A new ImmutableTransactionNameErrorSummary builder
   */
  public static ImmutableTransactionNameErrorSummary.Builder builder() {
    return new ImmutableTransactionNameErrorSummary.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransactionNameErrorSummary ImmutableTransactionNameErrorSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionNameErrorSummaryCollector.TransactionNameErrorSummary", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION_NAME = 0x1L;
    private static final long INIT_BIT_ERROR_COUNT = 0x2L;
    private static final long INIT_BIT_TRANSACTION_COUNT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String transactionName;
    private long errorCount;
    private long transactionCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransactionNameErrorSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder copyFrom(TransactionNameErrorSummaryCollector.TransactionNameErrorSummary instance) {
      Preconditions.checkNotNull(instance, "instance");
      transactionName(instance.transactionName());
      errorCount(instance.errorCount());
      transactionCount(instance.transactionCount());
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionName() transactionName} attribute.
     * @param transactionName The value for transactionName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactionName(String transactionName) {
      this.transactionName = Preconditions.checkNotNull(transactionName, "transactionName");
      initBits &= ~INIT_BIT_TRANSACTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#errorCount() errorCount} attribute.
     * @param errorCount The value for errorCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorCount(long errorCount) {
      this.errorCount = errorCount;
      initBits &= ~INIT_BIT_ERROR_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameErrorSummaryCollector.TransactionNameErrorSummary#transactionCount() transactionCount} attribute.
     * @param transactionCount The value for transactionCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initBits &= ~INIT_BIT_TRANSACTION_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransactionNameErrorSummary ImmutableTransactionNameErrorSummary}.
     * @return An immutable instance of TransactionNameErrorSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransactionNameErrorSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransactionNameErrorSummary(transactionName, errorCount, transactionCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TRANSACTION_NAME) != 0) attributes.add("transactionName");
      if ((initBits & INIT_BIT_ERROR_COUNT) != 0) attributes.add("errorCount");
      if ((initBits & INIT_BIT_TRANSACTION_COUNT) != 0) attributes.add("transactionCount");
      return "Cannot build TransactionNameErrorSummary, some of required attributes are not set " + attributes;
    }
  }
}
