/*
 * Copyright 2015-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.glowroot.agent.shaded.org.glowroot.common.util;

import org.glowroot.agent.shaded.com.google.protobuf.AbstractParser;
import org.glowroot.agent.shaded.com.google.protobuf.CodedInputStream;
import org.glowroot.agent.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.glowroot.agent.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.glowroot.agent.shaded.com.google.protobuf.MessageLite;
import org.glowroot.agent.shaded.com.google.protobuf.Parser;

public class SizeLimitBypassingParser<T extends MessageLite> extends AbstractParser<T> {

    private final Parser<T> parser;

    public SizeLimitBypassingParser(Parser<T> parser) {
        this.parser = parser;
    }

    @Override
    public T parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry)
            throws InvalidProtocolBufferException {
        input.setSizeLimit(Integer.MAX_VALUE);
        return parser.parsePartialFrom(input, extensionRegistry);
    }
}
