package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.List;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClassAnalyzer.MatchedMixinTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMatchedMixinTypes.builder()}.
 */
@Generated(from = "ClassAnalyzer.MatchedMixinTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@org.glowroot.agent.shaded.javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableMatchedMixinTypes
    implements ClassAnalyzer.MatchedMixinTypes {
  private final ImmutableList<MixinType> reweavable;
  private final ImmutableList<MixinType> nonReweavable;

  private ImmutableMatchedMixinTypes(
      ImmutableList<MixinType> reweavable,
      ImmutableList<MixinType> nonReweavable) {
    this.reweavable = reweavable;
    this.nonReweavable = nonReweavable;
  }

  /**
   * @return The value of the {@code reweavable} attribute
   */
  @JsonProperty("reweavable")
  @Override
  public ImmutableList<MixinType> reweavable() {
    return reweavable;
  }

  /**
   * @return The value of the {@code nonReweavable} attribute
   */
  @JsonProperty("nonReweavable")
  @Override
  public ImmutableList<MixinType> nonReweavable() {
    return nonReweavable;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedMixinTypes withReweavable(MixinType... elements) {
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedMixinTypes(newValue, this.nonReweavable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of reweavable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedMixinTypes withReweavable(Iterable<? extends MixinType> elements) {
    if (this.reweavable == elements) return this;
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedMixinTypes(newValue, this.nonReweavable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedMixinTypes withNonReweavable(MixinType... elements) {
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedMixinTypes(this.reweavable, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nonReweavable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedMixinTypes withNonReweavable(Iterable<? extends MixinType> elements) {
    if (this.nonReweavable == elements) return this;
    ImmutableList<MixinType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedMixinTypes(this.reweavable, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMatchedMixinTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMatchedMixinTypes
        && equalTo((ImmutableMatchedMixinTypes) another);
  }

  private boolean equalTo(ImmutableMatchedMixinTypes another) {
    return reweavable.equals(another.reweavable)
        && nonReweavable.equals(another.nonReweavable);
  }

  /**
   * Computes a hash code from attributes: {@code reweavable}, {@code nonReweavable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reweavable.hashCode();
    h += (h << 5) + nonReweavable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MatchedMixinTypes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MatchedMixinTypes")
        .omitNullValues()
        .add("reweavable", reweavable)
        .add("nonReweavable", nonReweavable)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ClassAnalyzer.MatchedMixinTypes", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ClassAnalyzer.MatchedMixinTypes {
    @Nullable List<MixinType> reweavable = ImmutableList.of();
    @Nullable List<MixinType> nonReweavable = ImmutableList.of();
    @JsonProperty("reweavable")
    public void setReweavable(List<MixinType> reweavable) {
      this.reweavable = reweavable;
    }
    @JsonProperty("nonReweavable")
    public void setNonReweavable(List<MixinType> nonReweavable) {
      this.nonReweavable = nonReweavable;
    }
    @Override
    public List<MixinType> reweavable() { throw new UnsupportedOperationException(); }
    @Override
    public List<MixinType> nonReweavable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMatchedMixinTypes fromJson(Json json) {
    ImmutableMatchedMixinTypes.Builder builder = ImmutableMatchedMixinTypes.builder();
    if (json.reweavable != null) {
      builder.addAllReweavable(json.reweavable);
    }
    if (json.nonReweavable != null) {
      builder.addAllNonReweavable(json.nonReweavable);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ClassAnalyzer.MatchedMixinTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MatchedMixinTypes instance
   */
  public static ImmutableMatchedMixinTypes copyOf(ClassAnalyzer.MatchedMixinTypes instance) {
    if (instance instanceof ImmutableMatchedMixinTypes) {
      return (ImmutableMatchedMixinTypes) instance;
    }
    return ImmutableMatchedMixinTypes.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMatchedMixinTypes ImmutableMatchedMixinTypes}.
   * <pre>
   * ImmutableMatchedMixinTypes.builder()
   *    .addReweavable|addAllReweavable(org.glowroot.agent.weaving.MixinType) // {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable} elements
   *    .addNonReweavable|addAllNonReweavable(org.glowroot.agent.weaving.MixinType) // {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMatchedMixinTypes builder
   */
  public static ImmutableMatchedMixinTypes.Builder builder() {
    return new ImmutableMatchedMixinTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMatchedMixinTypes ImmutableMatchedMixinTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassAnalyzer.MatchedMixinTypes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<MixinType> reweavable = ImmutableList.builder();
    private ImmutableList.Builder<MixinType> nonReweavable = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MatchedMixinTypes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(ClassAnalyzer.MatchedMixinTypes instance) {
      Preconditions.checkNotNull(instance, "instance");
      addAllReweavable(instance.reweavable());
      addAllNonReweavable(instance.nonReweavable());
      return this;
    }

    /**
     * Adds one element to {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable} list.
     * @param element A reweavable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReweavable(MixinType element) {
      this.reweavable.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable} list.
     * @param elements An array of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReweavable(MixinType... elements) {
      this.reweavable.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable} list.
     * @param elements An iterable of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reweavable(Iterable<? extends MixinType> elements) {
      this.reweavable = ImmutableList.builder();
      return addAllReweavable(elements);
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedMixinTypes#reweavable() reweavable} list.
     * @param elements An iterable of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReweavable(Iterable<? extends MixinType> elements) {
      this.reweavable.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable} list.
     * @param element A nonReweavable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavable(MixinType element) {
      this.nonReweavable.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable} list.
     * @param elements An array of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavable(MixinType... elements) {
      this.nonReweavable.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable} list.
     * @param elements An iterable of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonReweavable(Iterable<? extends MixinType> elements) {
      this.nonReweavable = ImmutableList.builder();
      return addAllNonReweavable(elements);
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedMixinTypes#nonReweavable() nonReweavable} list.
     * @param elements An iterable of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNonReweavable(Iterable<? extends MixinType> elements) {
      this.nonReweavable.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMatchedMixinTypes ImmutableMatchedMixinTypes}.
     * @return An immutable instance of MatchedMixinTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMatchedMixinTypes build() {
      return new ImmutableMatchedMixinTypes(reweavable.build(), nonReweavable.build());
    }
  }
}
