package org.glowroot.agent.central;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CentralConnection.ParsedCollectorAddress}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParsedCollectorAddress.builder()}.
 */
@Generated(from = "CentralConnection.ParsedCollectorAddress", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableParsedCollectorAddress
    implements CentralConnection.ParsedCollectorAddress {
  private final boolean https;
  private final ImmutableList<CentralConnection.CollectorTarget> targets;

  private ImmutableParsedCollectorAddress(
      boolean https,
      ImmutableList<CentralConnection.CollectorTarget> targets) {
    this.https = https;
    this.targets = targets;
  }

  /**
   * @return The value of the {@code https} attribute
   */
  @JsonProperty("https")
  @Override
  public boolean https() {
    return https;
  }

  /**
   * @return The value of the {@code targets} attribute
   */
  @JsonProperty("targets")
  @Override
  public ImmutableList<CentralConnection.CollectorTarget> targets() {
    return targets;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CentralConnection.ParsedCollectorAddress#https() https} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for https
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParsedCollectorAddress withHttps(boolean value) {
    if (this.https == value) return this;
    return new ImmutableParsedCollectorAddress(value, this.targets);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CentralConnection.ParsedCollectorAddress#targets() targets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParsedCollectorAddress withTargets(CentralConnection.CollectorTarget... elements) {
    ImmutableList<CentralConnection.CollectorTarget> newValue = ImmutableList.copyOf(elements);
    return new ImmutableParsedCollectorAddress(this.https, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CentralConnection.ParsedCollectorAddress#targets() targets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of targets elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParsedCollectorAddress withTargets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
    if (this.targets == elements) return this;
    ImmutableList<CentralConnection.CollectorTarget> newValue = ImmutableList.copyOf(elements);
    return new ImmutableParsedCollectorAddress(this.https, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParsedCollectorAddress} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParsedCollectorAddress
        && equalTo((ImmutableParsedCollectorAddress) another);
  }

  private boolean equalTo(ImmutableParsedCollectorAddress another) {
    return https == another.https
        && targets.equals(another.targets);
  }

  /**
   * Computes a hash code from attributes: {@code https}, {@code targets}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(https);
    h += (h << 5) + targets.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ParsedCollectorAddress} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ParsedCollectorAddress")
        .omitNullValues()
        .add("https", https)
        .add("targets", targets)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CentralConnection.ParsedCollectorAddress", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CentralConnection.ParsedCollectorAddress {
    boolean https;
    boolean httpsIsSet;
    @Nullable List<CentralConnection.CollectorTarget> targets = ImmutableList.of();
    @JsonProperty("https")
    public void setHttps(boolean https) {
      this.https = https;
      this.httpsIsSet = true;
    }
    @JsonProperty("targets")
    public void setTargets(List<CentralConnection.CollectorTarget> targets) {
      this.targets = targets;
    }
    @Override
    public boolean https() { throw new UnsupportedOperationException(); }
    @Override
    public List<CentralConnection.CollectorTarget> targets() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableParsedCollectorAddress fromJson(Json json) {
    ImmutableParsedCollectorAddress.Builder builder = ImmutableParsedCollectorAddress.builder();
    if (json.httpsIsSet) {
      builder.https(json.https);
    }
    if (json.targets != null) {
      builder.addAllTargets(json.targets);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CentralConnection.ParsedCollectorAddress} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParsedCollectorAddress instance
   */
  public static ImmutableParsedCollectorAddress copyOf(CentralConnection.ParsedCollectorAddress instance) {
    if (instance instanceof ImmutableParsedCollectorAddress) {
      return (ImmutableParsedCollectorAddress) instance;
    }
    return ImmutableParsedCollectorAddress.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParsedCollectorAddress ImmutableParsedCollectorAddress}.
   * <pre>
   * ImmutableParsedCollectorAddress.builder()
   *    .https(boolean) // required {@link CentralConnection.ParsedCollectorAddress#https() https}
   *    .addTargets|addAllTargets(org.glowroot.agent.central.CentralConnection.CollectorTarget) // {@link CentralConnection.ParsedCollectorAddress#targets() targets} elements
   *    .build();
   * </pre>
   * @return A new ImmutableParsedCollectorAddress builder
   */
  public static ImmutableParsedCollectorAddress.Builder builder() {
    return new ImmutableParsedCollectorAddress.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParsedCollectorAddress ImmutableParsedCollectorAddress}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CentralConnection.ParsedCollectorAddress", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HTTPS = 0x1L;
    private long initBits = 0x1L;

    private boolean https;
    private ImmutableList.Builder<CentralConnection.CollectorTarget> targets = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParsedCollectorAddress} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(CentralConnection.ParsedCollectorAddress instance) {
      Objects.requireNonNull(instance, "instance");
      https(instance.https());
      addAllTargets(instance.targets());
      return this;
    }

    /**
     * Initializes the value for the {@link CentralConnection.ParsedCollectorAddress#https() https} attribute.
     * @param https The value for https 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder https(boolean https) {
      this.https = https;
      initBits &= ~INIT_BIT_HTTPS;
      return this;
    }

    /**
     * Adds one element to {@link CentralConnection.ParsedCollectorAddress#targets() targets} list.
     * @param element A targets element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTargets(CentralConnection.CollectorTarget element) {
      this.targets.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CentralConnection.ParsedCollectorAddress#targets() targets} list.
     * @param elements An array of targets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTargets(CentralConnection.CollectorTarget... elements) {
      this.targets.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CentralConnection.ParsedCollectorAddress#targets() targets} list.
     * @param elements An iterable of targets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder targets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
      this.targets = ImmutableList.builder();
      return addAllTargets(elements);
    }

    /**
     * Adds elements to {@link CentralConnection.ParsedCollectorAddress#targets() targets} list.
     * @param elements An iterable of targets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTargets(Iterable<? extends CentralConnection.CollectorTarget> elements) {
      this.targets.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableParsedCollectorAddress ImmutableParsedCollectorAddress}.
     * @return An immutable instance of ParsedCollectorAddress
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParsedCollectorAddress build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParsedCollectorAddress(https, targets.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HTTPS) != 0) attributes.add("https");
      return "Cannot build ParsedCollectorAddress, some of required attributes are not set " + attributes;
    }
  }
}
