package org.glowroot.agent.impl;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PreloadSomeSuperTypesCache.LoadFromFileResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLoadFromFileResult.builder()}.
 */
@Generated(from = "PreloadSomeSuperTypesCache.LoadFromFileResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableLoadFromFileResult
    implements PreloadSomeSuperTypesCache.LoadFromFileResult {
  private final ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache;
  private final int linesInFile;
  private final boolean trackAccessTimes;

  private ImmutableLoadFromFileResult(
      ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache,
      int linesInFile,
      boolean trackAccessTimes) {
    this.cache = cache;
    this.linesInFile = linesInFile;
    this.trackAccessTimes = trackAccessTimes;
  }

  /**
   * @return The value of the {@code cache} attribute
   */
  @JsonProperty("cache")
  @Override
  public ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache() {
    return cache;
  }

  /**
   * @return The value of the {@code linesInFile} attribute
   */
  @JsonProperty("linesInFile")
  @Override
  public int linesInFile() {
    return linesInFile;
  }

  /**
   * @return The value of the {@code trackAccessTimes} attribute
   */
  @JsonProperty("trackAccessTimes")
  @Override
  public boolean trackAccessTimes() {
    return trackAccessTimes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#cache() cache} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cache
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLoadFromFileResult withCache(ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> value) {
    if (this.cache == value) return this;
    ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> newValue = Objects.requireNonNull(value, "cache");
    return new ImmutableLoadFromFileResult(newValue, this.linesInFile, this.trackAccessTimes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#linesInFile() linesInFile} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for linesInFile
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLoadFromFileResult withLinesInFile(int value) {
    if (this.linesInFile == value) return this;
    return new ImmutableLoadFromFileResult(this.cache, value, this.trackAccessTimes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#trackAccessTimes() trackAccessTimes} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for trackAccessTimes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLoadFromFileResult withTrackAccessTimes(boolean value) {
    if (this.trackAccessTimes == value) return this;
    return new ImmutableLoadFromFileResult(this.cache, this.linesInFile, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLoadFromFileResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLoadFromFileResult
        && equalTo((ImmutableLoadFromFileResult) another);
  }

  private boolean equalTo(ImmutableLoadFromFileResult another) {
    return cache.equals(another.cache)
        && linesInFile == another.linesInFile
        && trackAccessTimes == another.trackAccessTimes;
  }

  /**
   * Computes a hash code from attributes: {@code cache}, {@code linesInFile}, {@code trackAccessTimes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + cache.hashCode();
    h += (h << 5) + linesInFile;
    h += (h << 5) + Booleans.hashCode(trackAccessTimes);
    return h;
  }

  /**
   * Prints the immutable value {@code LoadFromFileResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LoadFromFileResult")
        .omitNullValues()
        .add("cache", cache)
        .add("linesInFile", linesInFile)
        .add("trackAccessTimes", trackAccessTimes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PreloadSomeSuperTypesCache.LoadFromFileResult", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PreloadSomeSuperTypesCache.LoadFromFileResult {
    @Nullable ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache;
    int linesInFile;
    boolean linesInFileIsSet;
    boolean trackAccessTimes;
    boolean trackAccessTimesIsSet;
    @JsonProperty("cache")
    public void setCache(ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache) {
      this.cache = cache;
    }
    @JsonProperty("linesInFile")
    public void setLinesInFile(int linesInFile) {
      this.linesInFile = linesInFile;
      this.linesInFileIsSet = true;
    }
    @JsonProperty("trackAccessTimes")
    public void setTrackAccessTimes(boolean trackAccessTimes) {
      this.trackAccessTimes = trackAccessTimes;
      this.trackAccessTimesIsSet = true;
    }
    @Override
    public ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache() { throw new UnsupportedOperationException(); }
    @Override
    public int linesInFile() { throw new UnsupportedOperationException(); }
    @Override
    public boolean trackAccessTimes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLoadFromFileResult fromJson(Json json) {
    ImmutableLoadFromFileResult.Builder builder = ImmutableLoadFromFileResult.builder();
    if (json.cache != null) {
      builder.cache(json.cache);
    }
    if (json.linesInFileIsSet) {
      builder.linesInFile(json.linesInFile);
    }
    if (json.trackAccessTimesIsSet) {
      builder.trackAccessTimes(json.trackAccessTimes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PreloadSomeSuperTypesCache.LoadFromFileResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LoadFromFileResult instance
   */
  public static ImmutableLoadFromFileResult copyOf(PreloadSomeSuperTypesCache.LoadFromFileResult instance) {
    if (instance instanceof ImmutableLoadFromFileResult) {
      return (ImmutableLoadFromFileResult) instance;
    }
    return ImmutableLoadFromFileResult.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLoadFromFileResult ImmutableLoadFromFileResult}.
   * <pre>
   * ImmutableLoadFromFileResult.builder()
   *    .cache(concurrent.ConcurrentMap&amp;lt;String, org.glowroot.agent.impl.PreloadSomeSuperTypesCache.CacheValue&amp;gt;) // required {@link PreloadSomeSuperTypesCache.LoadFromFileResult#cache() cache}
   *    .linesInFile(int) // required {@link PreloadSomeSuperTypesCache.LoadFromFileResult#linesInFile() linesInFile}
   *    .trackAccessTimes(boolean) // required {@link PreloadSomeSuperTypesCache.LoadFromFileResult#trackAccessTimes() trackAccessTimes}
   *    .build();
   * </pre>
   * @return A new ImmutableLoadFromFileResult builder
   */
  public static ImmutableLoadFromFileResult.Builder builder() {
    return new ImmutableLoadFromFileResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLoadFromFileResult ImmutableLoadFromFileResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PreloadSomeSuperTypesCache.LoadFromFileResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CACHE = 0x1L;
    private static final long INIT_BIT_LINES_IN_FILE = 0x2L;
    private static final long INIT_BIT_TRACK_ACCESS_TIMES = 0x4L;
    private long initBits = 0x7L;

    private @Nullable ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache;
    private int linesInFile;
    private boolean trackAccessTimes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LoadFromFileResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PreloadSomeSuperTypesCache.LoadFromFileResult instance) {
      Objects.requireNonNull(instance, "instance");
      cache(instance.cache());
      linesInFile(instance.linesInFile());
      trackAccessTimes(instance.trackAccessTimes());
      return this;
    }

    /**
     * Initializes the value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#cache() cache} attribute.
     * @param cache The value for cache 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder cache(ConcurrentMap<String, PreloadSomeSuperTypesCache.CacheValue> cache) {
      this.cache = Objects.requireNonNull(cache, "cache");
      initBits &= ~INIT_BIT_CACHE;
      return this;
    }

    /**
     * Initializes the value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#linesInFile() linesInFile} attribute.
     * @param linesInFile The value for linesInFile 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder linesInFile(int linesInFile) {
      this.linesInFile = linesInFile;
      initBits &= ~INIT_BIT_LINES_IN_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link PreloadSomeSuperTypesCache.LoadFromFileResult#trackAccessTimes() trackAccessTimes} attribute.
     * @param trackAccessTimes The value for trackAccessTimes 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder trackAccessTimes(boolean trackAccessTimes) {
      this.trackAccessTimes = trackAccessTimes;
      initBits &= ~INIT_BIT_TRACK_ACCESS_TIMES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLoadFromFileResult ImmutableLoadFromFileResult}.
     * @return An immutable instance of LoadFromFileResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLoadFromFileResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLoadFromFileResult(cache, linesInFile, trackAccessTimes);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CACHE) != 0) attributes.add("cache");
      if ((initBits & INIT_BIT_LINES_IN_FILE) != 0) attributes.add("linesInFile");
      if ((initBits & INIT_BIT_TRACK_ACCESS_TIMES) != 0) attributes.add("trackAccessTimes");
      return "Cannot build LoadFromFileResult, some of required attributes are not set " + attributes;
    }
  }
}
