package org.glowroot.agent.impl;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TraceCollector.PendingTrace}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePendingTrace.builder()}.
 */
@Generated(from = "TraceCollector.PendingTrace", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePendingTrace implements TraceCollector.PendingTrace {
  private final Transaction transaction;
  private final boolean slow;
  private final boolean partial;

  private ImmutablePendingTrace(Transaction transaction, boolean slow, boolean partial) {
    this.transaction = transaction;
    this.slow = slow;
    this.partial = partial;
  }

  /**
   * @return The value of the {@code transaction} attribute
   */
  @JsonProperty("transaction")
  @Override
  public Transaction transaction() {
    return transaction;
  }

  /**
   * @return The value of the {@code slow} attribute
   */
  @JsonProperty("slow")
  @Override
  public boolean slow() {
    return slow;
  }

  /**
   * @return The value of the {@code partial} attribute
   */
  @JsonProperty("partial")
  @Override
  public boolean partial() {
    return partial;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TraceCollector.PendingTrace#transaction() transaction} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transaction
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePendingTrace withTransaction(Transaction value) {
    if (this.transaction == value) return this;
    Transaction newValue = Objects.requireNonNull(value, "transaction");
    return new ImmutablePendingTrace(newValue, this.slow, this.partial);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TraceCollector.PendingTrace#slow() slow} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePendingTrace withSlow(boolean value) {
    if (this.slow == value) return this;
    return new ImmutablePendingTrace(this.transaction, value, this.partial);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TraceCollector.PendingTrace#partial() partial} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partial
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePendingTrace withPartial(boolean value) {
    if (this.partial == value) return this;
    return new ImmutablePendingTrace(this.transaction, this.slow, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePendingTrace} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePendingTrace
        && equalTo((ImmutablePendingTrace) another);
  }

  private boolean equalTo(ImmutablePendingTrace another) {
    return transaction.equals(another.transaction)
        && slow == another.slow
        && partial == another.partial;
  }

  /**
   * Computes a hash code from attributes: {@code transaction}, {@code slow}, {@code partial}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + transaction.hashCode();
    h += (h << 5) + Booleans.hashCode(slow);
    h += (h << 5) + Booleans.hashCode(partial);
    return h;
  }

  /**
   * Prints the immutable value {@code PendingTrace} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PendingTrace")
        .omitNullValues()
        .add("transaction", transaction)
        .add("slow", slow)
        .add("partial", partial)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TraceCollector.PendingTrace", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TraceCollector.PendingTrace {
    @Nullable Transaction transaction;
    boolean slow;
    boolean slowIsSet;
    boolean partial;
    boolean partialIsSet;
    @JsonProperty("transaction")
    public void setTransaction(Transaction transaction) {
      this.transaction = transaction;
    }
    @JsonProperty("slow")
    public void setSlow(boolean slow) {
      this.slow = slow;
      this.slowIsSet = true;
    }
    @JsonProperty("partial")
    public void setPartial(boolean partial) {
      this.partial = partial;
      this.partialIsSet = true;
    }
    @Override
    public Transaction transaction() { throw new UnsupportedOperationException(); }
    @Override
    public boolean slow() { throw new UnsupportedOperationException(); }
    @Override
    public boolean partial() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePendingTrace fromJson(Json json) {
    ImmutablePendingTrace.Builder builder = ImmutablePendingTrace.builder();
    if (json.transaction != null) {
      builder.transaction(json.transaction);
    }
    if (json.slowIsSet) {
      builder.slow(json.slow);
    }
    if (json.partialIsSet) {
      builder.partial(json.partial);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TraceCollector.PendingTrace} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PendingTrace instance
   */
  public static ImmutablePendingTrace copyOf(TraceCollector.PendingTrace instance) {
    if (instance instanceof ImmutablePendingTrace) {
      return (ImmutablePendingTrace) instance;
    }
    return ImmutablePendingTrace.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePendingTrace ImmutablePendingTrace}.
   * <pre>
   * ImmutablePendingTrace.builder()
   *    .transaction(org.glowroot.agent.impl.Transaction) // required {@link TraceCollector.PendingTrace#transaction() transaction}
   *    .slow(boolean) // required {@link TraceCollector.PendingTrace#slow() slow}
   *    .partial(boolean) // required {@link TraceCollector.PendingTrace#partial() partial}
   *    .build();
   * </pre>
   * @return A new ImmutablePendingTrace builder
   */
  public static ImmutablePendingTrace.Builder builder() {
    return new ImmutablePendingTrace.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePendingTrace ImmutablePendingTrace}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TraceCollector.PendingTrace", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION = 0x1L;
    private static final long INIT_BIT_SLOW = 0x2L;
    private static final long INIT_BIT_PARTIAL = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Transaction transaction;
    private boolean slow;
    private boolean partial;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PendingTrace} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TraceCollector.PendingTrace instance) {
      Objects.requireNonNull(instance, "instance");
      transaction(instance.transaction());
      slow(instance.slow());
      partial(instance.partial());
      return this;
    }

    /**
     * Initializes the value for the {@link TraceCollector.PendingTrace#transaction() transaction} attribute.
     * @param transaction The value for transaction 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transaction(Transaction transaction) {
      this.transaction = Objects.requireNonNull(transaction, "transaction");
      initBits &= ~INIT_BIT_TRANSACTION;
      return this;
    }

    /**
     * Initializes the value for the {@link TraceCollector.PendingTrace#slow() slow} attribute.
     * @param slow The value for slow 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder slow(boolean slow) {
      this.slow = slow;
      initBits &= ~INIT_BIT_SLOW;
      return this;
    }

    /**
     * Initializes the value for the {@link TraceCollector.PendingTrace#partial() partial} attribute.
     * @param partial The value for partial 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder partial(boolean partial) {
      this.partial = partial;
      initBits &= ~INIT_BIT_PARTIAL;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePendingTrace ImmutablePendingTrace}.
     * @return An immutable instance of PendingTrace
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePendingTrace build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePendingTrace(transaction, slow, partial);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TRANSACTION) != 0) attributes.add("transaction");
      if ((initBits & INIT_BIT_SLOW) != 0) attributes.add("slow");
      if ((initBits & INIT_BIT_PARTIAL) != 0) attributes.add("partial");
      return "Cannot build PendingTrace, some of required attributes are not set " + attributes;
    }
  }
}
