package org.glowroot.agent.impl;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TraceCollector.SlowThresholdOverridesForUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSlowThresholdOverridesForUser.builder()}.
 */
@Generated(from = "TraceCollector.SlowThresholdOverridesForUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSlowThresholdOverridesForUser
    implements TraceCollector.SlowThresholdOverridesForUser {
  private final java.lang.@Nullable Long defaultThresholdNanos;
  private final ImmutableMap<String, java.lang.Long> thresholdNanos;

  private ImmutableSlowThresholdOverridesForUser(
      java.lang.@Nullable Long defaultThresholdNanos,
      ImmutableMap<String, java.lang.Long> thresholdNanos) {
    this.defaultThresholdNanos = defaultThresholdNanos;
    this.thresholdNanos = thresholdNanos;
  }

  /**
   * @return The value of the {@code defaultThresholdNanos} attribute
   */
  @JsonProperty("defaultThresholdNanos")
  @Override
  public java.lang.@Nullable Long defaultThresholdNanos() {
    return defaultThresholdNanos;
  }

  /**
   * @return The value of the {@code thresholdNanos} attribute
   */
  @JsonProperty("thresholdNanos")
  @Override
  public ImmutableMap<String, java.lang.Long> thresholdNanos() {
    return thresholdNanos;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TraceCollector.SlowThresholdOverridesForUser#defaultThresholdNanos() defaultThresholdNanos} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultThresholdNanos (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlowThresholdOverridesForUser withDefaultThresholdNanos(java.lang.@Nullable Long value) {
    if (Objects.equals(this.defaultThresholdNanos, value)) return this;
    return new ImmutableSlowThresholdOverridesForUser(value, this.thresholdNanos);
  }

  /**
   * Copy the current immutable object by replacing the {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the thresholdNanos map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSlowThresholdOverridesForUser withThresholdNanos(Map<String, ? extends java.lang.Long> entries) {
    if (this.thresholdNanos == entries) return this;
    ImmutableMap<String, java.lang.Long> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSlowThresholdOverridesForUser(this.defaultThresholdNanos, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSlowThresholdOverridesForUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSlowThresholdOverridesForUser
        && equalTo((ImmutableSlowThresholdOverridesForUser) another);
  }

  private boolean equalTo(ImmutableSlowThresholdOverridesForUser another) {
    return Objects.equals(defaultThresholdNanos, another.defaultThresholdNanos)
        && thresholdNanos.equals(another.thresholdNanos);
  }

  /**
   * Computes a hash code from attributes: {@code defaultThresholdNanos}, {@code thresholdNanos}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(defaultThresholdNanos);
    h += (h << 5) + thresholdNanos.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlowThresholdOverridesForUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SlowThresholdOverridesForUser")
        .omitNullValues()
        .add("defaultThresholdNanos", defaultThresholdNanos)
        .add("thresholdNanos", thresholdNanos)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TraceCollector.SlowThresholdOverridesForUser", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TraceCollector.SlowThresholdOverridesForUser {
    @javax.annotation.Nullable java.lang.@Nullable Long defaultThresholdNanos;
    @javax.annotation.Nullable Map<String, java.lang.Long> thresholdNanos = ImmutableMap.of();
    @JsonProperty("defaultThresholdNanos")
    public void setDefaultThresholdNanos(java.lang.@Nullable Long defaultThresholdNanos) {
      this.defaultThresholdNanos = defaultThresholdNanos;
    }
    @JsonProperty("thresholdNanos")
    public void setThresholdNanos(Map<String, java.lang.Long> thresholdNanos) {
      this.thresholdNanos = thresholdNanos;
    }
    @Override
    public java.lang.@Nullable Long defaultThresholdNanos() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, java.lang.Long> thresholdNanos() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSlowThresholdOverridesForUser fromJson(Json json) {
    ImmutableSlowThresholdOverridesForUser.Builder builder = ImmutableSlowThresholdOverridesForUser.builder();
    if (json.defaultThresholdNanos != null) {
      builder.defaultThresholdNanos(json.defaultThresholdNanos);
    }
    if (json.thresholdNanos != null) {
      builder.putAllThresholdNanos(json.thresholdNanos);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TraceCollector.SlowThresholdOverridesForUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlowThresholdOverridesForUser instance
   */
  public static ImmutableSlowThresholdOverridesForUser copyOf(TraceCollector.SlowThresholdOverridesForUser instance) {
    if (instance instanceof ImmutableSlowThresholdOverridesForUser) {
      return (ImmutableSlowThresholdOverridesForUser) instance;
    }
    return ImmutableSlowThresholdOverridesForUser.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSlowThresholdOverridesForUser ImmutableSlowThresholdOverridesForUser}.
   * <pre>
   * ImmutableSlowThresholdOverridesForUser.builder()
   *    .defaultThresholdNanos(@org.checkerframework.checker.nullness.qual.Nullable Long | null) // nullable {@link TraceCollector.SlowThresholdOverridesForUser#defaultThresholdNanos() defaultThresholdNanos}
   *    .putThresholdNanos|putAllThresholdNanos(String =&gt; long) // {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableSlowThresholdOverridesForUser builder
   */
  public static ImmutableSlowThresholdOverridesForUser.Builder builder() {
    return new ImmutableSlowThresholdOverridesForUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSlowThresholdOverridesForUser ImmutableSlowThresholdOverridesForUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TraceCollector.SlowThresholdOverridesForUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable java.lang.@Nullable Long defaultThresholdNanos;
    private ImmutableMap.Builder<String, java.lang.Long> thresholdNanos = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlowThresholdOverridesForUser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TraceCollector.SlowThresholdOverridesForUser instance) {
      Objects.requireNonNull(instance, "instance");
      java.lang.@Nullable Long defaultThresholdNanosValue = instance.defaultThresholdNanos();
      if (defaultThresholdNanosValue != null) {
        defaultThresholdNanos(defaultThresholdNanosValue);
      }
      putAllThresholdNanos(instance.thresholdNanos());
      return this;
    }

    /**
     * Initializes the value for the {@link TraceCollector.SlowThresholdOverridesForUser#defaultThresholdNanos() defaultThresholdNanos} attribute.
     * @param defaultThresholdNanos The value for defaultThresholdNanos (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultThresholdNanos(java.lang.@Nullable Long defaultThresholdNanos) {
      this.defaultThresholdNanos = defaultThresholdNanos;
      return this;
    }

    /**
     * Put one entry to the {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} map.
     * @param key The key in the thresholdNanos map
     * @param value The associated value in the thresholdNanos map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putThresholdNanos(String key, long value) {
      this.thresholdNanos.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putThresholdNanos(Map.Entry<String, ? extends java.lang.Long> entry) {
      this.thresholdNanos.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} map. Nulls are not permitted
     * @param entries The entries that will be added to the thresholdNanos map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder thresholdNanos(Map<String, ? extends java.lang.Long> entries) {
      this.thresholdNanos = ImmutableMap.builder();
      return putAllThresholdNanos(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TraceCollector.SlowThresholdOverridesForUser#thresholdNanos() thresholdNanos} map. Nulls are not permitted
     * @param entries The entries that will be added to the thresholdNanos map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllThresholdNanos(Map<String, ? extends java.lang.Long> entries) {
      this.thresholdNanos.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSlowThresholdOverridesForUser ImmutableSlowThresholdOverridesForUser}.
     * @return An immutable instance of SlowThresholdOverridesForUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSlowThresholdOverridesForUser build() {
      return new ImmutableSlowThresholdOverridesForUser(defaultThresholdNanos, thresholdNanos.build());
    }
  }
}
