package org.glowroot.agent.model;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionTimer.TransactionTimerSnapshot}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransactionTimerSnapshot.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTransactionTimerSnapshot.of()}.
 */
@Generated(from = "TransactionTimer.TransactionTimerSnapshot", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransactionTimerSnapshot
    implements TransactionTimer.TransactionTimerSnapshot {
  private final long totalNanos;
  private final long count;
  private final boolean active;

  private ImmutableTransactionTimerSnapshot(long totalNanos, long count, boolean active) {
    this.totalNanos = totalNanos;
    this.count = count;
    this.active = active;
  }

  /**
   * @return The value of the {@code totalNanos} attribute
   */
  @JsonProperty("totalNanos")
  @Override
  public long totalNanos() {
    return totalNanos;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @JsonProperty("count")
  @Override
  public long count() {
    return count;
  }

  /**
   * @return The value of the {@code active} attribute
   */
  @JsonProperty("active")
  @Override
  public boolean active() {
    return active;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionTimer.TransactionTimerSnapshot#totalNanos() totalNanos} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalNanos
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionTimerSnapshot withTotalNanos(long value) {
    if (this.totalNanos == value) return this;
    return new ImmutableTransactionTimerSnapshot(value, this.count, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionTimer.TransactionTimerSnapshot#count() count} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for count
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionTimerSnapshot withCount(long value) {
    if (this.count == value) return this;
    return new ImmutableTransactionTimerSnapshot(this.totalNanos, value, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionTimer.TransactionTimerSnapshot#active() active} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for active
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionTimerSnapshot withActive(boolean value) {
    if (this.active == value) return this;
    return new ImmutableTransactionTimerSnapshot(this.totalNanos, this.count, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransactionTimerSnapshot} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransactionTimerSnapshot
        && equalTo((ImmutableTransactionTimerSnapshot) another);
  }

  private boolean equalTo(ImmutableTransactionTimerSnapshot another) {
    return totalNanos == another.totalNanos
        && count == another.count
        && active == another.active;
  }

  /**
   * Computes a hash code from attributes: {@code totalNanos}, {@code count}, {@code active}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(totalNanos);
    h += (h << 5) + Longs.hashCode(count);
    h += (h << 5) + Booleans.hashCode(active);
    return h;
  }

  /**
   * Prints the immutable value {@code TransactionTimerSnapshot} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionTimerSnapshot")
        .omitNullValues()
        .add("totalNanos", totalNanos)
        .add("count", count)
        .add("active", active)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransactionTimer.TransactionTimerSnapshot", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TransactionTimer.TransactionTimerSnapshot {
    long totalNanos;
    boolean totalNanosIsSet;
    long count;
    boolean countIsSet;
    boolean active;
    boolean activeIsSet;
    @JsonProperty("totalNanos")
    public void setTotalNanos(long totalNanos) {
      this.totalNanos = totalNanos;
      this.totalNanosIsSet = true;
    }
    @JsonProperty("count")
    public void setCount(long count) {
      this.count = count;
      this.countIsSet = true;
    }
    @JsonProperty("active")
    public void setActive(boolean active) {
      this.active = active;
      this.activeIsSet = true;
    }
    @Override
    public long totalNanos() { throw new UnsupportedOperationException(); }
    @Override
    public long count() { throw new UnsupportedOperationException(); }
    @Override
    public boolean active() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransactionTimerSnapshot fromJson(Json json) {
    ImmutableTransactionTimerSnapshot.Builder builder = ImmutableTransactionTimerSnapshot.builder();
    if (json.totalNanosIsSet) {
      builder.totalNanos(json.totalNanos);
    }
    if (json.countIsSet) {
      builder.count(json.count);
    }
    if (json.activeIsSet) {
      builder.active(json.active);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code TransactionTimerSnapshot} instance.
   * @param totalNanos The value for the {@code totalNanos} attribute
   * @param count The value for the {@code count} attribute
   * @param active The value for the {@code active} attribute
   * @return An immutable TransactionTimerSnapshot instance
   */
  public static ImmutableTransactionTimerSnapshot of(long totalNanos, long count, boolean active) {
    return new ImmutableTransactionTimerSnapshot(totalNanos, count, active);
  }

  /**
   * Creates an immutable copy of a {@link TransactionTimer.TransactionTimerSnapshot} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransactionTimerSnapshot instance
   */
  public static ImmutableTransactionTimerSnapshot copyOf(TransactionTimer.TransactionTimerSnapshot instance) {
    if (instance instanceof ImmutableTransactionTimerSnapshot) {
      return (ImmutableTransactionTimerSnapshot) instance;
    }
    return ImmutableTransactionTimerSnapshot.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransactionTimerSnapshot ImmutableTransactionTimerSnapshot}.
   * <pre>
   * ImmutableTransactionTimerSnapshot.builder()
   *    .totalNanos(long) // required {@link TransactionTimer.TransactionTimerSnapshot#totalNanos() totalNanos}
   *    .count(long) // required {@link TransactionTimer.TransactionTimerSnapshot#count() count}
   *    .active(boolean) // required {@link TransactionTimer.TransactionTimerSnapshot#active() active}
   *    .build();
   * </pre>
   * @return A new ImmutableTransactionTimerSnapshot builder
   */
  public static ImmutableTransactionTimerSnapshot.Builder builder() {
    return new ImmutableTransactionTimerSnapshot.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransactionTimerSnapshot ImmutableTransactionTimerSnapshot}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionTimer.TransactionTimerSnapshot", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOTAL_NANOS = 0x1L;
    private static final long INIT_BIT_COUNT = 0x2L;
    private static final long INIT_BIT_ACTIVE = 0x4L;
    private long initBits = 0x7L;

    private long totalNanos;
    private long count;
    private boolean active;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransactionTimerSnapshot} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TransactionTimer.TransactionTimerSnapshot instance) {
      Objects.requireNonNull(instance, "instance");
      totalNanos(instance.totalNanos());
      count(instance.count());
      active(instance.active());
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionTimer.TransactionTimerSnapshot#totalNanos() totalNanos} attribute.
     * @param totalNanos The value for totalNanos 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder totalNanos(long totalNanos) {
      this.totalNanos = totalNanos;
      initBits &= ~INIT_BIT_TOTAL_NANOS;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionTimer.TransactionTimerSnapshot#count() count} attribute.
     * @param count The value for count 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder count(long count) {
      this.count = count;
      initBits &= ~INIT_BIT_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionTimer.TransactionTimerSnapshot#active() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder active(boolean active) {
      this.active = active;
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransactionTimerSnapshot ImmutableTransactionTimerSnapshot}.
     * @return An immutable instance of TransactionTimerSnapshot
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransactionTimerSnapshot build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransactionTimerSnapshot(totalNanos, count, active);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOTAL_NANOS) != 0) attributes.add("totalNanos");
      if ((initBits & INIT_BIT_COUNT) != 0) attributes.add("count");
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      return "Cannot build TransactionTimerSnapshot, some of required attributes are not set " + attributes;
    }
  }
}
