package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

import org.glowroot.agent.shaded.com.google.common.collect.ImmutableCollection.Builder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMultiset;

public class ImmutableMultisetDeserializer extends GuavaImmutableCollectionDeserializer<ImmutableMultiset<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableMultisetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    protected Builder<Object> createBuilder() {
        return ImmutableMultiset.builder();
    }

    @Override
    public GuavaCollectionDeserializer<ImmutableMultiset<Object>> withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableMultisetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    protected ImmutableMultiset<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableMultiset.of();
    }

    @Override
    protected ImmutableMultiset<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) {
        return ImmutableMultiset.of(value);
    }
}
