package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

import org.glowroot.agent.shaded.com.google.common.collect.ImmutableCollection.Builder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;

public class ImmutableSetDeserializer extends GuavaImmutableCollectionDeserializer<ImmutableSet<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableSetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    public ImmutableSetDeserializer withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableSetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }
    
    @Override
    protected Builder<Object> createBuilder() {
        return ImmutableSet.builder();
    }

    @Override
    protected ImmutableSet<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableSet.of();
    }

    @Override
    protected ImmutableSet<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) {
        return ImmutableSet.of(value);
    }
}
