package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.deser;

import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.deser.NullValueProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

import org.glowroot.agent.shaded.com.google.common.collect.ImmutableCollection.Builder;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSortedSet;

public class ImmutableSortedSetDeserializer
    extends GuavaImmutableCollectionDeserializer<ImmutableSortedSet<Object>>
{
    private static final long serialVersionUID = 1L;

    public ImmutableSortedSetDeserializer(JavaType selfType,
            JsonDeserializer<?> deser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    @Override
    public ImmutableSortedSetDeserializer withResolved(JsonDeserializer<?> valueDeser, TypeDeserializer typeDeser,
            NullValueProvider nuller, Boolean unwrapSingle) {
        return new ImmutableSortedSetDeserializer(_containerType,
                valueDeser, typeDeser, nuller, unwrapSingle);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Builder<Object> createBuilder() {
        /* Not quite sure what to do with sorting/ordering; may require better support either
         * via annotations, or via custom serialization (bean style that includes ordering
         * aspects)
         */
        @SuppressWarnings("rawtypes")
        ImmutableSortedSet.Builder<?> builderComp = ImmutableSortedSet.<Comparable> naturalOrder();
        ImmutableSortedSet.Builder<Object> builder = (ImmutableSortedSet.Builder<Object>) builderComp;
        return builder;
    }

    @Override
    protected ImmutableSortedSet<Object> _createEmpty(DeserializationContext ctxt) {
        return ImmutableSortedSet.of();
    }

    @Override
    protected ImmutableSortedSet<Object> _createWithSingleElement(DeserializationContext ctxt, Object value) {
        return (ImmutableSortedSet<Object>) createBuilder()
                .add(value)
                .build();
    }
}
