package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.ser;

import java.io.IOException;

import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JacksonException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonToken;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.WritableTypeId;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

import org.glowroot.agent.shaded.com.google.common.cache.Cache;

public class CacheSerializer extends StdSerializer<Cache<?, ?>>
{
    private static final long serialVersionUID = 1L;

    public CacheSerializer() {
        super(Cache.class, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Cache<?, ?> value) {
        // Since we serialize all as empty, let's claim we are always empty
        return true;
    }

    @Override
    public void serialize(Cache<?, ?> value, JsonGenerator gen, SerializerProvider provider)
        throws IOException
    {
        gen.writeStartObject(value);
        _writeContents(value, gen, provider);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Cache<?, ?> value, JsonGenerator gen, SerializerProvider ctxt,
            TypeSerializer typeSer)
        throws IOException
    {
        gen.assignCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen,
                typeSer.typeId(value, JsonToken.START_OBJECT));
        _writeContents(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    // Just a stub in case we have time to implement proper (if optional) serialization
    protected void _writeContents(Cache<?, ?> value, JsonGenerator g, SerializerProvider ctxt)
        throws JacksonException
    {
    }    
}
