/*
 * Copyright 2019 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.glowroot.agent.shaded.io.grpc.netty;

import org.glowroot.agent.shaded.io.grpc.Internal;
import org.glowroot.agent.shaded.io.netty.channel.Channel;

/** Utility class for {@link WriteBufferingAndExceptionHandler}. */
@Internal
public final class InternalWriteBufferingAndExceptionHandlerUtils {

  /**
   * Writes buffered data and removes {@link WriteBufferingAndExceptionHandler} from {@link
   * org.glowroot.agent.shaded.io.netty.channel.ChannelPipeline}.
   *
   * <p>Internal use only. Do not use.
   */
  public static void writeBufferingAndRemove(Channel channel) {
    NettyClientHandler.writeBufferingAndRemove(channel);
  }
}
