package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AlertConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAlertConfig.builder()}.
 */
@Generated(from = "AlertConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAlertConfig extends AlertConfig {
  private final AlertConfig.AlertCondition condition;
  private final AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity;
  private final org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification;
  private final org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification;
  private final org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification;

  private ImmutableAlertConfig(
      AlertConfig.AlertCondition condition,
      AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity,
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification,
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification,
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification) {
    this.condition = condition;
    this.severity = severity;
    this.emailNotification = emailNotification;
    this.pagerDutyNotification = pagerDutyNotification;
    this.slackNotification = slackNotification;
  }

  /**
   * @return The value of the {@code condition} attribute
   */
  @JsonProperty("condition")
  @Override
  public AlertConfig.AlertCondition condition() {
    return condition;
  }

  /**
   * @return The value of the {@code severity} attribute
   */
  @JsonProperty("severity")
  @Override
  public AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity() {
    return severity;
  }

  /**
   * @return The value of the {@code emailNotification} attribute
   */
  @JsonProperty("emailNotification")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification() {
    return emailNotification;
  }

  /**
   * @return The value of the {@code pagerDutyNotification} attribute
   */
  @JsonProperty("pagerDutyNotification")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification() {
    return pagerDutyNotification;
  }

  /**
   * @return The value of the {@code slackNotification} attribute
   */
  @JsonProperty("slackNotification")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification() {
    return slackNotification;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig#condition() condition} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for condition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlertConfig withCondition(AlertConfig.AlertCondition value) {
    if (this.condition == value) return this;
    AlertConfig.AlertCondition newValue = Objects.requireNonNull(value, "condition");
    return new ImmutableAlertConfig(
        newValue,
        this.severity,
        this.emailNotification,
        this.pagerDutyNotification,
        this.slackNotification);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig#severity() severity} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for severity
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlertConfig withSeverity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity value) {
    if (this.severity == value) return this;
    AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity newValue = Objects.requireNonNull(value, "severity");
    if (this.severity.equals(newValue)) return this;
    return new ImmutableAlertConfig(
        this.condition,
        newValue,
        this.emailNotification,
        this.pagerDutyNotification,
        this.slackNotification);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig#emailNotification() emailNotification} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for emailNotification (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlertConfig withEmailNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification value) {
    if (this.emailNotification == value) return this;
    return new ImmutableAlertConfig(this.condition, this.severity, value, this.pagerDutyNotification, this.slackNotification);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig#pagerDutyNotification() pagerDutyNotification} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pagerDutyNotification (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlertConfig withPagerDutyNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification value) {
    if (this.pagerDutyNotification == value) return this;
    return new ImmutableAlertConfig(this.condition, this.severity, this.emailNotification, value, this.slackNotification);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig#slackNotification() slackNotification} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slackNotification (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAlertConfig withSlackNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification value) {
    if (this.slackNotification == value) return this;
    return new ImmutableAlertConfig(this.condition, this.severity, this.emailNotification, this.pagerDutyNotification, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAlertConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAlertConfig
        && equalTo((ImmutableAlertConfig) another);
  }

  private boolean equalTo(ImmutableAlertConfig another) {
    return condition.equals(another.condition)
        && severity.equals(another.severity)
        && Objects.equals(emailNotification, another.emailNotification)
        && Objects.equals(pagerDutyNotification, another.pagerDutyNotification)
        && Objects.equals(slackNotification, another.slackNotification);
  }

  /**
   * Computes a hash code from attributes: {@code condition}, {@code severity}, {@code emailNotification}, {@code pagerDutyNotification}, {@code slackNotification}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + condition.hashCode();
    h += (h << 5) + severity.hashCode();
    h += (h << 5) + Objects.hashCode(emailNotification);
    h += (h << 5) + Objects.hashCode(pagerDutyNotification);
    h += (h << 5) + Objects.hashCode(slackNotification);
    return h;
  }

  /**
   * Prints the immutable value {@code AlertConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AlertConfig")
        .omitNullValues()
        .add("condition", condition)
        .add("severity", severity)
        .add("emailNotification", emailNotification)
        .add("pagerDutyNotification", pagerDutyNotification)
        .add("slackNotification", slackNotification)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AlertConfig", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AlertConfig {
    @javax.annotation.Nullable AlertConfig.AlertCondition condition;
    @javax.annotation.Nullable AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification;
    @JsonProperty("condition")
    public void setCondition(AlertConfig.AlertCondition condition) {
      this.condition = condition;
    }
    @JsonProperty("severity")
    public void setSeverity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity) {
      this.severity = severity;
    }
    @JsonProperty("emailNotification")
    public void setEmailNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification) {
      this.emailNotification = emailNotification;
    }
    @JsonProperty("pagerDutyNotification")
    public void setPagerDutyNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification) {
      this.pagerDutyNotification = pagerDutyNotification;
    }
    @JsonProperty("slackNotification")
    public void setSlackNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification) {
      this.slackNotification = slackNotification;
    }
    @Override
    public AlertConfig.AlertCondition condition() { throw new UnsupportedOperationException(); }
    @Override
    public AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAlertConfig fromJson(Json json) {
    ImmutableAlertConfig.Builder builder = ImmutableAlertConfig.builder();
    if (json.condition != null) {
      builder.condition(json.condition);
    }
    if (json.severity != null) {
      builder.severity(json.severity);
    }
    if (json.emailNotification != null) {
      builder.emailNotification(json.emailNotification);
    }
    if (json.pagerDutyNotification != null) {
      builder.pagerDutyNotification(json.pagerDutyNotification);
    }
    if (json.slackNotification != null) {
      builder.slackNotification(json.slackNotification);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AlertConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AlertConfig instance
   */
  public static ImmutableAlertConfig copyOf(AlertConfig instance) {
    if (instance instanceof ImmutableAlertConfig) {
      return (ImmutableAlertConfig) instance;
    }
    return ImmutableAlertConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAlertConfig ImmutableAlertConfig}.
   * <pre>
   * ImmutableAlertConfig.builder()
   *    .condition(org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig.AlertCondition) // required {@link AlertConfig#condition() condition}
   *    .severity(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity) // required {@link AlertConfig#severity() severity}
   *    .emailNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@org.checkerframework.checker.nullness.qual.Nullable ImmutableEmailNotification | null) // nullable {@link AlertConfig#emailNotification() emailNotification}
   *    .pagerDutyNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@org.checkerframework.checker.nullness.qual.Nullable ImmutablePagerDutyNotification | null) // nullable {@link AlertConfig#pagerDutyNotification() pagerDutyNotification}
   *    .slackNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@org.checkerframework.checker.nullness.qual.Nullable ImmutableSlackNotification | null) // nullable {@link AlertConfig#slackNotification() slackNotification}
   *    .build();
   * </pre>
   * @return A new ImmutableAlertConfig builder
   */
  public static ImmutableAlertConfig.Builder builder() {
    return new ImmutableAlertConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAlertConfig ImmutableAlertConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AlertConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONDITION = 0x1L;
    private static final long INIT_BIT_SEVERITY = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable AlertConfig.AlertCondition condition;
    private @javax.annotation.Nullable AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AlertConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AlertConfig instance) {
      Objects.requireNonNull(instance, "instance");
      condition(instance.condition());
      severity(instance.severity());
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotificationValue = instance.emailNotification();
      if (emailNotificationValue != null) {
        emailNotification(emailNotificationValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotificationValue = instance.pagerDutyNotification();
      if (pagerDutyNotificationValue != null) {
        pagerDutyNotification(pagerDutyNotificationValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotificationValue = instance.slackNotification();
      if (slackNotificationValue != null) {
        slackNotification(slackNotificationValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig#condition() condition} attribute.
     * @param condition The value for condition 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder condition(AlertConfig.AlertCondition condition) {
      this.condition = Objects.requireNonNull(condition, "condition");
      initBits &= ~INIT_BIT_CONDITION;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig#severity() severity} attribute.
     * @param severity The value for severity 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder severity(AgentConfigOuterClass.AgentConfig.AlertConfig.AlertSeverity severity) {
      this.severity = Objects.requireNonNull(severity, "severity");
      initBits &= ~INIT_BIT_SEVERITY;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig#emailNotification() emailNotification} attribute.
     * @param emailNotification The value for emailNotification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder emailNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableEmailNotification emailNotification) {
      this.emailNotification = emailNotification;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig#pagerDutyNotification() pagerDutyNotification} attribute.
     * @param pagerDutyNotification The value for pagerDutyNotification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pagerDutyNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutablePagerDutyNotification pagerDutyNotification) {
      this.pagerDutyNotification = pagerDutyNotification;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig#slackNotification() slackNotification} attribute.
     * @param slackNotification The value for slackNotification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder slackNotification(org.glowroot.agent.shaded.org.glowroot.common.config.@Nullable ImmutableSlackNotification slackNotification) {
      this.slackNotification = slackNotification;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAlertConfig ImmutableAlertConfig}.
     * @return An immutable instance of AlertConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAlertConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAlertConfig(condition, severity, emailNotification, pagerDutyNotification, slackNotification);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONDITION) != 0) attributes.add("condition");
      if ((initBits & INIT_BIT_SEVERITY) != 0) attributes.add("severity");
      return "Cannot build AlertConfig, some of required attributes are not set " + attributes;
    }
  }
}
