package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AlertConfig.SlackNotification}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSlackNotification.builder()}.
 */
@Generated(from = "AlertConfig.SlackNotification", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSlackNotification
    implements AlertConfig.SlackNotification {
  private final String slackWebhookId;
  private final ImmutableList<String> slackChannels;

  private ImmutableSlackNotification(
      String slackWebhookId,
      ImmutableList<String> slackChannels) {
    this.slackWebhookId = slackWebhookId;
    this.slackChannels = slackChannels;
  }

  /**
   * @return The value of the {@code slackWebhookId} attribute
   */
  @JsonProperty("slackWebhookId")
  @Override
  public String slackWebhookId() {
    return slackWebhookId;
  }

  /**
   * @return The value of the {@code slackChannels} attribute
   */
  @JsonProperty("slackChannels")
  @Override
  public ImmutableList<String> slackChannels() {
    return slackChannels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig.SlackNotification#slackWebhookId() slackWebhookId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for slackWebhookId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlackNotification withSlackWebhookId(String value) {
    String newValue = Objects.requireNonNull(value, "slackWebhookId");
    if (this.slackWebhookId.equals(newValue)) return this;
    return new ImmutableSlackNotification(newValue, this.slackChannels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AlertConfig.SlackNotification#slackChannels() slackChannels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSlackNotification withSlackChannels(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSlackNotification(this.slackWebhookId, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AlertConfig.SlackNotification#slackChannels() slackChannels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of slackChannels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSlackNotification withSlackChannels(Iterable<String> elements) {
    if (this.slackChannels == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSlackNotification(this.slackWebhookId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSlackNotification} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSlackNotification
        && equalTo((ImmutableSlackNotification) another);
  }

  private boolean equalTo(ImmutableSlackNotification another) {
    return slackWebhookId.equals(another.slackWebhookId)
        && slackChannels.equals(another.slackChannels);
  }

  /**
   * Computes a hash code from attributes: {@code slackWebhookId}, {@code slackChannels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + slackWebhookId.hashCode();
    h += (h << 5) + slackChannels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackNotification} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SlackNotification")
        .omitNullValues()
        .add("slackWebhookId", slackWebhookId)
        .add("slackChannels", slackChannels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AlertConfig.SlackNotification", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AlertConfig.SlackNotification {
    @Nullable String slackWebhookId;
    @Nullable List<String> slackChannels = ImmutableList.of();
    @JsonProperty("slackWebhookId")
    public void setSlackWebhookId(String slackWebhookId) {
      this.slackWebhookId = slackWebhookId;
    }
    @JsonProperty("slackChannels")
    public void setSlackChannels(List<String> slackChannels) {
      this.slackChannels = slackChannels;
    }
    @Override
    public String slackWebhookId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> slackChannels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSlackNotification fromJson(Json json) {
    ImmutableSlackNotification.Builder builder = ImmutableSlackNotification.builder();
    if (json.slackWebhookId != null) {
      builder.slackWebhookId(json.slackWebhookId);
    }
    if (json.slackChannels != null) {
      builder.addAllSlackChannels(json.slackChannels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AlertConfig.SlackNotification} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackNotification instance
   */
  public static ImmutableSlackNotification copyOf(AlertConfig.SlackNotification instance) {
    if (instance instanceof ImmutableSlackNotification) {
      return (ImmutableSlackNotification) instance;
    }
    return ImmutableSlackNotification.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSlackNotification ImmutableSlackNotification}.
   * <pre>
   * ImmutableSlackNotification.builder()
   *    .slackWebhookId(String) // required {@link AlertConfig.SlackNotification#slackWebhookId() slackWebhookId}
   *    .addSlackChannels|addAllSlackChannels(String) // {@link AlertConfig.SlackNotification#slackChannels() slackChannels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSlackNotification builder
   */
  public static ImmutableSlackNotification.Builder builder() {
    return new ImmutableSlackNotification.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSlackNotification ImmutableSlackNotification}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AlertConfig.SlackNotification", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SLACK_WEBHOOK_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String slackWebhookId;
    private ImmutableList.Builder<String> slackChannels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackNotification} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AlertConfig.SlackNotification instance) {
      Objects.requireNonNull(instance, "instance");
      slackWebhookId(instance.slackWebhookId());
      addAllSlackChannels(instance.slackChannels());
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig.SlackNotification#slackWebhookId() slackWebhookId} attribute.
     * @param slackWebhookId The value for slackWebhookId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder slackWebhookId(String slackWebhookId) {
      this.slackWebhookId = Objects.requireNonNull(slackWebhookId, "slackWebhookId");
      initBits &= ~INIT_BIT_SLACK_WEBHOOK_ID;
      return this;
    }

    /**
     * Adds one element to {@link AlertConfig.SlackNotification#slackChannels() slackChannels} list.
     * @param element A slackChannels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSlackChannels(String element) {
      this.slackChannels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AlertConfig.SlackNotification#slackChannels() slackChannels} list.
     * @param elements An array of slackChannels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSlackChannels(String... elements) {
      this.slackChannels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AlertConfig.SlackNotification#slackChannels() slackChannels} list.
     * @param elements An iterable of slackChannels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder slackChannels(Iterable<String> elements) {
      this.slackChannels = ImmutableList.builder();
      return addAllSlackChannels(elements);
    }

    /**
     * Adds elements to {@link AlertConfig.SlackNotification#slackChannels() slackChannels} list.
     * @param elements An iterable of slackChannels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSlackChannels(Iterable<String> elements) {
      this.slackChannels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSlackNotification ImmutableSlackNotification}.
     * @return An immutable instance of SlackNotification
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSlackNotification build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSlackNotification(slackWebhookId, slackChannels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SLACK_WEBHOOK_ID) != 0) attributes.add("slackWebhookId");
      return "Cannot build SlackNotification, some of required attributes are not set " + attributes;
    }
  }
}
