package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionConfig.SlowThresholdOverride}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSlowThresholdOverride.builder()}.
 */
@Generated(from = "TransactionConfig.SlowThresholdOverride", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSlowThresholdOverride
    extends TransactionConfig.SlowThresholdOverride {
  private final String transactionType;
  private final String transactionName;
  private final String user;
  private final int thresholdMillis;

  private ImmutableSlowThresholdOverride(ImmutableSlowThresholdOverride.Builder builder) {
    this.transactionType = builder.transactionType;
    this.thresholdMillis = builder.thresholdMillis;
    if (builder.transactionName != null) {
      initShim.transactionName(builder.transactionName);
    }
    if (builder.user != null) {
      initShim.user(builder.user);
    }
    this.transactionName = initShim.transactionName();
    this.user = initShim.user();
    this.initShim = null;
  }

  private ImmutableSlowThresholdOverride(
      String transactionType,
      String transactionName,
      String user,
      int thresholdMillis) {
    this.transactionType = transactionType;
    this.transactionName = transactionName;
    this.user = user;
    this.thresholdMillis = thresholdMillis;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TransactionConfig.SlowThresholdOverride", generator = "Immutables")
  private final class InitShim {
    private byte transactionNameBuildStage = STAGE_UNINITIALIZED;
    private String transactionName;

    String transactionName() {
      if (transactionNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (transactionNameBuildStage == STAGE_UNINITIALIZED) {
        transactionNameBuildStage = STAGE_INITIALIZING;
        this.transactionName = Objects.requireNonNull(ImmutableSlowThresholdOverride.super.transactionName(), "transactionName");
        transactionNameBuildStage = STAGE_INITIALIZED;
      }
      return this.transactionName;
    }

    void transactionName(String transactionName) {
      this.transactionName = transactionName;
      transactionNameBuildStage = STAGE_INITIALIZED;
    }

    private byte userBuildStage = STAGE_UNINITIALIZED;
    private String user;

    String user() {
      if (userBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (userBuildStage == STAGE_UNINITIALIZED) {
        userBuildStage = STAGE_INITIALIZING;
        this.user = Objects.requireNonNull(ImmutableSlowThresholdOverride.super.user(), "user");
        userBuildStage = STAGE_INITIALIZED;
      }
      return this.user;
    }

    void user(String user) {
      this.user = user;
      userBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (transactionNameBuildStage == STAGE_INITIALIZING) attributes.add("transactionName");
      if (userBuildStage == STAGE_INITIALIZING) attributes.add("user");
      return "Cannot build SlowThresholdOverride, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }

  /**
   * @return The value of the {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public String transactionName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.transactionName()
        : this.transactionName;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("user")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public String user() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.user()
        : this.user;
  }

  /**
   * @return The value of the {@code thresholdMillis} attribute
   */
  @JsonProperty("thresholdMillis")
  @Override
  public int thresholdMillis() {
    return thresholdMillis;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig.SlowThresholdOverride#transactionType() transactionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlowThresholdOverride withTransactionType(String value) {
    String newValue = Objects.requireNonNull(value, "transactionType");
    if (this.transactionType.equals(newValue)) return this;
    return new ImmutableSlowThresholdOverride(newValue, this.transactionName, this.user, this.thresholdMillis);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig.SlowThresholdOverride#transactionName() transactionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlowThresholdOverride withTransactionName(String value) {
    String newValue = Objects.requireNonNull(value, "transactionName");
    if (this.transactionName.equals(newValue)) return this;
    return new ImmutableSlowThresholdOverride(this.transactionType, newValue, this.user, this.thresholdMillis);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig.SlowThresholdOverride#user() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlowThresholdOverride withUser(String value) {
    String newValue = Objects.requireNonNull(value, "user");
    if (this.user.equals(newValue)) return this;
    return new ImmutableSlowThresholdOverride(this.transactionType, this.transactionName, newValue, this.thresholdMillis);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionConfig.SlowThresholdOverride#thresholdMillis() thresholdMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thresholdMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSlowThresholdOverride withThresholdMillis(int value) {
    if (this.thresholdMillis == value) return this;
    return new ImmutableSlowThresholdOverride(this.transactionType, this.transactionName, this.user, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSlowThresholdOverride} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSlowThresholdOverride
        && equalTo((ImmutableSlowThresholdOverride) another);
  }

  private boolean equalTo(ImmutableSlowThresholdOverride another) {
    return transactionType.equals(another.transactionType)
        && transactionName.equals(another.transactionName)
        && user.equals(another.user)
        && thresholdMillis == another.thresholdMillis;
  }

  /**
   * Computes a hash code from attributes: {@code transactionType}, {@code transactionName}, {@code user}, {@code thresholdMillis}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + transactionType.hashCode();
    h += (h << 5) + transactionName.hashCode();
    h += (h << 5) + user.hashCode();
    h += (h << 5) + thresholdMillis;
    return h;
  }

  /**
   * Prints the immutable value {@code SlowThresholdOverride} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SlowThresholdOverride")
        .omitNullValues()
        .add("transactionType", transactionType)
        .add("transactionName", transactionName)
        .add("user", user)
        .add("thresholdMillis", thresholdMillis)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransactionConfig.SlowThresholdOverride", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends TransactionConfig.SlowThresholdOverride {
    @Nullable String transactionType;
    @Nullable String transactionName;
    @Nullable String user;
    int thresholdMillis;
    boolean thresholdMillisIsSet;
    @JsonProperty("transactionType")
    public void setTransactionType(String transactionType) {
      this.transactionType = transactionType;
    }
    @JsonProperty("transactionName")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setTransactionName(String transactionName) {
      this.transactionName = transactionName;
    }
    @JsonProperty("user")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setUser(String user) {
      this.user = user;
    }
    @JsonProperty("thresholdMillis")
    public void setThresholdMillis(int thresholdMillis) {
      this.thresholdMillis = thresholdMillis;
      this.thresholdMillisIsSet = true;
    }
    @Override
    public String transactionType() { throw new UnsupportedOperationException(); }
    @Override
    public String transactionName() { throw new UnsupportedOperationException(); }
    @Override
    public String user() { throw new UnsupportedOperationException(); }
    @Override
    public int thresholdMillis() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSlowThresholdOverride fromJson(Json json) {
    ImmutableSlowThresholdOverride.Builder builder = ImmutableSlowThresholdOverride.builder();
    if (json.transactionType != null) {
      builder.transactionType(json.transactionType);
    }
    if (json.transactionName != null) {
      builder.transactionName(json.transactionName);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.thresholdMillisIsSet) {
      builder.thresholdMillis(json.thresholdMillis);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TransactionConfig.SlowThresholdOverride} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlowThresholdOverride instance
   */
  public static ImmutableSlowThresholdOverride copyOf(TransactionConfig.SlowThresholdOverride instance) {
    if (instance instanceof ImmutableSlowThresholdOverride) {
      return (ImmutableSlowThresholdOverride) instance;
    }
    return ImmutableSlowThresholdOverride.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSlowThresholdOverride ImmutableSlowThresholdOverride}.
   * <pre>
   * ImmutableSlowThresholdOverride.builder()
   *    .transactionType(String) // required {@link TransactionConfig.SlowThresholdOverride#transactionType() transactionType}
   *    .transactionName(String) // optional {@link TransactionConfig.SlowThresholdOverride#transactionName() transactionName}
   *    .user(String) // optional {@link TransactionConfig.SlowThresholdOverride#user() user}
   *    .thresholdMillis(int) // required {@link TransactionConfig.SlowThresholdOverride#thresholdMillis() thresholdMillis}
   *    .build();
   * </pre>
   * @return A new ImmutableSlowThresholdOverride builder
   */
  public static ImmutableSlowThresholdOverride.Builder builder() {
    return new ImmutableSlowThresholdOverride.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSlowThresholdOverride ImmutableSlowThresholdOverride}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionConfig.SlowThresholdOverride", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION_TYPE = 0x1L;
    private static final long INIT_BIT_THRESHOLD_MILLIS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String transactionType;
    private @Nullable String transactionName;
    private @Nullable String user;
    private int thresholdMillis;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlowThresholdOverride} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TransactionConfig.SlowThresholdOverride instance) {
      Objects.requireNonNull(instance, "instance");
      transactionType(instance.transactionType());
      transactionName(instance.transactionName());
      user(instance.user());
      thresholdMillis(instance.thresholdMillis());
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig.SlowThresholdOverride#transactionType() transactionType} attribute.
     * @param transactionType The value for transactionType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transactionType(String transactionType) {
      this.transactionType = Objects.requireNonNull(transactionType, "transactionType");
      initBits &= ~INIT_BIT_TRANSACTION_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig.SlowThresholdOverride#transactionName() transactionName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionConfig.SlowThresholdOverride#transactionName() transactionName}.</em>
     * @param transactionName The value for transactionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transactionName(String transactionName) {
      this.transactionName = Objects.requireNonNull(transactionName, "transactionName");
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig.SlowThresholdOverride#user() user} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransactionConfig.SlowThresholdOverride#user() user}.</em>
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder user(String user) {
      this.user = Objects.requireNonNull(user, "user");
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionConfig.SlowThresholdOverride#thresholdMillis() thresholdMillis} attribute.
     * @param thresholdMillis The value for thresholdMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder thresholdMillis(int thresholdMillis) {
      this.thresholdMillis = thresholdMillis;
      initBits &= ~INIT_BIT_THRESHOLD_MILLIS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSlowThresholdOverride ImmutableSlowThresholdOverride}.
     * @return An immutable instance of SlowThresholdOverride
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSlowThresholdOverride build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSlowThresholdOverride(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TRANSACTION_TYPE) != 0) attributes.add("transactionType");
      if ((initBits & INIT_BIT_THRESHOLD_MILLIS) != 0) attributes.add("thresholdMillis");
      return "Cannot build SlowThresholdOverride, some of required attributes are not set " + attributes;
    }
  }
}
