package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AlertConfig.SyntheticMonitorCondition}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSyntheticMonitorCondition.builder()}.
 */
@Generated(from = "AlertConfig.SyntheticMonitorCondition", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSyntheticMonitorCondition
    implements AlertConfig.SyntheticMonitorCondition {
  private final String syntheticMonitorId;
  private final int thresholdMillis;
  private final int consecutiveCount;

  private ImmutableSyntheticMonitorCondition(String syntheticMonitorId, int thresholdMillis, int consecutiveCount) {
    this.syntheticMonitorId = syntheticMonitorId;
    this.thresholdMillis = thresholdMillis;
    this.consecutiveCount = consecutiveCount;
  }

  /**
   * @return The value of the {@code syntheticMonitorId} attribute
   */
  @JsonProperty("syntheticMonitorId")
  @Override
  public String syntheticMonitorId() {
    return syntheticMonitorId;
  }

  /**
   * @return The value of the {@code thresholdMillis} attribute
   */
  @JsonProperty("thresholdMillis")
  @Override
  public int thresholdMillis() {
    return thresholdMillis;
  }

  /**
   * @return The value of the {@code consecutiveCount} attribute
   */
  @JsonProperty("consecutiveCount")
  @Override
  public int consecutiveCount() {
    return consecutiveCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig.SyntheticMonitorCondition#syntheticMonitorId() syntheticMonitorId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for syntheticMonitorId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorCondition withSyntheticMonitorId(String value) {
    String newValue = Objects.requireNonNull(value, "syntheticMonitorId");
    if (this.syntheticMonitorId.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorCondition(newValue, this.thresholdMillis, this.consecutiveCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig.SyntheticMonitorCondition#thresholdMillis() thresholdMillis} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thresholdMillis
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorCondition withThresholdMillis(int value) {
    if (this.thresholdMillis == value) return this;
    return new ImmutableSyntheticMonitorCondition(this.syntheticMonitorId, value, this.consecutiveCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AlertConfig.SyntheticMonitorCondition#consecutiveCount() consecutiveCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consecutiveCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorCondition withConsecutiveCount(int value) {
    if (this.consecutiveCount == value) return this;
    return new ImmutableSyntheticMonitorCondition(this.syntheticMonitorId, this.thresholdMillis, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSyntheticMonitorCondition} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSyntheticMonitorCondition
        && equalTo((ImmutableSyntheticMonitorCondition) another);
  }

  private boolean equalTo(ImmutableSyntheticMonitorCondition another) {
    return syntheticMonitorId.equals(another.syntheticMonitorId)
        && thresholdMillis == another.thresholdMillis
        && consecutiveCount == another.consecutiveCount;
  }

  /**
   * Computes a hash code from attributes: {@code syntheticMonitorId}, {@code thresholdMillis}, {@code consecutiveCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + syntheticMonitorId.hashCode();
    h += (h << 5) + thresholdMillis;
    h += (h << 5) + consecutiveCount;
    return h;
  }

  /**
   * Prints the immutable value {@code SyntheticMonitorCondition} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SyntheticMonitorCondition")
        .omitNullValues()
        .add("syntheticMonitorId", syntheticMonitorId)
        .add("thresholdMillis", thresholdMillis)
        .add("consecutiveCount", consecutiveCount)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AlertConfig.SyntheticMonitorCondition", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AlertConfig.SyntheticMonitorCondition {
    @Nullable String syntheticMonitorId;
    int thresholdMillis;
    boolean thresholdMillisIsSet;
    int consecutiveCount;
    boolean consecutiveCountIsSet;
    @JsonProperty("syntheticMonitorId")
    public void setSyntheticMonitorId(String syntheticMonitorId) {
      this.syntheticMonitorId = syntheticMonitorId;
    }
    @JsonProperty("thresholdMillis")
    public void setThresholdMillis(int thresholdMillis) {
      this.thresholdMillis = thresholdMillis;
      this.thresholdMillisIsSet = true;
    }
    @JsonProperty("consecutiveCount")
    public void setConsecutiveCount(int consecutiveCount) {
      this.consecutiveCount = consecutiveCount;
      this.consecutiveCountIsSet = true;
    }
    @Override
    public String syntheticMonitorId() { throw new UnsupportedOperationException(); }
    @Override
    public int thresholdMillis() { throw new UnsupportedOperationException(); }
    @Override
    public int consecutiveCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSyntheticMonitorCondition fromJson(Json json) {
    ImmutableSyntheticMonitorCondition.Builder builder = ImmutableSyntheticMonitorCondition.builder();
    if (json.syntheticMonitorId != null) {
      builder.syntheticMonitorId(json.syntheticMonitorId);
    }
    if (json.thresholdMillisIsSet) {
      builder.thresholdMillis(json.thresholdMillis);
    }
    if (json.consecutiveCountIsSet) {
      builder.consecutiveCount(json.consecutiveCount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AlertConfig.SyntheticMonitorCondition} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SyntheticMonitorCondition instance
   */
  public static ImmutableSyntheticMonitorCondition copyOf(AlertConfig.SyntheticMonitorCondition instance) {
    if (instance instanceof ImmutableSyntheticMonitorCondition) {
      return (ImmutableSyntheticMonitorCondition) instance;
    }
    return ImmutableSyntheticMonitorCondition.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSyntheticMonitorCondition ImmutableSyntheticMonitorCondition}.
   * <pre>
   * ImmutableSyntheticMonitorCondition.builder()
   *    .syntheticMonitorId(String) // required {@link AlertConfig.SyntheticMonitorCondition#syntheticMonitorId() syntheticMonitorId}
   *    .thresholdMillis(int) // required {@link AlertConfig.SyntheticMonitorCondition#thresholdMillis() thresholdMillis}
   *    .consecutiveCount(int) // required {@link AlertConfig.SyntheticMonitorCondition#consecutiveCount() consecutiveCount}
   *    .build();
   * </pre>
   * @return A new ImmutableSyntheticMonitorCondition builder
   */
  public static ImmutableSyntheticMonitorCondition.Builder builder() {
    return new ImmutableSyntheticMonitorCondition.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSyntheticMonitorCondition ImmutableSyntheticMonitorCondition}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AlertConfig.SyntheticMonitorCondition", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SYNTHETIC_MONITOR_ID = 0x1L;
    private static final long INIT_BIT_THRESHOLD_MILLIS = 0x2L;
    private static final long INIT_BIT_CONSECUTIVE_COUNT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String syntheticMonitorId;
    private int thresholdMillis;
    private int consecutiveCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SyntheticMonitorCondition} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(AlertConfig.SyntheticMonitorCondition instance) {
      Objects.requireNonNull(instance, "instance");
      syntheticMonitorId(instance.syntheticMonitorId());
      thresholdMillis(instance.thresholdMillis());
      consecutiveCount(instance.consecutiveCount());
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig.SyntheticMonitorCondition#syntheticMonitorId() syntheticMonitorId} attribute.
     * @param syntheticMonitorId The value for syntheticMonitorId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder syntheticMonitorId(String syntheticMonitorId) {
      this.syntheticMonitorId = Objects.requireNonNull(syntheticMonitorId, "syntheticMonitorId");
      initBits &= ~INIT_BIT_SYNTHETIC_MONITOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig.SyntheticMonitorCondition#thresholdMillis() thresholdMillis} attribute.
     * @param thresholdMillis The value for thresholdMillis 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder thresholdMillis(int thresholdMillis) {
      this.thresholdMillis = thresholdMillis;
      initBits &= ~INIT_BIT_THRESHOLD_MILLIS;
      return this;
    }

    /**
     * Initializes the value for the {@link AlertConfig.SyntheticMonitorCondition#consecutiveCount() consecutiveCount} attribute.
     * @param consecutiveCount The value for consecutiveCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder consecutiveCount(int consecutiveCount) {
      this.consecutiveCount = consecutiveCount;
      initBits &= ~INIT_BIT_CONSECUTIVE_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSyntheticMonitorCondition ImmutableSyntheticMonitorCondition}.
     * @return An immutable instance of SyntheticMonitorCondition
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSyntheticMonitorCondition build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSyntheticMonitorCondition(syntheticMonitorId, thresholdMillis, consecutiveCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SYNTHETIC_MONITOR_ID) != 0) attributes.add("syntheticMonitorId");
      if ((initBits & INIT_BIT_THRESHOLD_MILLIS) != 0) attributes.add("thresholdMillis");
      if ((initBits & INIT_BIT_CONSECUTIVE_COUNT) != 0) attributes.add("consecutiveCount");
      return "Cannot build SyntheticMonitorCondition, some of required attributes are not set " + attributes;
    }
  }
}
