package org.glowroot.agent.shaded.org.glowroot.common.config;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SyntheticMonitorConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSyntheticMonitorConfig.builder()}.
 */
@Generated(from = "SyntheticMonitorConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSyntheticMonitorConfig extends SyntheticMonitorConfig {
  private final String id;
  private final AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind;
  private final String display;
  private final String pingUrl;
  private final String javaSource;

  private ImmutableSyntheticMonitorConfig(ImmutableSyntheticMonitorConfig.Builder builder) {
    this.id = builder.id;
    this.kind = builder.kind;
    if (builder.display != null) {
      initShim.display(builder.display);
    }
    if (builder.pingUrl != null) {
      initShim.pingUrl(builder.pingUrl);
    }
    if (builder.javaSource != null) {
      initShim.javaSource(builder.javaSource);
    }
    this.display = initShim.display();
    this.pingUrl = initShim.pingUrl();
    this.javaSource = initShim.javaSource();
    this.initShim = null;
  }

  private ImmutableSyntheticMonitorConfig(
      String id,
      AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind,
      String display,
      String pingUrl,
      String javaSource) {
    this.id = id;
    this.kind = kind;
    this.display = display;
    this.pingUrl = pingUrl;
    this.javaSource = javaSource;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SyntheticMonitorConfig", generator = "Immutables")
  private final class InitShim {
    private byte displayBuildStage = STAGE_UNINITIALIZED;
    private String display;

    String display() {
      if (displayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (displayBuildStage == STAGE_UNINITIALIZED) {
        displayBuildStage = STAGE_INITIALIZING;
        this.display = Objects.requireNonNull(ImmutableSyntheticMonitorConfig.super.display(), "display");
        displayBuildStage = STAGE_INITIALIZED;
      }
      return this.display;
    }

    void display(String display) {
      this.display = display;
      displayBuildStage = STAGE_INITIALIZED;
    }

    private byte pingUrlBuildStage = STAGE_UNINITIALIZED;
    private String pingUrl;

    String pingUrl() {
      if (pingUrlBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (pingUrlBuildStage == STAGE_UNINITIALIZED) {
        pingUrlBuildStage = STAGE_INITIALIZING;
        this.pingUrl = Objects.requireNonNull(ImmutableSyntheticMonitorConfig.super.pingUrl(), "pingUrl");
        pingUrlBuildStage = STAGE_INITIALIZED;
      }
      return this.pingUrl;
    }

    void pingUrl(String pingUrl) {
      this.pingUrl = pingUrl;
      pingUrlBuildStage = STAGE_INITIALIZED;
    }

    private byte javaSourceBuildStage = STAGE_UNINITIALIZED;
    private String javaSource;

    String javaSource() {
      if (javaSourceBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (javaSourceBuildStage == STAGE_UNINITIALIZED) {
        javaSourceBuildStage = STAGE_INITIALIZING;
        this.javaSource = Objects.requireNonNull(ImmutableSyntheticMonitorConfig.super.javaSource(), "javaSource");
        javaSourceBuildStage = STAGE_INITIALIZED;
      }
      return this.javaSource;
    }

    void javaSource(String javaSource) {
      this.javaSource = javaSource;
      javaSourceBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (displayBuildStage == STAGE_INITIALIZING) attributes.add("display");
      if (pingUrlBuildStage == STAGE_INITIALIZING) attributes.add("pingUrl");
      if (javaSourceBuildStage == STAGE_INITIALIZING) attributes.add("javaSource");
      return "Cannot build SyntheticMonitorConfig, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @JsonProperty("kind")
  @Override
  public AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind() {
    return kind;
  }

  /**
   * @return The value of the {@code display} attribute
   */
  @JsonProperty("display")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public String display() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.display()
        : this.display;
  }

  /**
   * @return The value of the {@code pingUrl} attribute
   */
  @JsonProperty("pingUrl")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public String pingUrl() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pingUrl()
        : this.pingUrl;
  }

  /**
   * @return The value of the {@code javaSource} attribute
   */
  @JsonProperty("javaSource")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public String javaSource() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.javaSource()
        : this.javaSource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SyntheticMonitorConfig#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorConfig withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorConfig(newValue, this.kind, this.display, this.pingUrl, this.javaSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SyntheticMonitorConfig#kind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorConfig withKind(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind value) {
    if (this.kind == value) return this;
    AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorConfig(this.id, newValue, this.display, this.pingUrl, this.javaSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SyntheticMonitorConfig#display() display} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for display
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorConfig withDisplay(String value) {
    String newValue = Objects.requireNonNull(value, "display");
    if (this.display.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorConfig(this.id, this.kind, newValue, this.pingUrl, this.javaSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SyntheticMonitorConfig#pingUrl() pingUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pingUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorConfig withPingUrl(String value) {
    String newValue = Objects.requireNonNull(value, "pingUrl");
    if (this.pingUrl.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorConfig(this.id, this.kind, this.display, newValue, this.javaSource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SyntheticMonitorConfig#javaSource() javaSource} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for javaSource
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSyntheticMonitorConfig withJavaSource(String value) {
    String newValue = Objects.requireNonNull(value, "javaSource");
    if (this.javaSource.equals(newValue)) return this;
    return new ImmutableSyntheticMonitorConfig(this.id, this.kind, this.display, this.pingUrl, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSyntheticMonitorConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSyntheticMonitorConfig
        && equalTo((ImmutableSyntheticMonitorConfig) another);
  }

  private boolean equalTo(ImmutableSyntheticMonitorConfig another) {
    return id.equals(another.id)
        && kind.equals(another.kind)
        && display.equals(another.display)
        && pingUrl.equals(another.pingUrl)
        && javaSource.equals(another.javaSource);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code kind}, {@code display}, {@code pingUrl}, {@code javaSource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + kind.hashCode();
    h += (h << 5) + display.hashCode();
    h += (h << 5) + pingUrl.hashCode();
    h += (h << 5) + javaSource.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SyntheticMonitorConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SyntheticMonitorConfig")
        .omitNullValues()
        .add("id", id)
        .add("kind", kind)
        .add("display", display)
        .add("pingUrl", pingUrl)
        .add("javaSource", javaSource)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SyntheticMonitorConfig", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends SyntheticMonitorConfig {
    @Nullable String id;
    @Nullable AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind;
    @Nullable String display;
    @Nullable String pingUrl;
    @Nullable String javaSource;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("kind")
    public void setKind(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind) {
      this.kind = kind;
    }
    @JsonProperty("display")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setDisplay(String display) {
      this.display = display;
    }
    @JsonProperty("pingUrl")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setPingUrl(String pingUrl) {
      this.pingUrl = pingUrl;
    }
    @JsonProperty("javaSource")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setJavaSource(String javaSource) {
      this.javaSource = javaSource;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind() { throw new UnsupportedOperationException(); }
    @Override
    public String display() { throw new UnsupportedOperationException(); }
    @Override
    public String pingUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String javaSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSyntheticMonitorConfig fromJson(Json json) {
    ImmutableSyntheticMonitorConfig.Builder builder = ImmutableSyntheticMonitorConfig.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.kind != null) {
      builder.kind(json.kind);
    }
    if (json.display != null) {
      builder.display(json.display);
    }
    if (json.pingUrl != null) {
      builder.pingUrl(json.pingUrl);
    }
    if (json.javaSource != null) {
      builder.javaSource(json.javaSource);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SyntheticMonitorConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SyntheticMonitorConfig instance
   */
  public static ImmutableSyntheticMonitorConfig copyOf(SyntheticMonitorConfig instance) {
    if (instance instanceof ImmutableSyntheticMonitorConfig) {
      return (ImmutableSyntheticMonitorConfig) instance;
    }
    return ImmutableSyntheticMonitorConfig.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSyntheticMonitorConfig ImmutableSyntheticMonitorConfig}.
   * <pre>
   * ImmutableSyntheticMonitorConfig.builder()
   *    .id(String) // required {@link SyntheticMonitorConfig#id() id}
   *    .kind(org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind) // required {@link SyntheticMonitorConfig#kind() kind}
   *    .display(String) // optional {@link SyntheticMonitorConfig#display() display}
   *    .pingUrl(String) // optional {@link SyntheticMonitorConfig#pingUrl() pingUrl}
   *    .javaSource(String) // optional {@link SyntheticMonitorConfig#javaSource() javaSource}
   *    .build();
   * </pre>
   * @return A new ImmutableSyntheticMonitorConfig builder
   */
  public static ImmutableSyntheticMonitorConfig.Builder builder() {
    return new ImmutableSyntheticMonitorConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSyntheticMonitorConfig ImmutableSyntheticMonitorConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SyntheticMonitorConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind;
    private @Nullable String display;
    private @Nullable String pingUrl;
    private @Nullable String javaSource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SyntheticMonitorConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(SyntheticMonitorConfig instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      kind(instance.kind());
      display(instance.display());
      pingUrl(instance.pingUrl());
      javaSource(instance.javaSource());
      return this;
    }

    /**
     * Initializes the value for the {@link SyntheticMonitorConfig#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SyntheticMonitorConfig#kind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(AgentConfigOuterClass.AgentConfig.SyntheticMonitorConfig.SyntheticMonitorKind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return this;
    }

    /**
     * Initializes the value for the {@link SyntheticMonitorConfig#display() display} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SyntheticMonitorConfig#display() display}.</em>
     * @param display The value for display 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder display(String display) {
      this.display = Objects.requireNonNull(display, "display");
      return this;
    }

    /**
     * Initializes the value for the {@link SyntheticMonitorConfig#pingUrl() pingUrl} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SyntheticMonitorConfig#pingUrl() pingUrl}.</em>
     * @param pingUrl The value for pingUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pingUrl(String pingUrl) {
      this.pingUrl = Objects.requireNonNull(pingUrl, "pingUrl");
      return this;
    }

    /**
     * Initializes the value for the {@link SyntheticMonitorConfig#javaSource() javaSource} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SyntheticMonitorConfig#javaSource() javaSource}.</em>
     * @param javaSource The value for javaSource 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaSource(String javaSource) {
      this.javaSource = Objects.requireNonNull(javaSource, "javaSource");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSyntheticMonitorConfig ImmutableSyntheticMonitorConfig}.
     * @return An immutable instance of SyntheticMonitorConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSyntheticMonitorConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSyntheticMonitorConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build SyntheticMonitorConfig, some of required attributes are not set " + attributes;
    }
  }
}
