package org.glowroot.agent.shaded.org.glowroot.common.live;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LiveTraceRepository.TracePointFilter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTracePointFilter.builder()}.
 */
@Generated(from = "LiveTraceRepository.TracePointFilter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTracePointFilter
    extends LiveTraceRepository.TracePointFilter {
  private final long durationNanosLow;
  private final java.lang.@Nullable Long durationNanosHigh;
  private final org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator;
  private final java.lang.@Nullable String headline;
  private final org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator;
  private final java.lang.@Nullable String errorMessage;
  private final org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator;
  private final java.lang.@Nullable String user;
  private final java.lang.@Nullable String attributeName;
  private final org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator;
  private final java.lang.@Nullable String attributeValue;

  private ImmutableTracePointFilter(
      long durationNanosLow,
      java.lang.@Nullable Long durationNanosHigh,
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator,
      java.lang.@Nullable String headline,
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator,
      java.lang.@Nullable String errorMessage,
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator,
      java.lang.@Nullable String user,
      java.lang.@Nullable String attributeName,
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator,
      java.lang.@Nullable String attributeValue) {
    this.durationNanosLow = durationNanosLow;
    this.durationNanosHigh = durationNanosHigh;
    this.headlineComparator = headlineComparator;
    this.headline = headline;
    this.errorMessageComparator = errorMessageComparator;
    this.errorMessage = errorMessage;
    this.userComparator = userComparator;
    this.user = user;
    this.attributeName = attributeName;
    this.attributeValueComparator = attributeValueComparator;
    this.attributeValue = attributeValue;
  }

  /**
   * @return The value of the {@code durationNanosLow} attribute
   */
  @JsonProperty("durationNanosLow")
  @Override
  public long durationNanosLow() {
    return durationNanosLow;
  }

  /**
   * @return The value of the {@code durationNanosHigh} attribute
   */
  @JsonProperty("durationNanosHigh")
  @Override
  public java.lang.@Nullable Long durationNanosHigh() {
    return durationNanosHigh;
  }

  /**
   * @return The value of the {@code headlineComparator} attribute
   */
  @JsonProperty("headlineComparator")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator() {
    return headlineComparator;
  }

  /**
   * @return The value of the {@code headline} attribute
   */
  @JsonProperty("headline")
  @Override
  public java.lang.@Nullable String headline() {
    return headline;
  }

  /**
   * @return The value of the {@code errorMessageComparator} attribute
   */
  @JsonProperty("errorMessageComparator")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator() {
    return errorMessageComparator;
  }

  /**
   * @return The value of the {@code errorMessage} attribute
   */
  @JsonProperty("errorMessage")
  @Override
  public java.lang.@Nullable String errorMessage() {
    return errorMessage;
  }

  /**
   * @return The value of the {@code userComparator} attribute
   */
  @JsonProperty("userComparator")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator() {
    return userComparator;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public java.lang.@Nullable String user() {
    return user;
  }

  /**
   * @return The value of the {@code attributeName} attribute
   */
  @JsonProperty("attributeName")
  @Override
  public java.lang.@Nullable String attributeName() {
    return attributeName;
  }

  /**
   * @return The value of the {@code attributeValueComparator} attribute
   */
  @JsonProperty("attributeValueComparator")
  @Override
  public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator() {
    return attributeValueComparator;
  }

  /**
   * @return The value of the {@code attributeValue} attribute
   */
  @JsonProperty("attributeValue")
  @Override
  public java.lang.@Nullable String attributeValue() {
    return attributeValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#durationNanosLow() durationNanosLow} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for durationNanosLow
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withDurationNanosLow(long value) {
    if (this.durationNanosLow == value) return this;
    return new ImmutableTracePointFilter(
        value,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#durationNanosHigh() durationNanosHigh} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for durationNanosHigh (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withDurationNanosHigh(java.lang.@Nullable Long value) {
    if (Objects.equals(this.durationNanosHigh, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        value,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#headlineComparator() headlineComparator} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headlineComparator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withHeadlineComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator value) {
    if (this.headlineComparator == value) return this;
    if (Objects.equals(this.headlineComparator, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        value,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#headline() headline} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headline (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withHeadline(java.lang.@Nullable String value) {
    if (Objects.equals(this.headline, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        value,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#errorMessageComparator() errorMessageComparator} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessageComparator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withErrorMessageComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator value) {
    if (this.errorMessageComparator == value) return this;
    if (Objects.equals(this.errorMessageComparator, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        value,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#errorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withErrorMessage(java.lang.@Nullable String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        value,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#userComparator() userComparator} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userComparator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withUserComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator value) {
    if (this.userComparator == value) return this;
    if (Objects.equals(this.userComparator, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        value,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#user() user} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withUser(java.lang.@Nullable String value) {
    if (Objects.equals(this.user, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        value,
        this.attributeName,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#attributeName() attributeName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributeName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withAttributeName(java.lang.@Nullable String value) {
    if (Objects.equals(this.attributeName, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        value,
        this.attributeValueComparator,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#attributeValueComparator() attributeValueComparator} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributeValueComparator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withAttributeValueComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator value) {
    if (this.attributeValueComparator == value) return this;
    if (Objects.equals(this.attributeValueComparator, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        value,
        this.attributeValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiveTraceRepository.TracePointFilter#attributeValue() attributeValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributeValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTracePointFilter withAttributeValue(java.lang.@Nullable String value) {
    if (Objects.equals(this.attributeValue, value)) return this;
    return new ImmutableTracePointFilter(
        this.durationNanosLow,
        this.durationNanosHigh,
        this.headlineComparator,
        this.headline,
        this.errorMessageComparator,
        this.errorMessage,
        this.userComparator,
        this.user,
        this.attributeName,
        this.attributeValueComparator,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTracePointFilter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTracePointFilter
        && equalTo((ImmutableTracePointFilter) another);
  }

  private boolean equalTo(ImmutableTracePointFilter another) {
    return durationNanosLow == another.durationNanosLow
        && Objects.equals(durationNanosHigh, another.durationNanosHigh)
        && Objects.equals(headlineComparator, another.headlineComparator)
        && Objects.equals(headline, another.headline)
        && Objects.equals(errorMessageComparator, another.errorMessageComparator)
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(userComparator, another.userComparator)
        && Objects.equals(user, another.user)
        && Objects.equals(attributeName, another.attributeName)
        && Objects.equals(attributeValueComparator, another.attributeValueComparator)
        && Objects.equals(attributeValue, another.attributeValue);
  }

  /**
   * Computes a hash code from attributes: {@code durationNanosLow}, {@code durationNanosHigh}, {@code headlineComparator}, {@code headline}, {@code errorMessageComparator}, {@code errorMessage}, {@code userComparator}, {@code user}, {@code attributeName}, {@code attributeValueComparator}, {@code attributeValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(durationNanosLow);
    h += (h << 5) + Objects.hashCode(durationNanosHigh);
    h += (h << 5) + Objects.hashCode(headlineComparator);
    h += (h << 5) + Objects.hashCode(headline);
    h += (h << 5) + Objects.hashCode(errorMessageComparator);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(userComparator);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(attributeName);
    h += (h << 5) + Objects.hashCode(attributeValueComparator);
    h += (h << 5) + Objects.hashCode(attributeValue);
    return h;
  }

  /**
   * Prints the immutable value {@code TracePointFilter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TracePointFilter")
        .omitNullValues()
        .add("durationNanosLow", durationNanosLow)
        .add("durationNanosHigh", durationNanosHigh)
        .add("headlineComparator", headlineComparator)
        .add("headline", headline)
        .add("errorMessageComparator", errorMessageComparator)
        .add("errorMessage", errorMessage)
        .add("userComparator", userComparator)
        .add("user", user)
        .add("attributeName", attributeName)
        .add("attributeValueComparator", attributeValueComparator)
        .add("attributeValue", attributeValue)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LiveTraceRepository.TracePointFilter", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends LiveTraceRepository.TracePointFilter {
    long durationNanosLow;
    boolean durationNanosLowIsSet;
    @javax.annotation.Nullable java.lang.@Nullable Long durationNanosHigh;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator;
    @javax.annotation.Nullable java.lang.@Nullable String headline;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator;
    @javax.annotation.Nullable java.lang.@Nullable String errorMessage;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator;
    @javax.annotation.Nullable java.lang.@Nullable String user;
    @javax.annotation.Nullable java.lang.@Nullable String attributeName;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator;
    @javax.annotation.Nullable java.lang.@Nullable String attributeValue;
    @JsonProperty("durationNanosLow")
    public void setDurationNanosLow(long durationNanosLow) {
      this.durationNanosLow = durationNanosLow;
      this.durationNanosLowIsSet = true;
    }
    @JsonProperty("durationNanosHigh")
    public void setDurationNanosHigh(java.lang.@Nullable Long durationNanosHigh) {
      this.durationNanosHigh = durationNanosHigh;
    }
    @JsonProperty("headlineComparator")
    public void setHeadlineComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator) {
      this.headlineComparator = headlineComparator;
    }
    @JsonProperty("headline")
    public void setHeadline(java.lang.@Nullable String headline) {
      this.headline = headline;
    }
    @JsonProperty("errorMessageComparator")
    public void setErrorMessageComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator) {
      this.errorMessageComparator = errorMessageComparator;
    }
    @JsonProperty("errorMessage")
    public void setErrorMessage(java.lang.@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
    }
    @JsonProperty("userComparator")
    public void setUserComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator) {
      this.userComparator = userComparator;
    }
    @JsonProperty("user")
    public void setUser(java.lang.@Nullable String user) {
      this.user = user;
    }
    @JsonProperty("attributeName")
    public void setAttributeName(java.lang.@Nullable String attributeName) {
      this.attributeName = attributeName;
    }
    @JsonProperty("attributeValueComparator")
    public void setAttributeValueComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator) {
      this.attributeValueComparator = attributeValueComparator;
    }
    @JsonProperty("attributeValue")
    public void setAttributeValue(java.lang.@Nullable String attributeValue) {
      this.attributeValue = attributeValue;
    }
    @Override
    public long durationNanosLow() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable Long durationNanosHigh() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable String headline() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable String errorMessage() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable String user() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable String attributeName() { throw new UnsupportedOperationException(); }
    @Override
    public org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator() { throw new UnsupportedOperationException(); }
    @Override
    public java.lang.@Nullable String attributeValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTracePointFilter fromJson(Json json) {
    ImmutableTracePointFilter.Builder builder = ImmutableTracePointFilter.builder();
    if (json.durationNanosLowIsSet) {
      builder.durationNanosLow(json.durationNanosLow);
    }
    if (json.durationNanosHigh != null) {
      builder.durationNanosHigh(json.durationNanosHigh);
    }
    if (json.headlineComparator != null) {
      builder.headlineComparator(json.headlineComparator);
    }
    if (json.headline != null) {
      builder.headline(json.headline);
    }
    if (json.errorMessageComparator != null) {
      builder.errorMessageComparator(json.errorMessageComparator);
    }
    if (json.errorMessage != null) {
      builder.errorMessage(json.errorMessage);
    }
    if (json.userComparator != null) {
      builder.userComparator(json.userComparator);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.attributeName != null) {
      builder.attributeName(json.attributeName);
    }
    if (json.attributeValueComparator != null) {
      builder.attributeValueComparator(json.attributeValueComparator);
    }
    if (json.attributeValue != null) {
      builder.attributeValue(json.attributeValue);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiveTraceRepository.TracePointFilter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TracePointFilter instance
   */
  public static ImmutableTracePointFilter copyOf(LiveTraceRepository.TracePointFilter instance) {
    if (instance instanceof ImmutableTracePointFilter) {
      return (ImmutableTracePointFilter) instance;
    }
    return ImmutableTracePointFilter.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTracePointFilter ImmutableTracePointFilter}.
   * <pre>
   * ImmutableTracePointFilter.builder()
   *    .durationNanosLow(long) // required {@link LiveTraceRepository.TracePointFilter#durationNanosLow() durationNanosLow}
   *    .durationNanosHigh(@org.checkerframework.checker.nullness.qual.Nullable Long | null) // nullable {@link LiveTraceRepository.TracePointFilter#durationNanosHigh() durationNanosHigh}
   *    .headlineComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@org.checkerframework.checker.nullness.qual.Nullable StringComparator | null) // nullable {@link LiveTraceRepository.TracePointFilter#headlineComparator() headlineComparator}
   *    .headline(@org.checkerframework.checker.nullness.qual.Nullable String | null) // nullable {@link LiveTraceRepository.TracePointFilter#headline() headline}
   *    .errorMessageComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@org.checkerframework.checker.nullness.qual.Nullable StringComparator | null) // nullable {@link LiveTraceRepository.TracePointFilter#errorMessageComparator() errorMessageComparator}
   *    .errorMessage(@org.checkerframework.checker.nullness.qual.Nullable String | null) // nullable {@link LiveTraceRepository.TracePointFilter#errorMessage() errorMessage}
   *    .userComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@org.checkerframework.checker.nullness.qual.Nullable StringComparator | null) // nullable {@link LiveTraceRepository.TracePointFilter#userComparator() userComparator}
   *    .user(@org.checkerframework.checker.nullness.qual.Nullable String | null) // nullable {@link LiveTraceRepository.TracePointFilter#user() user}
   *    .attributeName(@org.checkerframework.checker.nullness.qual.Nullable String | null) // nullable {@link LiveTraceRepository.TracePointFilter#attributeName() attributeName}
   *    .attributeValueComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@org.checkerframework.checker.nullness.qual.Nullable StringComparator | null) // nullable {@link LiveTraceRepository.TracePointFilter#attributeValueComparator() attributeValueComparator}
   *    .attributeValue(@org.checkerframework.checker.nullness.qual.Nullable String | null) // nullable {@link LiveTraceRepository.TracePointFilter#attributeValue() attributeValue}
   *    .build();
   * </pre>
   * @return A new ImmutableTracePointFilter builder
   */
  public static ImmutableTracePointFilter.Builder builder() {
    return new ImmutableTracePointFilter.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTracePointFilter ImmutableTracePointFilter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LiveTraceRepository.TracePointFilter", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DURATION_NANOS_LOW = 0x1L;
    private long initBits = 0x1L;

    private long durationNanosLow;
    private @javax.annotation.Nullable java.lang.@Nullable Long durationNanosHigh;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator;
    private @javax.annotation.Nullable java.lang.@Nullable String headline;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator;
    private @javax.annotation.Nullable java.lang.@Nullable String errorMessage;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator;
    private @javax.annotation.Nullable java.lang.@Nullable String user;
    private @javax.annotation.Nullable java.lang.@Nullable String attributeName;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator;
    private @javax.annotation.Nullable java.lang.@Nullable String attributeValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TracePointFilter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(LiveTraceRepository.TracePointFilter instance) {
      Objects.requireNonNull(instance, "instance");
      durationNanosLow(instance.durationNanosLow());
      java.lang.@Nullable Long durationNanosHighValue = instance.durationNanosHigh();
      if (durationNanosHighValue != null) {
        durationNanosHigh(durationNanosHighValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparatorValue = instance.headlineComparator();
      if (headlineComparatorValue != null) {
        headlineComparator(headlineComparatorValue);
      }
      java.lang.@Nullable String headlineValue = instance.headline();
      if (headlineValue != null) {
        headline(headlineValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparatorValue = instance.errorMessageComparator();
      if (errorMessageComparatorValue != null) {
        errorMessageComparator(errorMessageComparatorValue);
      }
      java.lang.@Nullable String errorMessageValue = instance.errorMessage();
      if (errorMessageValue != null) {
        errorMessage(errorMessageValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparatorValue = instance.userComparator();
      if (userComparatorValue != null) {
        userComparator(userComparatorValue);
      }
      java.lang.@Nullable String userValue = instance.user();
      if (userValue != null) {
        user(userValue);
      }
      java.lang.@Nullable String attributeNameValue = instance.attributeName();
      if (attributeNameValue != null) {
        attributeName(attributeNameValue);
      }
      org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparatorValue = instance.attributeValueComparator();
      if (attributeValueComparatorValue != null) {
        attributeValueComparator(attributeValueComparatorValue);
      }
      java.lang.@Nullable String attributeValueValue = instance.attributeValue();
      if (attributeValueValue != null) {
        attributeValue(attributeValueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#durationNanosLow() durationNanosLow} attribute.
     * @param durationNanosLow The value for durationNanosLow 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder durationNanosLow(long durationNanosLow) {
      this.durationNanosLow = durationNanosLow;
      initBits &= ~INIT_BIT_DURATION_NANOS_LOW;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#durationNanosHigh() durationNanosHigh} attribute.
     * @param durationNanosHigh The value for durationNanosHigh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder durationNanosHigh(java.lang.@Nullable Long durationNanosHigh) {
      this.durationNanosHigh = durationNanosHigh;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#headlineComparator() headlineComparator} attribute.
     * @param headlineComparator The value for headlineComparator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headlineComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator headlineComparator) {
      this.headlineComparator = headlineComparator;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#headline() headline} attribute.
     * @param headline The value for headline (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headline(java.lang.@Nullable String headline) {
      this.headline = headline;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#errorMessageComparator() errorMessageComparator} attribute.
     * @param errorMessageComparator The value for errorMessageComparator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorMessageComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator errorMessageComparator) {
      this.errorMessageComparator = errorMessageComparator;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#errorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder errorMessage(java.lang.@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#userComparator() userComparator} attribute.
     * @param userComparator The value for userComparator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder userComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator userComparator) {
      this.userComparator = userComparator;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder user(java.lang.@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#attributeName() attributeName} attribute.
     * @param attributeName The value for attributeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attributeName(java.lang.@Nullable String attributeName) {
      this.attributeName = attributeName;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#attributeValueComparator() attributeValueComparator} attribute.
     * @param attributeValueComparator The value for attributeValueComparator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attributeValueComparator(org.glowroot.agent.shaded.org.glowroot.common.live.@Nullable StringComparator attributeValueComparator) {
      this.attributeValueComparator = attributeValueComparator;
      return this;
    }

    /**
     * Initializes the value for the {@link LiveTraceRepository.TracePointFilter#attributeValue() attributeValue} attribute.
     * @param attributeValue The value for attributeValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attributeValue(java.lang.@Nullable String attributeValue) {
      this.attributeValue = attributeValue;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTracePointFilter ImmutableTracePointFilter}.
     * @return An immutable instance of TracePointFilter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTracePointFilter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTracePointFilter(
          durationNanosLow,
          durationNanosHigh,
          headlineComparator,
          headline,
          errorMessageComparator,
          errorMessage,
          userComparator,
          user,
          attributeName,
          attributeValueComparator,
          attributeValue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DURATION_NANOS_LOW) != 0) attributes.add("durationNanosLow");
      return "Cannot build TracePointFilter, some of required attributes are not set " + attributes;
    }
  }
}
