package org.glowroot.agent.shaded.org.glowroot.common.model;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransactionNameSummaryCollector.TransactionNameSummary}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransactionNameSummary.builder()}.
 */
@Generated(from = "TransactionNameSummaryCollector.TransactionNameSummary", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransactionNameSummary
    implements TransactionNameSummaryCollector.TransactionNameSummary {
  private final String transactionName;
  private final double totalDurationNanos;
  private final double totalCpuNanos;
  private final double totalAllocatedBytes;
  private final long transactionCount;

  private ImmutableTransactionNameSummary(
      String transactionName,
      double totalDurationNanos,
      double totalCpuNanos,
      double totalAllocatedBytes,
      long transactionCount) {
    this.transactionName = transactionName;
    this.totalDurationNanos = totalDurationNanos;
    this.totalCpuNanos = totalCpuNanos;
    this.totalAllocatedBytes = totalAllocatedBytes;
    this.transactionCount = transactionCount;
  }

  /**
   * @return The value of the {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }

  /**
   * @return The value of the {@code totalDurationNanos} attribute
   */
  @JsonProperty("totalDurationNanos")
  @Override
  public double totalDurationNanos() {
    return totalDurationNanos;
  }

  /**
   * @return The value of the {@code totalCpuNanos} attribute
   */
  @JsonProperty("totalCpuNanos")
  @Override
  public double totalCpuNanos() {
    return totalCpuNanos;
  }

  /**
   * @return The value of the {@code totalAllocatedBytes} attribute
   */
  @JsonProperty("totalAllocatedBytes")
  @Override
  public double totalAllocatedBytes() {
    return totalAllocatedBytes;
  }

  /**
   * @return The value of the {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionName() transactionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameSummary withTransactionName(String value) {
    String newValue = Objects.requireNonNull(value, "transactionName");
    if (this.transactionName.equals(newValue)) return this;
    return new ImmutableTransactionNameSummary(
        newValue,
        this.totalDurationNanos,
        this.totalCpuNanos,
        this.totalAllocatedBytes,
        this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalDurationNanos() totalDurationNanos} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalDurationNanos
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameSummary withTotalDurationNanos(double value) {
    if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) return this;
    return new ImmutableTransactionNameSummary(
        this.transactionName,
        value,
        this.totalCpuNanos,
        this.totalAllocatedBytes,
        this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalCpuNanos() totalCpuNanos} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCpuNanos
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameSummary withTotalCpuNanos(double value) {
    if (Double.doubleToLongBits(this.totalCpuNanos) == Double.doubleToLongBits(value)) return this;
    return new ImmutableTransactionNameSummary(
        this.transactionName,
        this.totalDurationNanos,
        value,
        this.totalAllocatedBytes,
        this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalAllocatedBytes() totalAllocatedBytes} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalAllocatedBytes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameSummary withTotalAllocatedBytes(double value) {
    if (Double.doubleToLongBits(this.totalAllocatedBytes) == Double.doubleToLongBits(value)) return this;
    return new ImmutableTransactionNameSummary(this.transactionName, this.totalDurationNanos, this.totalCpuNanos, value, this.transactionCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionCount() transactionCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactionCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransactionNameSummary withTransactionCount(long value) {
    if (this.transactionCount == value) return this;
    return new ImmutableTransactionNameSummary(
        this.transactionName,
        this.totalDurationNanos,
        this.totalCpuNanos,
        this.totalAllocatedBytes,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransactionNameSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransactionNameSummary
        && equalTo((ImmutableTransactionNameSummary) another);
  }

  private boolean equalTo(ImmutableTransactionNameSummary another) {
    return transactionName.equals(another.transactionName)
        && Double.doubleToLongBits(totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos)
        && Double.doubleToLongBits(totalCpuNanos) == Double.doubleToLongBits(another.totalCpuNanos)
        && Double.doubleToLongBits(totalAllocatedBytes) == Double.doubleToLongBits(another.totalAllocatedBytes)
        && transactionCount == another.transactionCount;
  }

  /**
   * Computes a hash code from attributes: {@code transactionName}, {@code totalDurationNanos}, {@code totalCpuNanos}, {@code totalAllocatedBytes}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + transactionName.hashCode();
    h += (h << 5) + Doubles.hashCode(totalDurationNanos);
    h += (h << 5) + Doubles.hashCode(totalCpuNanos);
    h += (h << 5) + Doubles.hashCode(totalAllocatedBytes);
    h += (h << 5) + Longs.hashCode(transactionCount);
    return h;
  }

  /**
   * Prints the immutable value {@code TransactionNameSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransactionNameSummary")
        .omitNullValues()
        .add("transactionName", transactionName)
        .add("totalDurationNanos", totalDurationNanos)
        .add("totalCpuNanos", totalCpuNanos)
        .add("totalAllocatedBytes", totalAllocatedBytes)
        .add("transactionCount", transactionCount)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TransactionNameSummaryCollector.TransactionNameSummary", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements TransactionNameSummaryCollector.TransactionNameSummary {
    @Nullable String transactionName;
    double totalDurationNanos;
    boolean totalDurationNanosIsSet;
    double totalCpuNanos;
    boolean totalCpuNanosIsSet;
    double totalAllocatedBytes;
    boolean totalAllocatedBytesIsSet;
    long transactionCount;
    boolean transactionCountIsSet;
    @JsonProperty("transactionName")
    public void setTransactionName(String transactionName) {
      this.transactionName = transactionName;
    }
    @JsonProperty("totalDurationNanos")
    public void setTotalDurationNanos(double totalDurationNanos) {
      this.totalDurationNanos = totalDurationNanos;
      this.totalDurationNanosIsSet = true;
    }
    @JsonProperty("totalCpuNanos")
    public void setTotalCpuNanos(double totalCpuNanos) {
      this.totalCpuNanos = totalCpuNanos;
      this.totalCpuNanosIsSet = true;
    }
    @JsonProperty("totalAllocatedBytes")
    public void setTotalAllocatedBytes(double totalAllocatedBytes) {
      this.totalAllocatedBytes = totalAllocatedBytes;
      this.totalAllocatedBytesIsSet = true;
    }
    @JsonProperty("transactionCount")
    public void setTransactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      this.transactionCountIsSet = true;
    }
    @Override
    public String transactionName() { throw new UnsupportedOperationException(); }
    @Override
    public double totalDurationNanos() { throw new UnsupportedOperationException(); }
    @Override
    public double totalCpuNanos() { throw new UnsupportedOperationException(); }
    @Override
    public double totalAllocatedBytes() { throw new UnsupportedOperationException(); }
    @Override
    public long transactionCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTransactionNameSummary fromJson(Json json) {
    ImmutableTransactionNameSummary.Builder builder = ImmutableTransactionNameSummary.builder();
    if (json.transactionName != null) {
      builder.transactionName(json.transactionName);
    }
    if (json.totalDurationNanosIsSet) {
      builder.totalDurationNanos(json.totalDurationNanos);
    }
    if (json.totalCpuNanosIsSet) {
      builder.totalCpuNanos(json.totalCpuNanos);
    }
    if (json.totalAllocatedBytesIsSet) {
      builder.totalAllocatedBytes(json.totalAllocatedBytes);
    }
    if (json.transactionCountIsSet) {
      builder.transactionCount(json.transactionCount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TransactionNameSummaryCollector.TransactionNameSummary} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransactionNameSummary instance
   */
  public static ImmutableTransactionNameSummary copyOf(TransactionNameSummaryCollector.TransactionNameSummary instance) {
    if (instance instanceof ImmutableTransactionNameSummary) {
      return (ImmutableTransactionNameSummary) instance;
    }
    return ImmutableTransactionNameSummary.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransactionNameSummary ImmutableTransactionNameSummary}.
   * <pre>
   * ImmutableTransactionNameSummary.builder()
   *    .transactionName(String) // required {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionName() transactionName}
   *    .totalDurationNanos(double) // required {@link TransactionNameSummaryCollector.TransactionNameSummary#totalDurationNanos() totalDurationNanos}
   *    .totalCpuNanos(double) // required {@link TransactionNameSummaryCollector.TransactionNameSummary#totalCpuNanos() totalCpuNanos}
   *    .totalAllocatedBytes(double) // required {@link TransactionNameSummaryCollector.TransactionNameSummary#totalAllocatedBytes() totalAllocatedBytes}
   *    .transactionCount(long) // required {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionCount() transactionCount}
   *    .build();
   * </pre>
   * @return A new ImmutableTransactionNameSummary builder
   */
  public static ImmutableTransactionNameSummary.Builder builder() {
    return new ImmutableTransactionNameSummary.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransactionNameSummary ImmutableTransactionNameSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransactionNameSummaryCollector.TransactionNameSummary", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRANSACTION_NAME = 0x1L;
    private static final long INIT_BIT_TOTAL_DURATION_NANOS = 0x2L;
    private static final long INIT_BIT_TOTAL_CPU_NANOS = 0x4L;
    private static final long INIT_BIT_TOTAL_ALLOCATED_BYTES = 0x8L;
    private static final long INIT_BIT_TRANSACTION_COUNT = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String transactionName;
    private double totalDurationNanos;
    private double totalCpuNanos;
    private double totalAllocatedBytes;
    private long transactionCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransactionNameSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(TransactionNameSummaryCollector.TransactionNameSummary instance) {
      Objects.requireNonNull(instance, "instance");
      transactionName(instance.transactionName());
      totalDurationNanos(instance.totalDurationNanos());
      totalCpuNanos(instance.totalCpuNanos());
      totalAllocatedBytes(instance.totalAllocatedBytes());
      transactionCount(instance.transactionCount());
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionName() transactionName} attribute.
     * @param transactionName The value for transactionName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transactionName(String transactionName) {
      this.transactionName = Objects.requireNonNull(transactionName, "transactionName");
      initBits &= ~INIT_BIT_TRANSACTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalDurationNanos() totalDurationNanos} attribute.
     * @param totalDurationNanos The value for totalDurationNanos 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder totalDurationNanos(double totalDurationNanos) {
      this.totalDurationNanos = totalDurationNanos;
      initBits &= ~INIT_BIT_TOTAL_DURATION_NANOS;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalCpuNanos() totalCpuNanos} attribute.
     * @param totalCpuNanos The value for totalCpuNanos 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder totalCpuNanos(double totalCpuNanos) {
      this.totalCpuNanos = totalCpuNanos;
      initBits &= ~INIT_BIT_TOTAL_CPU_NANOS;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#totalAllocatedBytes() totalAllocatedBytes} attribute.
     * @param totalAllocatedBytes The value for totalAllocatedBytes 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder totalAllocatedBytes(double totalAllocatedBytes) {
      this.totalAllocatedBytes = totalAllocatedBytes;
      initBits &= ~INIT_BIT_TOTAL_ALLOCATED_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link TransactionNameSummaryCollector.TransactionNameSummary#transactionCount() transactionCount} attribute.
     * @param transactionCount The value for transactionCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initBits &= ~INIT_BIT_TRANSACTION_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransactionNameSummary ImmutableTransactionNameSummary}.
     * @return An immutable instance of TransactionNameSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransactionNameSummary build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransactionNameSummary(transactionName, totalDurationNanos, totalCpuNanos, totalAllocatedBytes, transactionCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TRANSACTION_NAME) != 0) attributes.add("transactionName");
      if ((initBits & INIT_BIT_TOTAL_DURATION_NANOS) != 0) attributes.add("totalDurationNanos");
      if ((initBits & INIT_BIT_TOTAL_CPU_NANOS) != 0) attributes.add("totalCpuNanos");
      if ((initBits & INIT_BIT_TOTAL_ALLOCATED_BYTES) != 0) attributes.add("totalAllocatedBytes");
      if ((initBits & INIT_BIT_TRANSACTION_COUNT) != 0) attributes.add("transactionCount");
      return "Cannot build TransactionNameSummary, some of required attributes are not set " + attributes;
    }
  }
}
