package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Advice}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAdvice.builder()}.
 */
@Generated(from = "Advice", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAdvice extends Advice {
  private final Pointcut pointcut;
  private final org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType;
  private final java.util.regex.@Nullable Pattern pointcutClassNamePattern;
  private final java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern;
  private final java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern;
  private final java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern;
  private final java.util.regex.@Nullable Pattern pointcutMethodNamePattern;
  private final java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern;
  private final ImmutableList<Object> pointcutMethodParameterTypes;
  private final org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType;
  private final org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice;
  private final org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice;
  private final org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice;
  private final org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice;
  private final org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice;
  private final ImmutableList<Advice.AdviceParameter> isEnabledParameters;
  private final ImmutableList<Advice.AdviceParameter> onBeforeParameters;
  private final ImmutableList<Advice.AdviceParameter> onReturnParameters;
  private final ImmutableList<Advice.AdviceParameter> onThrowParameters;
  private final ImmutableList<Advice.AdviceParameter> onAfterParameters;
  private final boolean hasBindThreadContext;
  private final boolean hasBindOptionalThreadContext;
  private final boolean reweavable;
  private final org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice;
  private final ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass;
  private transient final ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> classMetaTypes;
  private transient final ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> methodMetaTypes;

  private ImmutableAdvice(
      Pointcut pointcut,
      org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType,
      java.util.regex.@Nullable Pattern pointcutClassNamePattern,
      java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern,
      java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern,
      java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern,
      java.util.regex.@Nullable Pattern pointcutMethodNamePattern,
      java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern,
      ImmutableList<Object> pointcutMethodParameterTypes,
      org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType,
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice,
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice,
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice,
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice,
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice,
      ImmutableList<Advice.AdviceParameter> isEnabledParameters,
      ImmutableList<Advice.AdviceParameter> onBeforeParameters,
      ImmutableList<Advice.AdviceParameter> onReturnParameters,
      ImmutableList<Advice.AdviceParameter> onThrowParameters,
      ImmutableList<Advice.AdviceParameter> onAfterParameters,
      boolean hasBindThreadContext,
      boolean hasBindOptionalThreadContext,
      boolean reweavable,
      org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice,
      ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass) {
    this.pointcut = pointcut;
    this.adviceType = adviceType;
    this.pointcutClassNamePattern = pointcutClassNamePattern;
    this.pointcutClassAnnotationPattern = pointcutClassAnnotationPattern;
    this.pointcutSubTypeRestrictionPattern = pointcutSubTypeRestrictionPattern;
    this.pointcutSuperTypeRestrictionPattern = pointcutSuperTypeRestrictionPattern;
    this.pointcutMethodNamePattern = pointcutMethodNamePattern;
    this.pointcutMethodAnnotationPattern = pointcutMethodAnnotationPattern;
    this.pointcutMethodParameterTypes = pointcutMethodParameterTypes;
    this.travelerType = travelerType;
    this.isEnabledAdvice = isEnabledAdvice;
    this.onBeforeAdvice = onBeforeAdvice;
    this.onReturnAdvice = onReturnAdvice;
    this.onThrowAdvice = onThrowAdvice;
    this.onAfterAdvice = onAfterAdvice;
    this.isEnabledParameters = isEnabledParameters;
    this.onBeforeParameters = onBeforeParameters;
    this.onReturnParameters = onReturnParameters;
    this.onThrowParameters = onThrowParameters;
    this.onAfterParameters = onAfterParameters;
    this.hasBindThreadContext = hasBindThreadContext;
    this.hasBindOptionalThreadContext = hasBindOptionalThreadContext;
    this.reweavable = reweavable;
    this.nonBootstrapLoaderAdvice = nonBootstrapLoaderAdvice;
    this.nonBootstrapLoaderAdviceClass = nonBootstrapLoaderAdviceClass;
    this.classMetaTypes = initShim.classMetaTypes();
    this.methodMetaTypes = initShim.methodMetaTypes();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Advice", generator = "Immutables")
  private final class InitShim {
    private byte classMetaTypesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> classMetaTypes;

    ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> classMetaTypes() {
      if (classMetaTypesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (classMetaTypesBuildStage == STAGE_UNINITIALIZED) {
        classMetaTypesBuildStage = STAGE_INITIALIZING;
        this.classMetaTypes = Objects.requireNonNull(ImmutableAdvice.super.classMetaTypes(), "classMetaTypes");
        classMetaTypesBuildStage = STAGE_INITIALIZED;
      }
      return this.classMetaTypes;
    }

    private byte methodMetaTypesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> methodMetaTypes;

    ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> methodMetaTypes() {
      if (methodMetaTypesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (methodMetaTypesBuildStage == STAGE_UNINITIALIZED) {
        methodMetaTypesBuildStage = STAGE_INITIALIZING;
        this.methodMetaTypes = Objects.requireNonNull(ImmutableAdvice.super.methodMetaTypes(), "methodMetaTypes");
        methodMetaTypesBuildStage = STAGE_INITIALIZED;
      }
      return this.methodMetaTypes;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (classMetaTypesBuildStage == STAGE_INITIALIZING) attributes.add("classMetaTypes");
      if (methodMetaTypesBuildStage == STAGE_INITIALIZING) attributes.add("methodMetaTypes");
      return "Cannot build Advice, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code pointcut} attribute
   */
  @JsonProperty("pointcut")
  @Override
  Pointcut pointcut() {
    return pointcut;
  }

  /**
   * @return The value of the {@code adviceType} attribute
   */
  @JsonProperty("adviceType")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType() {
    return adviceType;
  }

  /**
   * @return The value of the {@code pointcutClassNamePattern} attribute
   */
  @JsonProperty("pointcutClassNamePattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutClassNamePattern() {
    return pointcutClassNamePattern;
  }

  /**
   * @return The value of the {@code pointcutClassAnnotationPattern} attribute
   */
  @JsonProperty("pointcutClassAnnotationPattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern() {
    return pointcutClassAnnotationPattern;
  }

  /**
   * @return The value of the {@code pointcutSubTypeRestrictionPattern} attribute
   */
  @JsonProperty("pointcutSubTypeRestrictionPattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern() {
    return pointcutSubTypeRestrictionPattern;
  }

  /**
   * @return The value of the {@code pointcutSuperTypeRestrictionPattern} attribute
   */
  @JsonProperty("pointcutSuperTypeRestrictionPattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern() {
    return pointcutSuperTypeRestrictionPattern;
  }

  /**
   * @return The value of the {@code pointcutMethodNamePattern} attribute
   */
  @JsonProperty("pointcutMethodNamePattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutMethodNamePattern() {
    return pointcutMethodNamePattern;
  }

  /**
   * @return The value of the {@code pointcutMethodAnnotationPattern} attribute
   */
  @JsonProperty("pointcutMethodAnnotationPattern")
  @Override
  java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern() {
    return pointcutMethodAnnotationPattern;
  }

  /**
   * @return The value of the {@code pointcutMethodParameterTypes} attribute
   */
  @JsonProperty("pointcutMethodParameterTypes")
  @Override
  ImmutableList<Object> pointcutMethodParameterTypes() {
    return pointcutMethodParameterTypes;
  }

  /**
   * @return The value of the {@code travelerType} attribute
   */
  @JsonProperty("travelerType")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType() {
    return travelerType;
  }

  /**
   * @return The value of the {@code isEnabledAdvice} attribute
   */
  @JsonProperty("isEnabledAdvice")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice() {
    return isEnabledAdvice;
  }

  /**
   * @return The value of the {@code onBeforeAdvice} attribute
   */
  @JsonProperty("onBeforeAdvice")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice() {
    return onBeforeAdvice;
  }

  /**
   * @return The value of the {@code onReturnAdvice} attribute
   */
  @JsonProperty("onReturnAdvice")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice() {
    return onReturnAdvice;
  }

  /**
   * @return The value of the {@code onThrowAdvice} attribute
   */
  @JsonProperty("onThrowAdvice")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice() {
    return onThrowAdvice;
  }

  /**
   * @return The value of the {@code onAfterAdvice} attribute
   */
  @JsonProperty("onAfterAdvice")
  @Override
  org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice() {
    return onAfterAdvice;
  }

  /**
   * @return The value of the {@code isEnabledParameters} attribute
   */
  @JsonProperty("isEnabledParameters")
  @Override
  ImmutableList<Advice.AdviceParameter> isEnabledParameters() {
    return isEnabledParameters;
  }

  /**
   * @return The value of the {@code onBeforeParameters} attribute
   */
  @JsonProperty("onBeforeParameters")
  @Override
  ImmutableList<Advice.AdviceParameter> onBeforeParameters() {
    return onBeforeParameters;
  }

  /**
   * @return The value of the {@code onReturnParameters} attribute
   */
  @JsonProperty("onReturnParameters")
  @Override
  ImmutableList<Advice.AdviceParameter> onReturnParameters() {
    return onReturnParameters;
  }

  /**
   * @return The value of the {@code onThrowParameters} attribute
   */
  @JsonProperty("onThrowParameters")
  @Override
  ImmutableList<Advice.AdviceParameter> onThrowParameters() {
    return onThrowParameters;
  }

  /**
   * @return The value of the {@code onAfterParameters} attribute
   */
  @JsonProperty("onAfterParameters")
  @Override
  ImmutableList<Advice.AdviceParameter> onAfterParameters() {
    return onAfterParameters;
  }

  /**
   * @return The value of the {@code hasBindThreadContext} attribute
   */
  @JsonProperty("hasBindThreadContext")
  @Override
  boolean hasBindThreadContext() {
    return hasBindThreadContext;
  }

  /**
   * @return The value of the {@code hasBindOptionalThreadContext} attribute
   */
  @JsonProperty("hasBindOptionalThreadContext")
  @Override
  boolean hasBindOptionalThreadContext() {
    return hasBindOptionalThreadContext;
  }

  /**
   * @return The value of the {@code reweavable} attribute
   */
  @JsonProperty("reweavable")
  @Override
  boolean reweavable() {
    return reweavable;
  }

  /**
   * @return The value of the {@code nonBootstrapLoaderAdvice} attribute
   */
  @JsonProperty("nonBootstrapLoaderAdvice")
  @Override
  org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice() {
    return nonBootstrapLoaderAdvice;
  }

  /**
   * @return The value of the {@code nonBootstrapLoaderAdviceClass} attribute
   */
  @JsonProperty("nonBootstrapLoaderAdviceClass")
  @Override
  ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass() {
    return nonBootstrapLoaderAdviceClass;
  }

  /**
   * @return The computed-at-construction value of the {@code classMetaTypes} attribute
   */
  @JsonProperty("classMetaTypes")
  @Override
  ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> classMetaTypes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.classMetaTypes()
        : this.classMetaTypes;
  }

  /**
   * @return The computed-at-construction value of the {@code methodMetaTypes} attribute
   */
  @JsonProperty("methodMetaTypes")
  @Override
  ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> methodMetaTypes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.methodMetaTypes()
        : this.methodMetaTypes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcut() pointcut} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcut
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcut(Pointcut value) {
    if (this.pointcut == value) return this;
    Pointcut newValue = Objects.requireNonNull(value, "pointcut");
    return new ImmutableAdvice(
        newValue,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#adviceType() adviceType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for adviceType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withAdviceType(org.glowroot.agent.shaded.org.objectweb.asm.Type value) {
    if (this.adviceType == value) return this;
    org.glowroot.agent.shaded.org.objectweb.asm.Type newValue = Objects.requireNonNull(value, "adviceType");
    return new ImmutableAdvice(
        this.pointcut,
        newValue,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutClassNamePattern() pointcutClassNamePattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutClassNamePattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutClassNamePattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutClassNamePattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        value,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutClassAnnotationPattern() pointcutClassAnnotationPattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutClassAnnotationPattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutClassAnnotationPattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutClassAnnotationPattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        value,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutSubTypeRestrictionPattern() pointcutSubTypeRestrictionPattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutSubTypeRestrictionPattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutSubTypeRestrictionPattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutSubTypeRestrictionPattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        value,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutSuperTypeRestrictionPattern() pointcutSuperTypeRestrictionPattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutSuperTypeRestrictionPattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutSuperTypeRestrictionPattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutSuperTypeRestrictionPattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        value,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutMethodNamePattern() pointcutMethodNamePattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutMethodNamePattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutMethodNamePattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutMethodNamePattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        value,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#pointcutMethodAnnotationPattern() pointcutMethodAnnotationPattern} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcutMethodAnnotationPattern (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withPointcutMethodAnnotationPattern(java.util.regex.@Nullable Pattern value) {
    if (this.pointcutMethodAnnotationPattern == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        value,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withPointcutMethodParameterTypes(Object... elements) {
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        newValue,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pointcutMethodParameterTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withPointcutMethodParameterTypes(Iterable<? extends Object> elements) {
    if (this.pointcutMethodParameterTypes == elements) return this;
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        newValue,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#travelerType() travelerType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for travelerType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withTravelerType(org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type value) {
    if (this.travelerType == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        value,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#isEnabledAdvice() isEnabledAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isEnabledAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withIsEnabledAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method value) {
    if (this.isEnabledAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        value,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#onBeforeAdvice() onBeforeAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onBeforeAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withOnBeforeAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method value) {
    if (this.onBeforeAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        value,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#onReturnAdvice() onReturnAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onReturnAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withOnReturnAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method value) {
    if (this.onReturnAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        value,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#onThrowAdvice() onThrowAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onThrowAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withOnThrowAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method value) {
    if (this.onThrowAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        value,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#onAfterAdvice() onAfterAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for onAfterAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withOnAfterAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method value) {
    if (this.onAfterAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        value,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#isEnabledParameters() isEnabledParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withIsEnabledParameters(Advice.AdviceParameter... elements) {
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        newValue,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#isEnabledParameters() isEnabledParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of isEnabledParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withIsEnabledParameters(Iterable<? extends Advice.AdviceParameter> elements) {
    if (this.isEnabledParameters == elements) return this;
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        newValue,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onBeforeParameters() onBeforeParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnBeforeParameters(Advice.AdviceParameter... elements) {
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        newValue,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onBeforeParameters() onBeforeParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of onBeforeParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnBeforeParameters(Iterable<? extends Advice.AdviceParameter> elements) {
    if (this.onBeforeParameters == elements) return this;
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        newValue,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onReturnParameters() onReturnParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnReturnParameters(Advice.AdviceParameter... elements) {
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        newValue,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onReturnParameters() onReturnParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of onReturnParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnReturnParameters(Iterable<? extends Advice.AdviceParameter> elements) {
    if (this.onReturnParameters == elements) return this;
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        newValue,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onThrowParameters() onThrowParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnThrowParameters(Advice.AdviceParameter... elements) {
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        newValue,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onThrowParameters() onThrowParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of onThrowParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnThrowParameters(Iterable<? extends Advice.AdviceParameter> elements) {
    if (this.onThrowParameters == elements) return this;
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        newValue,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onAfterParameters() onAfterParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnAfterParameters(Advice.AdviceParameter... elements) {
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        newValue,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Advice#onAfterParameters() onAfterParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of onAfterParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAdvice withOnAfterParameters(Iterable<? extends Advice.AdviceParameter> elements) {
    if (this.onAfterParameters == elements) return this;
    ImmutableList<Advice.AdviceParameter> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        newValue,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#hasBindThreadContext() hasBindThreadContext} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasBindThreadContext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withHasBindThreadContext(boolean value) {
    if (this.hasBindThreadContext == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        value,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#hasBindOptionalThreadContext() hasBindOptionalThreadContext} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasBindOptionalThreadContext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withHasBindOptionalThreadContext(boolean value) {
    if (this.hasBindOptionalThreadContext == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        value,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#reweavable() reweavable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reweavable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withReweavable(boolean value) {
    if (this.reweavable == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        value,
        this.nonBootstrapLoaderAdvice,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#nonBootstrapLoaderAdvice() nonBootstrapLoaderAdvice} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nonBootstrapLoaderAdvice (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withNonBootstrapLoaderAdvice(org.glowroot.agent.weaving.@Nullable Advice value) {
    if (this.nonBootstrapLoaderAdvice == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        value,
        this.nonBootstrapLoaderAdviceClass);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Advice#nonBootstrapLoaderAdviceClass() nonBootstrapLoaderAdviceClass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nonBootstrapLoaderAdviceClass (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAdvice withNonBootstrapLoaderAdviceClass(ClassLoaders.@Nullable LazyDefinedClass value) {
    if (this.nonBootstrapLoaderAdviceClass == value) return this;
    return new ImmutableAdvice(
        this.pointcut,
        this.adviceType,
        this.pointcutClassNamePattern,
        this.pointcutClassAnnotationPattern,
        this.pointcutSubTypeRestrictionPattern,
        this.pointcutSuperTypeRestrictionPattern,
        this.pointcutMethodNamePattern,
        this.pointcutMethodAnnotationPattern,
        this.pointcutMethodParameterTypes,
        this.travelerType,
        this.isEnabledAdvice,
        this.onBeforeAdvice,
        this.onReturnAdvice,
        this.onThrowAdvice,
        this.onAfterAdvice,
        this.isEnabledParameters,
        this.onBeforeParameters,
        this.onReturnParameters,
        this.onThrowParameters,
        this.onAfterParameters,
        this.hasBindThreadContext,
        this.hasBindOptionalThreadContext,
        this.reweavable,
        this.nonBootstrapLoaderAdvice,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAdvice} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAdvice
        && equalTo((ImmutableAdvice) another);
  }

  private boolean equalTo(ImmutableAdvice another) {
    return pointcut.equals(another.pointcut)
        && adviceType.equals(another.adviceType)
        && Objects.equals(pointcutClassNamePattern, another.pointcutClassNamePattern)
        && Objects.equals(pointcutClassAnnotationPattern, another.pointcutClassAnnotationPattern)
        && Objects.equals(pointcutSubTypeRestrictionPattern, another.pointcutSubTypeRestrictionPattern)
        && Objects.equals(pointcutSuperTypeRestrictionPattern, another.pointcutSuperTypeRestrictionPattern)
        && Objects.equals(pointcutMethodNamePattern, another.pointcutMethodNamePattern)
        && Objects.equals(pointcutMethodAnnotationPattern, another.pointcutMethodAnnotationPattern)
        && pointcutMethodParameterTypes.equals(another.pointcutMethodParameterTypes)
        && Objects.equals(travelerType, another.travelerType)
        && Objects.equals(isEnabledAdvice, another.isEnabledAdvice)
        && Objects.equals(onBeforeAdvice, another.onBeforeAdvice)
        && Objects.equals(onReturnAdvice, another.onReturnAdvice)
        && Objects.equals(onThrowAdvice, another.onThrowAdvice)
        && Objects.equals(onAfterAdvice, another.onAfterAdvice)
        && isEnabledParameters.equals(another.isEnabledParameters)
        && onBeforeParameters.equals(another.onBeforeParameters)
        && onReturnParameters.equals(another.onReturnParameters)
        && onThrowParameters.equals(another.onThrowParameters)
        && onAfterParameters.equals(another.onAfterParameters)
        && hasBindThreadContext == another.hasBindThreadContext
        && hasBindOptionalThreadContext == another.hasBindOptionalThreadContext
        && reweavable == another.reweavable
        && Objects.equals(nonBootstrapLoaderAdvice, another.nonBootstrapLoaderAdvice)
        && Objects.equals(nonBootstrapLoaderAdviceClass, another.nonBootstrapLoaderAdviceClass)
        && classMetaTypes.equals(another.classMetaTypes)
        && methodMetaTypes.equals(another.methodMetaTypes);
  }

  /**
   * Computes a hash code from attributes: {@code pointcut}, {@code adviceType}, {@code pointcutClassNamePattern}, {@code pointcutClassAnnotationPattern}, {@code pointcutSubTypeRestrictionPattern}, {@code pointcutSuperTypeRestrictionPattern}, {@code pointcutMethodNamePattern}, {@code pointcutMethodAnnotationPattern}, {@code pointcutMethodParameterTypes}, {@code travelerType}, {@code isEnabledAdvice}, {@code onBeforeAdvice}, {@code onReturnAdvice}, {@code onThrowAdvice}, {@code onAfterAdvice}, {@code isEnabledParameters}, {@code onBeforeParameters}, {@code onReturnParameters}, {@code onThrowParameters}, {@code onAfterParameters}, {@code hasBindThreadContext}, {@code hasBindOptionalThreadContext}, {@code reweavable}, {@code nonBootstrapLoaderAdvice}, {@code nonBootstrapLoaderAdviceClass}, {@code classMetaTypes}, {@code methodMetaTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + pointcut.hashCode();
    h += (h << 5) + adviceType.hashCode();
    h += (h << 5) + Objects.hashCode(pointcutClassNamePattern);
    h += (h << 5) + Objects.hashCode(pointcutClassAnnotationPattern);
    h += (h << 5) + Objects.hashCode(pointcutSubTypeRestrictionPattern);
    h += (h << 5) + Objects.hashCode(pointcutSuperTypeRestrictionPattern);
    h += (h << 5) + Objects.hashCode(pointcutMethodNamePattern);
    h += (h << 5) + Objects.hashCode(pointcutMethodAnnotationPattern);
    h += (h << 5) + pointcutMethodParameterTypes.hashCode();
    h += (h << 5) + Objects.hashCode(travelerType);
    h += (h << 5) + Objects.hashCode(isEnabledAdvice);
    h += (h << 5) + Objects.hashCode(onBeforeAdvice);
    h += (h << 5) + Objects.hashCode(onReturnAdvice);
    h += (h << 5) + Objects.hashCode(onThrowAdvice);
    h += (h << 5) + Objects.hashCode(onAfterAdvice);
    h += (h << 5) + isEnabledParameters.hashCode();
    h += (h << 5) + onBeforeParameters.hashCode();
    h += (h << 5) + onReturnParameters.hashCode();
    h += (h << 5) + onThrowParameters.hashCode();
    h += (h << 5) + onAfterParameters.hashCode();
    h += (h << 5) + Booleans.hashCode(hasBindThreadContext);
    h += (h << 5) + Booleans.hashCode(hasBindOptionalThreadContext);
    h += (h << 5) + Booleans.hashCode(reweavable);
    h += (h << 5) + Objects.hashCode(nonBootstrapLoaderAdvice);
    h += (h << 5) + Objects.hashCode(nonBootstrapLoaderAdviceClass);
    h += (h << 5) + classMetaTypes.hashCode();
    h += (h << 5) + methodMetaTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Advice} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Advice")
        .omitNullValues()
        .add("pointcut", pointcut)
        .add("adviceType", adviceType)
        .add("pointcutClassNamePattern", pointcutClassNamePattern)
        .add("pointcutClassAnnotationPattern", pointcutClassAnnotationPattern)
        .add("pointcutSubTypeRestrictionPattern", pointcutSubTypeRestrictionPattern)
        .add("pointcutSuperTypeRestrictionPattern", pointcutSuperTypeRestrictionPattern)
        .add("pointcutMethodNamePattern", pointcutMethodNamePattern)
        .add("pointcutMethodAnnotationPattern", pointcutMethodAnnotationPattern)
        .add("pointcutMethodParameterTypes", pointcutMethodParameterTypes)
        .add("travelerType", travelerType)
        .add("isEnabledAdvice", isEnabledAdvice)
        .add("onBeforeAdvice", onBeforeAdvice)
        .add("onReturnAdvice", onReturnAdvice)
        .add("onThrowAdvice", onThrowAdvice)
        .add("onAfterAdvice", onAfterAdvice)
        .add("isEnabledParameters", isEnabledParameters)
        .add("onBeforeParameters", onBeforeParameters)
        .add("onReturnParameters", onReturnParameters)
        .add("onThrowParameters", onThrowParameters)
        .add("onAfterParameters", onAfterParameters)
        .add("hasBindThreadContext", hasBindThreadContext)
        .add("hasBindOptionalThreadContext", hasBindOptionalThreadContext)
        .add("reweavable", reweavable)
        .add("nonBootstrapLoaderAdvice", nonBootstrapLoaderAdvice)
        .add("nonBootstrapLoaderAdviceClass", nonBootstrapLoaderAdviceClass)
        .add("classMetaTypes", classMetaTypes)
        .add("methodMetaTypes", methodMetaTypes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Advice", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Advice {
    @javax.annotation.Nullable Pointcut pointcut;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutClassNamePattern;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutMethodNamePattern;
    @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern;
    @javax.annotation.Nullable List<Object> pointcutMethodParameterTypes = ImmutableList.of();
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice;
    @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice;
    @javax.annotation.Nullable ImmutableList<Advice.AdviceParameter> isEnabledParameters = ImmutableList.of();
    @javax.annotation.Nullable ImmutableList<Advice.AdviceParameter> onBeforeParameters = ImmutableList.of();
    @javax.annotation.Nullable ImmutableList<Advice.AdviceParameter> onReturnParameters = ImmutableList.of();
    @javax.annotation.Nullable ImmutableList<Advice.AdviceParameter> onThrowParameters = ImmutableList.of();
    @javax.annotation.Nullable ImmutableList<Advice.AdviceParameter> onAfterParameters = ImmutableList.of();
    boolean hasBindThreadContext;
    boolean hasBindThreadContextIsSet;
    boolean hasBindOptionalThreadContext;
    boolean hasBindOptionalThreadContextIsSet;
    boolean reweavable;
    boolean reweavableIsSet;
    @javax.annotation.Nullable org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice;
    @javax.annotation.Nullable ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass;
    @JsonProperty("pointcut")
    public void setPointcut(Pointcut pointcut) {
      this.pointcut = pointcut;
    }
    @JsonProperty("adviceType")
    public void setAdviceType(org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType) {
      this.adviceType = adviceType;
    }
    @JsonProperty("pointcutClassNamePattern")
    public void setPointcutClassNamePattern(java.util.regex.@Nullable Pattern pointcutClassNamePattern) {
      this.pointcutClassNamePattern = pointcutClassNamePattern;
    }
    @JsonProperty("pointcutClassAnnotationPattern")
    public void setPointcutClassAnnotationPattern(java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern) {
      this.pointcutClassAnnotationPattern = pointcutClassAnnotationPattern;
    }
    @JsonProperty("pointcutSubTypeRestrictionPattern")
    public void setPointcutSubTypeRestrictionPattern(java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern) {
      this.pointcutSubTypeRestrictionPattern = pointcutSubTypeRestrictionPattern;
    }
    @JsonProperty("pointcutSuperTypeRestrictionPattern")
    public void setPointcutSuperTypeRestrictionPattern(java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern) {
      this.pointcutSuperTypeRestrictionPattern = pointcutSuperTypeRestrictionPattern;
    }
    @JsonProperty("pointcutMethodNamePattern")
    public void setPointcutMethodNamePattern(java.util.regex.@Nullable Pattern pointcutMethodNamePattern) {
      this.pointcutMethodNamePattern = pointcutMethodNamePattern;
    }
    @JsonProperty("pointcutMethodAnnotationPattern")
    public void setPointcutMethodAnnotationPattern(java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern) {
      this.pointcutMethodAnnotationPattern = pointcutMethodAnnotationPattern;
    }
    @JsonProperty("pointcutMethodParameterTypes")
    public void setPointcutMethodParameterTypes(List<Object> pointcutMethodParameterTypes) {
      this.pointcutMethodParameterTypes = pointcutMethodParameterTypes;
    }
    @JsonProperty("travelerType")
    public void setTravelerType(org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType) {
      this.travelerType = travelerType;
    }
    @JsonProperty("isEnabledAdvice")
    public void setIsEnabledAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice) {
      this.isEnabledAdvice = isEnabledAdvice;
    }
    @JsonProperty("onBeforeAdvice")
    public void setOnBeforeAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice) {
      this.onBeforeAdvice = onBeforeAdvice;
    }
    @JsonProperty("onReturnAdvice")
    public void setOnReturnAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice) {
      this.onReturnAdvice = onReturnAdvice;
    }
    @JsonProperty("onThrowAdvice")
    public void setOnThrowAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice) {
      this.onThrowAdvice = onThrowAdvice;
    }
    @JsonProperty("onAfterAdvice")
    public void setOnAfterAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice) {
      this.onAfterAdvice = onAfterAdvice;
    }
    @JsonProperty("isEnabledParameters")
    public void setIsEnabledParameters(ImmutableList<Advice.AdviceParameter> isEnabledParameters) {
      this.isEnabledParameters = isEnabledParameters;
    }
    @JsonProperty("onBeforeParameters")
    public void setOnBeforeParameters(ImmutableList<Advice.AdviceParameter> onBeforeParameters) {
      this.onBeforeParameters = onBeforeParameters;
    }
    @JsonProperty("onReturnParameters")
    public void setOnReturnParameters(ImmutableList<Advice.AdviceParameter> onReturnParameters) {
      this.onReturnParameters = onReturnParameters;
    }
    @JsonProperty("onThrowParameters")
    public void setOnThrowParameters(ImmutableList<Advice.AdviceParameter> onThrowParameters) {
      this.onThrowParameters = onThrowParameters;
    }
    @JsonProperty("onAfterParameters")
    public void setOnAfterParameters(ImmutableList<Advice.AdviceParameter> onAfterParameters) {
      this.onAfterParameters = onAfterParameters;
    }
    @JsonProperty("hasBindThreadContext")
    public void setHasBindThreadContext(boolean hasBindThreadContext) {
      this.hasBindThreadContext = hasBindThreadContext;
      this.hasBindThreadContextIsSet = true;
    }
    @JsonProperty("hasBindOptionalThreadContext")
    public void setHasBindOptionalThreadContext(boolean hasBindOptionalThreadContext) {
      this.hasBindOptionalThreadContext = hasBindOptionalThreadContext;
      this.hasBindOptionalThreadContextIsSet = true;
    }
    @JsonProperty("reweavable")
    public void setReweavable(boolean reweavable) {
      this.reweavable = reweavable;
      this.reweavableIsSet = true;
    }
    @JsonProperty("nonBootstrapLoaderAdvice")
    public void setNonBootstrapLoaderAdvice(org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice) {
      this.nonBootstrapLoaderAdvice = nonBootstrapLoaderAdvice;
    }
    @JsonProperty("nonBootstrapLoaderAdviceClass")
    public void setNonBootstrapLoaderAdviceClass(ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass) {
      this.nonBootstrapLoaderAdviceClass = nonBootstrapLoaderAdviceClass;
    }
    @Override
    Pointcut pointcut() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutClassNamePattern() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutMethodNamePattern() { throw new UnsupportedOperationException(); }
    @Override
    java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern() { throw new UnsupportedOperationException(); }
    @Override
    List<Object> pointcutMethodParameterTypes() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<Advice.AdviceParameter> isEnabledParameters() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<Advice.AdviceParameter> onBeforeParameters() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<Advice.AdviceParameter> onReturnParameters() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<Advice.AdviceParameter> onThrowParameters() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<Advice.AdviceParameter> onAfterParameters() { throw new UnsupportedOperationException(); }
    @Override
    boolean hasBindThreadContext() { throw new UnsupportedOperationException(); }
    @Override
    boolean hasBindOptionalThreadContext() { throw new UnsupportedOperationException(); }
    @Override
    boolean reweavable() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice() { throw new UnsupportedOperationException(); }
    @Override
    ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> classMetaTypes() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    ImmutableSet<org.glowroot.agent.shaded.org.objectweb.asm.Type> methodMetaTypes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAdvice fromJson(Json json) {
    ImmutableAdvice.Builder builder = ImmutableAdvice.builder();
    if (json.pointcut != null) {
      builder.pointcut(json.pointcut);
    }
    if (json.adviceType != null) {
      builder.adviceType(json.adviceType);
    }
    if (json.pointcutClassNamePattern != null) {
      builder.pointcutClassNamePattern(json.pointcutClassNamePattern);
    }
    if (json.pointcutClassAnnotationPattern != null) {
      builder.pointcutClassAnnotationPattern(json.pointcutClassAnnotationPattern);
    }
    if (json.pointcutSubTypeRestrictionPattern != null) {
      builder.pointcutSubTypeRestrictionPattern(json.pointcutSubTypeRestrictionPattern);
    }
    if (json.pointcutSuperTypeRestrictionPattern != null) {
      builder.pointcutSuperTypeRestrictionPattern(json.pointcutSuperTypeRestrictionPattern);
    }
    if (json.pointcutMethodNamePattern != null) {
      builder.pointcutMethodNamePattern(json.pointcutMethodNamePattern);
    }
    if (json.pointcutMethodAnnotationPattern != null) {
      builder.pointcutMethodAnnotationPattern(json.pointcutMethodAnnotationPattern);
    }
    if (json.pointcutMethodParameterTypes != null) {
      builder.addAllPointcutMethodParameterTypes(json.pointcutMethodParameterTypes);
    }
    if (json.travelerType != null) {
      builder.travelerType(json.travelerType);
    }
    if (json.isEnabledAdvice != null) {
      builder.isEnabledAdvice(json.isEnabledAdvice);
    }
    if (json.onBeforeAdvice != null) {
      builder.onBeforeAdvice(json.onBeforeAdvice);
    }
    if (json.onReturnAdvice != null) {
      builder.onReturnAdvice(json.onReturnAdvice);
    }
    if (json.onThrowAdvice != null) {
      builder.onThrowAdvice(json.onThrowAdvice);
    }
    if (json.onAfterAdvice != null) {
      builder.onAfterAdvice(json.onAfterAdvice);
    }
    if (json.isEnabledParameters != null) {
      builder.addAllIsEnabledParameters(json.isEnabledParameters);
    }
    if (json.onBeforeParameters != null) {
      builder.addAllOnBeforeParameters(json.onBeforeParameters);
    }
    if (json.onReturnParameters != null) {
      builder.addAllOnReturnParameters(json.onReturnParameters);
    }
    if (json.onThrowParameters != null) {
      builder.addAllOnThrowParameters(json.onThrowParameters);
    }
    if (json.onAfterParameters != null) {
      builder.addAllOnAfterParameters(json.onAfterParameters);
    }
    if (json.hasBindThreadContextIsSet) {
      builder.hasBindThreadContext(json.hasBindThreadContext);
    }
    if (json.hasBindOptionalThreadContextIsSet) {
      builder.hasBindOptionalThreadContext(json.hasBindOptionalThreadContext);
    }
    if (json.reweavableIsSet) {
      builder.reweavable(json.reweavable);
    }
    if (json.nonBootstrapLoaderAdvice != null) {
      builder.nonBootstrapLoaderAdvice(json.nonBootstrapLoaderAdvice);
    }
    if (json.nonBootstrapLoaderAdviceClass != null) {
      builder.nonBootstrapLoaderAdviceClass(json.nonBootstrapLoaderAdviceClass);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Advice} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Advice instance
   */
  public static ImmutableAdvice copyOf(Advice instance) {
    if (instance instanceof ImmutableAdvice) {
      return (ImmutableAdvice) instance;
    }
    return ImmutableAdvice.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAdvice ImmutableAdvice}.
   * <pre>
   * ImmutableAdvice.builder()
   *    .pointcut(org.glowroot.agent.plugin.api.weaving.Pointcut) // required {@link Advice#pointcut() pointcut}
   *    .adviceType(org.glowroot.agent.shaded.org.objectweb.asm.Type) // required {@link Advice#adviceType() adviceType}
   *    .pointcutClassNamePattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutClassNamePattern() pointcutClassNamePattern}
   *    .pointcutClassAnnotationPattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutClassAnnotationPattern() pointcutClassAnnotationPattern}
   *    .pointcutSubTypeRestrictionPattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutSubTypeRestrictionPattern() pointcutSubTypeRestrictionPattern}
   *    .pointcutSuperTypeRestrictionPattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutSuperTypeRestrictionPattern() pointcutSuperTypeRestrictionPattern}
   *    .pointcutMethodNamePattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutMethodNamePattern() pointcutMethodNamePattern}
   *    .pointcutMethodAnnotationPattern(regex.@org.checkerframework.checker.nullness.qual.Nullable Pattern | null) // nullable {@link Advice#pointcutMethodAnnotationPattern() pointcutMethodAnnotationPattern}
   *    .addPointcutMethodParameterTypes|addAllPointcutMethodParameterTypes(Object) // {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes} elements
   *    .travelerType(org.glowroot.agent.shaded.org.objectweb.asm.@org.checkerframework.checker.nullness.qual.Nullable Type | null) // nullable {@link Advice#travelerType() travelerType}
   *    .isEnabledAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@org.checkerframework.checker.nullness.qual.Nullable Method | null) // nullable {@link Advice#isEnabledAdvice() isEnabledAdvice}
   *    .onBeforeAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@org.checkerframework.checker.nullness.qual.Nullable Method | null) // nullable {@link Advice#onBeforeAdvice() onBeforeAdvice}
   *    .onReturnAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@org.checkerframework.checker.nullness.qual.Nullable Method | null) // nullable {@link Advice#onReturnAdvice() onReturnAdvice}
   *    .onThrowAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@org.checkerframework.checker.nullness.qual.Nullable Method | null) // nullable {@link Advice#onThrowAdvice() onThrowAdvice}
   *    .onAfterAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@org.checkerframework.checker.nullness.qual.Nullable Method | null) // nullable {@link Advice#onAfterAdvice() onAfterAdvice}
   *    .addIsEnabledParameters|addAllIsEnabledParameters(org.glowroot.agent.weaving.Advice.AdviceParameter) // {@link Advice#isEnabledParameters() isEnabledParameters} elements
   *    .addOnBeforeParameters|addAllOnBeforeParameters(org.glowroot.agent.weaving.Advice.AdviceParameter) // {@link Advice#onBeforeParameters() onBeforeParameters} elements
   *    .addOnReturnParameters|addAllOnReturnParameters(org.glowroot.agent.weaving.Advice.AdviceParameter) // {@link Advice#onReturnParameters() onReturnParameters} elements
   *    .addOnThrowParameters|addAllOnThrowParameters(org.glowroot.agent.weaving.Advice.AdviceParameter) // {@link Advice#onThrowParameters() onThrowParameters} elements
   *    .addOnAfterParameters|addAllOnAfterParameters(org.glowroot.agent.weaving.Advice.AdviceParameter) // {@link Advice#onAfterParameters() onAfterParameters} elements
   *    .hasBindThreadContext(boolean) // required {@link Advice#hasBindThreadContext() hasBindThreadContext}
   *    .hasBindOptionalThreadContext(boolean) // required {@link Advice#hasBindOptionalThreadContext() hasBindOptionalThreadContext}
   *    .reweavable(boolean) // required {@link Advice#reweavable() reweavable}
   *    .nonBootstrapLoaderAdvice(org.glowroot.agent.weaving.@org.checkerframework.checker.nullness.qual.Nullable Advice | null) // nullable {@link Advice#nonBootstrapLoaderAdvice() nonBootstrapLoaderAdvice}
   *    .nonBootstrapLoaderAdviceClass(org.glowroot.agent.weaving.ClassLoaders.@org.checkerframework.checker.nullness.qual.Nullable LazyDefinedClass | null) // nullable {@link Advice#nonBootstrapLoaderAdviceClass() nonBootstrapLoaderAdviceClass}
   *    .build();
   * </pre>
   * @return A new ImmutableAdvice builder
   */
  public static ImmutableAdvice.Builder builder() {
    return new ImmutableAdvice.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAdvice ImmutableAdvice}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Advice", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_POINTCUT = 0x1L;
    private static final long INIT_BIT_ADVICE_TYPE = 0x2L;
    private static final long INIT_BIT_HAS_BIND_THREAD_CONTEXT = 0x4L;
    private static final long INIT_BIT_HAS_BIND_OPTIONAL_THREAD_CONTEXT = 0x8L;
    private static final long INIT_BIT_REWEAVABLE = 0x10L;
    private long initBits = 0x1fL;

    private @javax.annotation.Nullable Pointcut pointcut;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutClassNamePattern;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutMethodNamePattern;
    private @javax.annotation.Nullable java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern;
    private ImmutableList.Builder<Object> pointcutMethodParameterTypes = ImmutableList.builder();
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice;
    private @javax.annotation.Nullable org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice;
    private ImmutableList.Builder<Advice.AdviceParameter> isEnabledParameters = ImmutableList.builder();
    private ImmutableList.Builder<Advice.AdviceParameter> onBeforeParameters = ImmutableList.builder();
    private ImmutableList.Builder<Advice.AdviceParameter> onReturnParameters = ImmutableList.builder();
    private ImmutableList.Builder<Advice.AdviceParameter> onThrowParameters = ImmutableList.builder();
    private ImmutableList.Builder<Advice.AdviceParameter> onAfterParameters = ImmutableList.builder();
    private boolean hasBindThreadContext;
    private boolean hasBindOptionalThreadContext;
    private boolean reweavable;
    private @javax.annotation.Nullable org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice;
    private @javax.annotation.Nullable ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Advice} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(Advice instance) {
      Objects.requireNonNull(instance, "instance");
      pointcut(instance.pointcut());
      adviceType(instance.adviceType());
      java.util.regex.@Nullable Pattern pointcutClassNamePatternValue = instance.pointcutClassNamePattern();
      if (pointcutClassNamePatternValue != null) {
        pointcutClassNamePattern(pointcutClassNamePatternValue);
      }
      java.util.regex.@Nullable Pattern pointcutClassAnnotationPatternValue = instance.pointcutClassAnnotationPattern();
      if (pointcutClassAnnotationPatternValue != null) {
        pointcutClassAnnotationPattern(pointcutClassAnnotationPatternValue);
      }
      java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPatternValue = instance.pointcutSubTypeRestrictionPattern();
      if (pointcutSubTypeRestrictionPatternValue != null) {
        pointcutSubTypeRestrictionPattern(pointcutSubTypeRestrictionPatternValue);
      }
      java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPatternValue = instance.pointcutSuperTypeRestrictionPattern();
      if (pointcutSuperTypeRestrictionPatternValue != null) {
        pointcutSuperTypeRestrictionPattern(pointcutSuperTypeRestrictionPatternValue);
      }
      java.util.regex.@Nullable Pattern pointcutMethodNamePatternValue = instance.pointcutMethodNamePattern();
      if (pointcutMethodNamePatternValue != null) {
        pointcutMethodNamePattern(pointcutMethodNamePatternValue);
      }
      java.util.regex.@Nullable Pattern pointcutMethodAnnotationPatternValue = instance.pointcutMethodAnnotationPattern();
      if (pointcutMethodAnnotationPatternValue != null) {
        pointcutMethodAnnotationPattern(pointcutMethodAnnotationPatternValue);
      }
      addAllPointcutMethodParameterTypes(instance.pointcutMethodParameterTypes());
      org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerTypeValue = instance.travelerType();
      if (travelerTypeValue != null) {
        travelerType(travelerTypeValue);
      }
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdviceValue = instance.isEnabledAdvice();
      if (isEnabledAdviceValue != null) {
        isEnabledAdvice(isEnabledAdviceValue);
      }
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdviceValue = instance.onBeforeAdvice();
      if (onBeforeAdviceValue != null) {
        onBeforeAdvice(onBeforeAdviceValue);
      }
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdviceValue = instance.onReturnAdvice();
      if (onReturnAdviceValue != null) {
        onReturnAdvice(onReturnAdviceValue);
      }
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdviceValue = instance.onThrowAdvice();
      if (onThrowAdviceValue != null) {
        onThrowAdvice(onThrowAdviceValue);
      }
      org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdviceValue = instance.onAfterAdvice();
      if (onAfterAdviceValue != null) {
        onAfterAdvice(onAfterAdviceValue);
      }
      addAllIsEnabledParameters(instance.isEnabledParameters());
      addAllOnBeforeParameters(instance.onBeforeParameters());
      addAllOnReturnParameters(instance.onReturnParameters());
      addAllOnThrowParameters(instance.onThrowParameters());
      addAllOnAfterParameters(instance.onAfterParameters());
      hasBindThreadContext(instance.hasBindThreadContext());
      hasBindOptionalThreadContext(instance.hasBindOptionalThreadContext());
      reweavable(instance.reweavable());
      org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdviceValue = instance.nonBootstrapLoaderAdvice();
      if (nonBootstrapLoaderAdviceValue != null) {
        nonBootstrapLoaderAdvice(nonBootstrapLoaderAdviceValue);
      }
      ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClassValue = instance.nonBootstrapLoaderAdviceClass();
      if (nonBootstrapLoaderAdviceClassValue != null) {
        nonBootstrapLoaderAdviceClass(nonBootstrapLoaderAdviceClassValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcut() pointcut} attribute.
     * @param pointcut The value for pointcut 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcut(Pointcut pointcut) {
      this.pointcut = Objects.requireNonNull(pointcut, "pointcut");
      initBits &= ~INIT_BIT_POINTCUT;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#adviceType() adviceType} attribute.
     * @param adviceType The value for adviceType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder adviceType(org.glowroot.agent.shaded.org.objectweb.asm.Type adviceType) {
      this.adviceType = Objects.requireNonNull(adviceType, "adviceType");
      initBits &= ~INIT_BIT_ADVICE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutClassNamePattern() pointcutClassNamePattern} attribute.
     * @param pointcutClassNamePattern The value for pointcutClassNamePattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutClassNamePattern(java.util.regex.@Nullable Pattern pointcutClassNamePattern) {
      this.pointcutClassNamePattern = pointcutClassNamePattern;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutClassAnnotationPattern() pointcutClassAnnotationPattern} attribute.
     * @param pointcutClassAnnotationPattern The value for pointcutClassAnnotationPattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutClassAnnotationPattern(java.util.regex.@Nullable Pattern pointcutClassAnnotationPattern) {
      this.pointcutClassAnnotationPattern = pointcutClassAnnotationPattern;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutSubTypeRestrictionPattern() pointcutSubTypeRestrictionPattern} attribute.
     * @param pointcutSubTypeRestrictionPattern The value for pointcutSubTypeRestrictionPattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutSubTypeRestrictionPattern(java.util.regex.@Nullable Pattern pointcutSubTypeRestrictionPattern) {
      this.pointcutSubTypeRestrictionPattern = pointcutSubTypeRestrictionPattern;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutSuperTypeRestrictionPattern() pointcutSuperTypeRestrictionPattern} attribute.
     * @param pointcutSuperTypeRestrictionPattern The value for pointcutSuperTypeRestrictionPattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutSuperTypeRestrictionPattern(java.util.regex.@Nullable Pattern pointcutSuperTypeRestrictionPattern) {
      this.pointcutSuperTypeRestrictionPattern = pointcutSuperTypeRestrictionPattern;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutMethodNamePattern() pointcutMethodNamePattern} attribute.
     * @param pointcutMethodNamePattern The value for pointcutMethodNamePattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutMethodNamePattern(java.util.regex.@Nullable Pattern pointcutMethodNamePattern) {
      this.pointcutMethodNamePattern = pointcutMethodNamePattern;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#pointcutMethodAnnotationPattern() pointcutMethodAnnotationPattern} attribute.
     * @param pointcutMethodAnnotationPattern The value for pointcutMethodAnnotationPattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutMethodAnnotationPattern(java.util.regex.@Nullable Pattern pointcutMethodAnnotationPattern) {
      this.pointcutMethodAnnotationPattern = pointcutMethodAnnotationPattern;
      return this;
    }

    /**
     * Adds one element to {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes} list.
     * @param element A pointcutMethodParameterTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPointcutMethodParameterTypes(Object element) {
      this.pointcutMethodParameterTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes} list.
     * @param elements An array of pointcutMethodParameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPointcutMethodParameterTypes(Object... elements) {
      this.pointcutMethodParameterTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes} list.
     * @param elements An iterable of pointcutMethodParameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcutMethodParameterTypes(Iterable<? extends Object> elements) {
      this.pointcutMethodParameterTypes = ImmutableList.builder();
      return addAllPointcutMethodParameterTypes(elements);
    }

    /**
     * Adds elements to {@link Advice#pointcutMethodParameterTypes() pointcutMethodParameterTypes} list.
     * @param elements An iterable of pointcutMethodParameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPointcutMethodParameterTypes(Iterable<? extends Object> elements) {
      this.pointcutMethodParameterTypes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#travelerType() travelerType} attribute.
     * @param travelerType The value for travelerType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder travelerType(org.glowroot.agent.shaded.org.objectweb.asm.@Nullable Type travelerType) {
      this.travelerType = travelerType;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#isEnabledAdvice() isEnabledAdvice} attribute.
     * @param isEnabledAdvice The value for isEnabledAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isEnabledAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method isEnabledAdvice) {
      this.isEnabledAdvice = isEnabledAdvice;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#onBeforeAdvice() onBeforeAdvice} attribute.
     * @param onBeforeAdvice The value for onBeforeAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onBeforeAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onBeforeAdvice) {
      this.onBeforeAdvice = onBeforeAdvice;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#onReturnAdvice() onReturnAdvice} attribute.
     * @param onReturnAdvice The value for onReturnAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onReturnAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onReturnAdvice) {
      this.onReturnAdvice = onReturnAdvice;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#onThrowAdvice() onThrowAdvice} attribute.
     * @param onThrowAdvice The value for onThrowAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onThrowAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onThrowAdvice) {
      this.onThrowAdvice = onThrowAdvice;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#onAfterAdvice() onAfterAdvice} attribute.
     * @param onAfterAdvice The value for onAfterAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onAfterAdvice(org.glowroot.agent.shaded.org.objectweb.asm.commons.@Nullable Method onAfterAdvice) {
      this.onAfterAdvice = onAfterAdvice;
      return this;
    }

    /**
     * Adds one element to {@link Advice#isEnabledParameters() isEnabledParameters} list.
     * @param element A isEnabledParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIsEnabledParameters(Advice.AdviceParameter element) {
      this.isEnabledParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#isEnabledParameters() isEnabledParameters} list.
     * @param elements An array of isEnabledParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addIsEnabledParameters(Advice.AdviceParameter... elements) {
      this.isEnabledParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#isEnabledParameters() isEnabledParameters} list.
     * @param elements An iterable of isEnabledParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isEnabledParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.isEnabledParameters = ImmutableList.builder();
      return addAllIsEnabledParameters(elements);
    }

    /**
     * Adds elements to {@link Advice#isEnabledParameters() isEnabledParameters} list.
     * @param elements An iterable of isEnabledParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllIsEnabledParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.isEnabledParameters.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Advice#onBeforeParameters() onBeforeParameters} list.
     * @param element A onBeforeParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnBeforeParameters(Advice.AdviceParameter element) {
      this.onBeforeParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#onBeforeParameters() onBeforeParameters} list.
     * @param elements An array of onBeforeParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnBeforeParameters(Advice.AdviceParameter... elements) {
      this.onBeforeParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#onBeforeParameters() onBeforeParameters} list.
     * @param elements An iterable of onBeforeParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onBeforeParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onBeforeParameters = ImmutableList.builder();
      return addAllOnBeforeParameters(elements);
    }

    /**
     * Adds elements to {@link Advice#onBeforeParameters() onBeforeParameters} list.
     * @param elements An iterable of onBeforeParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOnBeforeParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onBeforeParameters.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Advice#onReturnParameters() onReturnParameters} list.
     * @param element A onReturnParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnReturnParameters(Advice.AdviceParameter element) {
      this.onReturnParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#onReturnParameters() onReturnParameters} list.
     * @param elements An array of onReturnParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnReturnParameters(Advice.AdviceParameter... elements) {
      this.onReturnParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#onReturnParameters() onReturnParameters} list.
     * @param elements An iterable of onReturnParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onReturnParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onReturnParameters = ImmutableList.builder();
      return addAllOnReturnParameters(elements);
    }

    /**
     * Adds elements to {@link Advice#onReturnParameters() onReturnParameters} list.
     * @param elements An iterable of onReturnParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOnReturnParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onReturnParameters.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Advice#onThrowParameters() onThrowParameters} list.
     * @param element A onThrowParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnThrowParameters(Advice.AdviceParameter element) {
      this.onThrowParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#onThrowParameters() onThrowParameters} list.
     * @param elements An array of onThrowParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnThrowParameters(Advice.AdviceParameter... elements) {
      this.onThrowParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#onThrowParameters() onThrowParameters} list.
     * @param elements An iterable of onThrowParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onThrowParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onThrowParameters = ImmutableList.builder();
      return addAllOnThrowParameters(elements);
    }

    /**
     * Adds elements to {@link Advice#onThrowParameters() onThrowParameters} list.
     * @param elements An iterable of onThrowParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOnThrowParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onThrowParameters.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Advice#onAfterParameters() onAfterParameters} list.
     * @param element A onAfterParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnAfterParameters(Advice.AdviceParameter element) {
      this.onAfterParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Advice#onAfterParameters() onAfterParameters} list.
     * @param elements An array of onAfterParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOnAfterParameters(Advice.AdviceParameter... elements) {
      this.onAfterParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Advice#onAfterParameters() onAfterParameters} list.
     * @param elements An iterable of onAfterParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder onAfterParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onAfterParameters = ImmutableList.builder();
      return addAllOnAfterParameters(elements);
    }

    /**
     * Adds elements to {@link Advice#onAfterParameters() onAfterParameters} list.
     * @param elements An iterable of onAfterParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOnAfterParameters(Iterable<? extends Advice.AdviceParameter> elements) {
      this.onAfterParameters.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#hasBindThreadContext() hasBindThreadContext} attribute.
     * @param hasBindThreadContext The value for hasBindThreadContext 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasBindThreadContext(boolean hasBindThreadContext) {
      this.hasBindThreadContext = hasBindThreadContext;
      initBits &= ~INIT_BIT_HAS_BIND_THREAD_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#hasBindOptionalThreadContext() hasBindOptionalThreadContext} attribute.
     * @param hasBindOptionalThreadContext The value for hasBindOptionalThreadContext 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hasBindOptionalThreadContext(boolean hasBindOptionalThreadContext) {
      this.hasBindOptionalThreadContext = hasBindOptionalThreadContext;
      initBits &= ~INIT_BIT_HAS_BIND_OPTIONAL_THREAD_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#reweavable() reweavable} attribute.
     * @param reweavable The value for reweavable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reweavable(boolean reweavable) {
      this.reweavable = reweavable;
      initBits &= ~INIT_BIT_REWEAVABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#nonBootstrapLoaderAdvice() nonBootstrapLoaderAdvice} attribute.
     * @param nonBootstrapLoaderAdvice The value for nonBootstrapLoaderAdvice (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonBootstrapLoaderAdvice(org.glowroot.agent.weaving.@Nullable Advice nonBootstrapLoaderAdvice) {
      this.nonBootstrapLoaderAdvice = nonBootstrapLoaderAdvice;
      return this;
    }

    /**
     * Initializes the value for the {@link Advice#nonBootstrapLoaderAdviceClass() nonBootstrapLoaderAdviceClass} attribute.
     * @param nonBootstrapLoaderAdviceClass The value for nonBootstrapLoaderAdviceClass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonBootstrapLoaderAdviceClass(ClassLoaders.@Nullable LazyDefinedClass nonBootstrapLoaderAdviceClass) {
      this.nonBootstrapLoaderAdviceClass = nonBootstrapLoaderAdviceClass;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAdvice ImmutableAdvice}.
     * @return An immutable instance of Advice
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAdvice build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAdvice(
          pointcut,
          adviceType,
          pointcutClassNamePattern,
          pointcutClassAnnotationPattern,
          pointcutSubTypeRestrictionPattern,
          pointcutSuperTypeRestrictionPattern,
          pointcutMethodNamePattern,
          pointcutMethodAnnotationPattern,
          pointcutMethodParameterTypes.build(),
          travelerType,
          isEnabledAdvice,
          onBeforeAdvice,
          onReturnAdvice,
          onThrowAdvice,
          onAfterAdvice,
          isEnabledParameters.build(),
          onBeforeParameters.build(),
          onReturnParameters.build(),
          onThrowParameters.build(),
          onAfterParameters.build(),
          hasBindThreadContext,
          hasBindOptionalThreadContext,
          reweavable,
          nonBootstrapLoaderAdvice,
          nonBootstrapLoaderAdviceClass);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_POINTCUT) != 0) attributes.add("pointcut");
      if ((initBits & INIT_BIT_ADVICE_TYPE) != 0) attributes.add("adviceType");
      if ((initBits & INIT_BIT_HAS_BIND_THREAD_CONTEXT) != 0) attributes.add("hasBindThreadContext");
      if ((initBits & INIT_BIT_HAS_BIND_OPTIONAL_THREAD_CONTEXT) != 0) attributes.add("hasBindOptionalThreadContext");
      if ((initBits & INIT_BIT_REWEAVABLE) != 0) attributes.add("reweavable");
      return "Cannot build Advice, some of required attributes are not set " + attributes;
    }
  }
}
