package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClassAnalyzer.AnalyzedMethodKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnalyzedMethodKey.builder()}.
 */
@Generated(from = "ClassAnalyzer.AnalyzedMethodKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAnalyzedMethodKey
    extends ClassAnalyzer.AnalyzedMethodKey {
  private final String name;
  private final ImmutableList<String> parameterTypes;
  private final org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod;

  private ImmutableAnalyzedMethodKey(
      String name,
      ImmutableList<String> parameterTypes,
      org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod) {
    this.name = name;
    this.parameterTypes = parameterTypes;
    this.analyzedMethod = analyzedMethod;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  String name() {
    return name;
  }

  /**
   * @return The value of the {@code parameterTypes} attribute
   */
  @JsonProperty("parameterTypes")
  @Override
  ImmutableList<String> parameterTypes() {
    return parameterTypes;
  }

  /**
   * @return The value of the {@code analyzedMethod} attribute
   */
  @JsonProperty("analyzedMethod")
  @Override
  org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod() {
    return analyzedMethod;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassAnalyzer.AnalyzedMethodKey#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedMethodKey withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableAnalyzedMethodKey(newValue, this.parameterTypes, this.analyzedMethod);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedMethodKey withParameterTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameterTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnalyzedMethodKey withParameterTypes(Iterable<String> elements) {
    if (this.parameterTypes == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableAnalyzedMethodKey(this.name, newValue, this.analyzedMethod);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassAnalyzer.AnalyzedMethodKey#analyzedMethod() analyzedMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for analyzedMethod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnalyzedMethodKey withAnalyzedMethod(org.glowroot.agent.weaving.@Nullable AnalyzedMethod value) {
    if (this.analyzedMethod == value) return this;
    return new ImmutableAnalyzedMethodKey(this.name, this.parameterTypes, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnalyzedMethodKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnalyzedMethodKey
        && equalTo((ImmutableAnalyzedMethodKey) another);
  }

  private boolean equalTo(ImmutableAnalyzedMethodKey another) {
    return name.equals(another.name)
        && parameterTypes.equals(another.parameterTypes);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code parameterTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + parameterTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AnalyzedMethodKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AnalyzedMethodKey")
        .omitNullValues()
        .add("name", name)
        .add("parameterTypes", parameterTypes)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ClassAnalyzer.AnalyzedMethodKey", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ClassAnalyzer.AnalyzedMethodKey {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable ImmutableList<String> parameterTypes = ImmutableList.of();
    @javax.annotation.Nullable org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("parameterTypes")
    public void setParameterTypes(ImmutableList<String> parameterTypes) {
      this.parameterTypes = parameterTypes;
    }
    @JsonProperty("analyzedMethod")
    public void setAnalyzedMethod(org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod) {
      this.analyzedMethod = analyzedMethod;
    }
    @Override
    String name() { throw new UnsupportedOperationException(); }
    @Override
    ImmutableList<String> parameterTypes() { throw new UnsupportedOperationException(); }
    @Override
    org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnalyzedMethodKey fromJson(Json json) {
    ImmutableAnalyzedMethodKey.Builder builder = ImmutableAnalyzedMethodKey.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.parameterTypes != null) {
      builder.addAllParameterTypes(json.parameterTypes);
    }
    if (json.analyzedMethod != null) {
      builder.analyzedMethod(json.analyzedMethod);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ClassAnalyzer.AnalyzedMethodKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AnalyzedMethodKey instance
   */
  public static ImmutableAnalyzedMethodKey copyOf(ClassAnalyzer.AnalyzedMethodKey instance) {
    if (instance instanceof ImmutableAnalyzedMethodKey) {
      return (ImmutableAnalyzedMethodKey) instance;
    }
    return ImmutableAnalyzedMethodKey.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnalyzedMethodKey ImmutableAnalyzedMethodKey}.
   * <pre>
   * ImmutableAnalyzedMethodKey.builder()
   *    .name(String) // required {@link ClassAnalyzer.AnalyzedMethodKey#name() name}
   *    .addParameterTypes|addAllParameterTypes(String) // {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes} elements
   *    .analyzedMethod(org.glowroot.agent.weaving.@org.checkerframework.checker.nullness.qual.Nullable AnalyzedMethod | null) // nullable {@link ClassAnalyzer.AnalyzedMethodKey#analyzedMethod() analyzedMethod}
   *    .build();
   * </pre>
   * @return A new ImmutableAnalyzedMethodKey builder
   */
  public static ImmutableAnalyzedMethodKey.Builder builder() {
    return new ImmutableAnalyzedMethodKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnalyzedMethodKey ImmutableAnalyzedMethodKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassAnalyzer.AnalyzedMethodKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String name;
    private ImmutableList.Builder<String> parameterTypes = ImmutableList.builder();
    private @javax.annotation.Nullable org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AnalyzedMethodKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(ClassAnalyzer.AnalyzedMethodKey instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      addAllParameterTypes(instance.parameterTypes());
      org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethodValue = instance.analyzedMethod();
      if (analyzedMethodValue != null) {
        analyzedMethod(analyzedMethodValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ClassAnalyzer.AnalyzedMethodKey#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes} list.
     * @param element A parameterTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameterTypes(String element) {
      this.parameterTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes} list.
     * @param elements An array of parameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addParameterTypes(String... elements) {
      this.parameterTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes} list.
     * @param elements An iterable of parameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parameterTypes(Iterable<String> elements) {
      this.parameterTypes = ImmutableList.builder();
      return addAllParameterTypes(elements);
    }

    /**
     * Adds elements to {@link ClassAnalyzer.AnalyzedMethodKey#parameterTypes() parameterTypes} list.
     * @param elements An iterable of parameterTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllParameterTypes(Iterable<String> elements) {
      this.parameterTypes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ClassAnalyzer.AnalyzedMethodKey#analyzedMethod() analyzedMethod} attribute.
     * @param analyzedMethod The value for analyzedMethod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder analyzedMethod(org.glowroot.agent.weaving.@Nullable AnalyzedMethod analyzedMethod) {
      this.analyzedMethod = analyzedMethod;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnalyzedMethodKey ImmutableAnalyzedMethodKey}.
     * @return An immutable instance of AnalyzedMethodKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnalyzedMethodKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAnalyzedMethodKey(name, parameterTypes.build(), analyzedMethod);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build AnalyzedMethodKey, some of required attributes are not set " + attributes;
    }
  }
}
