package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClassAnalyzer.MatchedShimTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMatchedShimTypes.builder()}.
 */
@Generated(from = "ClassAnalyzer.MatchedShimTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableMatchedShimTypes
    implements ClassAnalyzer.MatchedShimTypes {
  private final ImmutableList<ShimType> reweavable;
  private final ImmutableList<ShimType> nonReweavable;

  private ImmutableMatchedShimTypes(
      ImmutableList<ShimType> reweavable,
      ImmutableList<ShimType> nonReweavable) {
    this.reweavable = reweavable;
    this.nonReweavable = nonReweavable;
  }

  /**
   * @return The value of the {@code reweavable} attribute
   */
  @JsonProperty("reweavable")
  @Override
  public ImmutableList<ShimType> reweavable() {
    return reweavable;
  }

  /**
   * @return The value of the {@code nonReweavable} attribute
   */
  @JsonProperty("nonReweavable")
  @Override
  public ImmutableList<ShimType> nonReweavable() {
    return nonReweavable;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedShimTypes withReweavable(ShimType... elements) {
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedShimTypes(newValue, this.nonReweavable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of reweavable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedShimTypes withReweavable(Iterable<? extends ShimType> elements) {
    if (this.reweavable == elements) return this;
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedShimTypes(newValue, this.nonReweavable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedShimTypes withNonReweavable(ShimType... elements) {
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedShimTypes(this.reweavable, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nonReweavable elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedShimTypes withNonReweavable(Iterable<? extends ShimType> elements) {
    if (this.nonReweavable == elements) return this;
    ImmutableList<ShimType> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMatchedShimTypes(this.reweavable, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMatchedShimTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMatchedShimTypes
        && equalTo((ImmutableMatchedShimTypes) another);
  }

  private boolean equalTo(ImmutableMatchedShimTypes another) {
    return reweavable.equals(another.reweavable)
        && nonReweavable.equals(another.nonReweavable);
  }

  /**
   * Computes a hash code from attributes: {@code reweavable}, {@code nonReweavable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reweavable.hashCode();
    h += (h << 5) + nonReweavable.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MatchedShimTypes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MatchedShimTypes")
        .omitNullValues()
        .add("reweavable", reweavable)
        .add("nonReweavable", nonReweavable)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ClassAnalyzer.MatchedShimTypes", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ClassAnalyzer.MatchedShimTypes {
    @Nullable List<ShimType> reweavable = ImmutableList.of();
    @Nullable List<ShimType> nonReweavable = ImmutableList.of();
    @JsonProperty("reweavable")
    public void setReweavable(List<ShimType> reweavable) {
      this.reweavable = reweavable;
    }
    @JsonProperty("nonReweavable")
    public void setNonReweavable(List<ShimType> nonReweavable) {
      this.nonReweavable = nonReweavable;
    }
    @Override
    public List<ShimType> reweavable() { throw new UnsupportedOperationException(); }
    @Override
    public List<ShimType> nonReweavable() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMatchedShimTypes fromJson(Json json) {
    ImmutableMatchedShimTypes.Builder builder = ImmutableMatchedShimTypes.builder();
    if (json.reweavable != null) {
      builder.addAllReweavable(json.reweavable);
    }
    if (json.nonReweavable != null) {
      builder.addAllNonReweavable(json.nonReweavable);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ClassAnalyzer.MatchedShimTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MatchedShimTypes instance
   */
  public static ImmutableMatchedShimTypes copyOf(ClassAnalyzer.MatchedShimTypes instance) {
    if (instance instanceof ImmutableMatchedShimTypes) {
      return (ImmutableMatchedShimTypes) instance;
    }
    return ImmutableMatchedShimTypes.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMatchedShimTypes ImmutableMatchedShimTypes}.
   * <pre>
   * ImmutableMatchedShimTypes.builder()
   *    .addReweavable|addAllReweavable(org.glowroot.agent.weaving.ShimType) // {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable} elements
   *    .addNonReweavable|addAllNonReweavable(org.glowroot.agent.weaving.ShimType) // {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMatchedShimTypes builder
   */
  public static ImmutableMatchedShimTypes.Builder builder() {
    return new ImmutableMatchedShimTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMatchedShimTypes ImmutableMatchedShimTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassAnalyzer.MatchedShimTypes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<ShimType> reweavable = ImmutableList.builder();
    private ImmutableList.Builder<ShimType> nonReweavable = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MatchedShimTypes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(ClassAnalyzer.MatchedShimTypes instance) {
      Objects.requireNonNull(instance, "instance");
      addAllReweavable(instance.reweavable());
      addAllNonReweavable(instance.nonReweavable());
      return this;
    }

    /**
     * Adds one element to {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable} list.
     * @param element A reweavable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReweavable(ShimType element) {
      this.reweavable.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable} list.
     * @param elements An array of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addReweavable(ShimType... elements) {
      this.reweavable.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable} list.
     * @param elements An iterable of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reweavable(Iterable<? extends ShimType> elements) {
      this.reweavable = ImmutableList.builder();
      return addAllReweavable(elements);
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedShimTypes#reweavable() reweavable} list.
     * @param elements An iterable of reweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllReweavable(Iterable<? extends ShimType> elements) {
      this.reweavable.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable} list.
     * @param element A nonReweavable element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavable(ShimType element) {
      this.nonReweavable.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable} list.
     * @param elements An array of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNonReweavable(ShimType... elements) {
      this.nonReweavable.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable} list.
     * @param elements An iterable of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nonReweavable(Iterable<? extends ShimType> elements) {
      this.nonReweavable = ImmutableList.builder();
      return addAllNonReweavable(elements);
    }

    /**
     * Adds elements to {@link ClassAnalyzer.MatchedShimTypes#nonReweavable() nonReweavable} list.
     * @param elements An iterable of nonReweavable elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNonReweavable(Iterable<? extends ShimType> elements) {
      this.nonReweavable.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMatchedShimTypes ImmutableMatchedShimTypes}.
     * @return An immutable instance of MatchedShimTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMatchedShimTypes build() {
      return new ImmutableMatchedShimTypes(reweavable.build(), nonReweavable.build());
    }
  }
}
