package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.immutables.value.Generated;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;

/**
 * Immutable implementation of {@link PluginDetail.MixinClass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMixinClass.builder()}.
 */
@Generated(from = "PluginDetail.MixinClass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMixinClass extends PluginDetail.MixinClass {
  private final Type type;
  private final ImmutableList<Type> interfaces;
  private final Mixin mixin;
  private final @Nullable String initMethodName;
  private final byte[] bytes;

  private ImmutableMixinClass(
      Type type,
      ImmutableList<Type> interfaces,
      Mixin mixin,
      @Nullable String initMethodName,
      byte[] bytes) {
    this.type = type;
    this.interfaces = interfaces;
    this.mixin = mixin;
    this.initMethodName = initMethodName;
    this.bytes = bytes;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  Type type() {
    return type;
  }

  /**
   * @return The value of the {@code interfaces} attribute
   */
  @JsonProperty("interfaces")
  @Override
  ImmutableList<Type> interfaces() {
    return interfaces;
  }

  /**
   * @return The value of the {@code mixin} attribute
   */
  @JsonProperty("mixin")
  @Override
  Mixin mixin() {
    return mixin;
  }

  /**
   * @return The value of the {@code initMethodName} attribute
   */
  @JsonProperty("initMethodName")
  @Override
  @Nullable String initMethodName() {
    return initMethodName;
  }

  /**
   * @return A cloned {@code bytes} array
   */
  @JsonProperty("bytes")
  @Override
  byte[] bytes() {
    return bytes.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.MixinClass#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMixinClass withType(Type value) {
    if (this.type == value) return this;
    Type newValue = Objects.requireNonNull(value, "type");
    return new ImmutableMixinClass(newValue, this.interfaces, this.mixin, this.initMethodName, this.bytes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.MixinClass#interfaces() interfaces}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMixinClass withInterfaces(Type... elements) {
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMixinClass(this.type, newValue, this.mixin, this.initMethodName, this.bytes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.MixinClass#interfaces() interfaces}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of interfaces elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMixinClass withInterfaces(Iterable<? extends Type> elements) {
    if (this.interfaces == elements) return this;
    ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMixinClass(this.type, newValue, this.mixin, this.initMethodName, this.bytes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.MixinClass#mixin() mixin} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mixin
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMixinClass withMixin(Mixin value) {
    if (this.mixin == value) return this;
    Mixin newValue = Objects.requireNonNull(value, "mixin");
    return new ImmutableMixinClass(this.type, this.interfaces, newValue, this.initMethodName, this.bytes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.MixinClass#initMethodName() initMethodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for initMethodName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMixinClass withInitMethodName(@Nullable String value) {
    if (Objects.equals(this.initMethodName, value)) return this;
    return new ImmutableMixinClass(this.type, this.interfaces, this.mixin, value, this.bytes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.MixinClass#bytes() bytes}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for bytes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMixinClass withBytes(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableMixinClass(this.type, this.interfaces, this.mixin, this.initMethodName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMixinClass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMixinClass
        && equalTo((ImmutableMixinClass) another);
  }

  private boolean equalTo(ImmutableMixinClass another) {
    return type.equals(another.type)
        && interfaces.equals(another.interfaces)
        && mixin.equals(another.mixin)
        && Objects.equals(initMethodName, another.initMethodName)
        && Arrays.equals(bytes, another.bytes);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code interfaces}, {@code mixin}, {@code initMethodName}, {@code bytes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + interfaces.hashCode();
    h += (h << 5) + mixin.hashCode();
    h += (h << 5) + Objects.hashCode(initMethodName);
    h += (h << 5) + Arrays.hashCode(bytes);
    return h;
  }

  /**
   * Prints the immutable value {@code MixinClass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MixinClass")
        .omitNullValues()
        .add("type", type)
        .add("interfaces", interfaces)
        .add("mixin", mixin)
        .add("initMethodName", initMethodName)
        .add("bytes", Arrays.toString(bytes))
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDetail.MixinClass", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PluginDetail.MixinClass {
    @Nullable Type type;
    @Nullable List<Type> interfaces = ImmutableList.of();
    @Nullable Mixin mixin;
    @Nullable String initMethodName;
    @Nullable byte[] bytes;
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @JsonProperty("interfaces")
    public void setInterfaces(List<Type> interfaces) {
      this.interfaces = interfaces;
    }
    @JsonProperty("mixin")
    public void setMixin(Mixin mixin) {
      this.mixin = mixin;
    }
    @JsonProperty("initMethodName")
    public void setInitMethodName(@Nullable String initMethodName) {
      this.initMethodName = initMethodName;
    }
    @JsonProperty("bytes")
    public void setBytes(byte[] bytes) {
      this.bytes = bytes;
    }
    @Override
    Type type() { throw new UnsupportedOperationException(); }
    @Override
    List<Type> interfaces() { throw new UnsupportedOperationException(); }
    @Override
    Mixin mixin() { throw new UnsupportedOperationException(); }
    @Override
    String initMethodName() { throw new UnsupportedOperationException(); }
    @Override
    byte[] bytes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMixinClass fromJson(Json json) {
    ImmutableMixinClass.Builder builder = ImmutableMixinClass.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.interfaces != null) {
      builder.addAllInterfaces(json.interfaces);
    }
    if (json.mixin != null) {
      builder.mixin(json.mixin);
    }
    if (json.initMethodName != null) {
      builder.initMethodName(json.initMethodName);
    }
    if (json.bytes != null) {
      builder.bytes(json.bytes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDetail.MixinClass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MixinClass instance
   */
  public static ImmutableMixinClass copyOf(PluginDetail.MixinClass instance) {
    if (instance instanceof ImmutableMixinClass) {
      return (ImmutableMixinClass) instance;
    }
    return ImmutableMixinClass.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMixinClass ImmutableMixinClass}.
   * <pre>
   * ImmutableMixinClass.builder()
   *    .type(org.glowroot.agent.shaded.org.objectweb.asm.Type) // required {@link PluginDetail.MixinClass#type() type}
   *    .addInterfaces|addAllInterfaces(org.glowroot.agent.shaded.org.objectweb.asm.Type) // {@link PluginDetail.MixinClass#interfaces() interfaces} elements
   *    .mixin(org.glowroot.agent.plugin.api.weaving.Mixin) // required {@link PluginDetail.MixinClass#mixin() mixin}
   *    .initMethodName(String | null) // nullable {@link PluginDetail.MixinClass#initMethodName() initMethodName}
   *    .bytes(byte) // required {@link PluginDetail.MixinClass#bytes() bytes}
   *    .build();
   * </pre>
   * @return A new ImmutableMixinClass builder
   */
  public static ImmutableMixinClass.Builder builder() {
    return new ImmutableMixinClass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMixinClass ImmutableMixinClass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDetail.MixinClass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_MIXIN = 0x2L;
    private static final long INIT_BIT_BYTES = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Type type;
    private ImmutableList.Builder<Type> interfaces = ImmutableList.builder();
    private @Nullable Mixin mixin;
    private @Nullable String initMethodName;
    private @Nullable byte[] bytes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MixinClass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDetail.MixinClass instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      addAllInterfaces(instance.interfaces());
      mixin(instance.mixin());
      @Nullable String initMethodNameValue = instance.initMethodName();
      if (initMethodNameValue != null) {
        initMethodName(initMethodNameValue);
      }
      bytes(instance.bytes());
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.MixinClass#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail.MixinClass#interfaces() interfaces} list.
     * @param element A interfaces element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInterfaces(Type element) {
      this.interfaces.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail.MixinClass#interfaces() interfaces} list.
     * @param elements An array of interfaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInterfaces(Type... elements) {
      this.interfaces.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail.MixinClass#interfaces() interfaces} list.
     * @param elements An iterable of interfaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder interfaces(Iterable<? extends Type> elements) {
      this.interfaces = ImmutableList.builder();
      return addAllInterfaces(elements);
    }

    /**
     * Adds elements to {@link PluginDetail.MixinClass#interfaces() interfaces} list.
     * @param elements An iterable of interfaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInterfaces(Iterable<? extends Type> elements) {
      this.interfaces.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.MixinClass#mixin() mixin} attribute.
     * @param mixin The value for mixin 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mixin(Mixin mixin) {
      this.mixin = Objects.requireNonNull(mixin, "mixin");
      initBits &= ~INIT_BIT_MIXIN;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.MixinClass#initMethodName() initMethodName} attribute.
     * @param initMethodName The value for initMethodName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder initMethodName(@Nullable String initMethodName) {
      this.initMethodName = initMethodName;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.MixinClass#bytes() bytes} attribute.
     * @param bytes The elements for bytes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bytes(byte... bytes) {
      this.bytes = bytes.clone();
      initBits &= ~INIT_BIT_BYTES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMixinClass ImmutableMixinClass}.
     * @return An immutable instance of MixinClass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMixinClass build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMixinClass(type, interfaces.build(), mixin, initMethodName, bytes);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_MIXIN) != 0) attributes.add("mixin");
      if ((initBits & INIT_BIT_BYTES) != 0) attributes.add("bytes");
      return "Cannot build MixinClass, some of required attributes are not set " + attributes;
    }
  }
}
