package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.immutables.value.Generated;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;

/**
 * Immutable implementation of {@link PluginDetail.PointcutClass}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePointcutClass.builder()}.
 */
@Generated(from = "PluginDetail.PointcutClass", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePointcutClass extends PluginDetail.PointcutClass {
  private final Type type;
  private final Pointcut pointcut;
  private final ImmutableList<PluginDetail.PointcutMethod> methods;
  private final byte[] bytes;
  private final boolean collocateInClassLoader;
  private final @Nullable File pluginJar;

  private ImmutablePointcutClass(
      Type type,
      Pointcut pointcut,
      ImmutableList<PluginDetail.PointcutMethod> methods,
      byte[] bytes,
      boolean collocateInClassLoader,
      @Nullable File pluginJar) {
    this.type = type;
    this.pointcut = pointcut;
    this.methods = methods;
    this.bytes = bytes;
    this.collocateInClassLoader = collocateInClassLoader;
    this.pluginJar = pluginJar;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  Type type() {
    return type;
  }

  /**
   * @return The value of the {@code pointcut} attribute
   */
  @JsonProperty("pointcut")
  @Override
  Pointcut pointcut() {
    return pointcut;
  }

  /**
   * @return The value of the {@code methods} attribute
   */
  @JsonProperty("methods")
  @Override
  ImmutableList<PluginDetail.PointcutMethod> methods() {
    return methods;
  }

  /**
   * @return A cloned {@code bytes} array
   */
  @JsonProperty("bytes")
  @Override
  byte[] bytes() {
    return bytes.clone();
  }

  /**
   * @return The value of the {@code collocateInClassLoader} attribute
   */
  @JsonProperty("collocateInClassLoader")
  @Override
  boolean collocateInClassLoader() {
    return collocateInClassLoader;
  }

  /**
   * @return The value of the {@code pluginJar} attribute
   */
  @JsonProperty("pluginJar")
  @Override
  @Nullable File pluginJar() {
    return pluginJar;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutClass#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClass withType(Type value) {
    if (this.type == value) return this;
    Type newValue = Objects.requireNonNull(value, "type");
    return new ImmutablePointcutClass(newValue, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutClass#pointcut() pointcut} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pointcut
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClass withPointcut(Pointcut value) {
    if (this.pointcut == value) return this;
    Pointcut newValue = Objects.requireNonNull(value, "pointcut");
    return new ImmutablePointcutClass(this.type, newValue, this.methods, this.bytes, this.collocateInClassLoader, this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.PointcutClass#methods() methods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutClass withMethods(PluginDetail.PointcutMethod... elements) {
    ImmutableList<PluginDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.PointcutClass#methods() methods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of methods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutClass withMethods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
    if (this.methods == elements) return this;
    ImmutableList<PluginDetail.PointcutMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePointcutClass(this.type, this.pointcut, newValue, this.bytes, this.collocateInClassLoader, this.pluginJar);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.PointcutClass#bytes() bytes}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for bytes
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutClass withBytes(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, newValue, this.collocateInClassLoader, this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutClass#collocateInClassLoader() collocateInClassLoader} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collocateInClassLoader
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClass withCollocateInClassLoader(boolean value) {
    if (this.collocateInClassLoader == value) return this;
    return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, value, this.pluginJar);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutClass#pluginJar() pluginJar} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pluginJar (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutClass withPluginJar(@Nullable File value) {
    if (this.pluginJar == value) return this;
    return new ImmutablePointcutClass(this.type, this.pointcut, this.methods, this.bytes, this.collocateInClassLoader, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePointcutClass} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePointcutClass
        && equalTo((ImmutablePointcutClass) another);
  }

  private boolean equalTo(ImmutablePointcutClass another) {
    return type.equals(another.type)
        && pointcut.equals(another.pointcut)
        && methods.equals(another.methods)
        && Arrays.equals(bytes, another.bytes)
        && collocateInClassLoader == another.collocateInClassLoader
        && Objects.equals(pluginJar, another.pluginJar);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code pointcut}, {@code methods}, {@code bytes}, {@code collocateInClassLoader}, {@code pluginJar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + pointcut.hashCode();
    h += (h << 5) + methods.hashCode();
    h += (h << 5) + Arrays.hashCode(bytes);
    h += (h << 5) + Booleans.hashCode(collocateInClassLoader);
    h += (h << 5) + Objects.hashCode(pluginJar);
    return h;
  }

  /**
   * Prints the immutable value {@code PointcutClass} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PointcutClass")
        .omitNullValues()
        .add("type", type)
        .add("pointcut", pointcut)
        .add("methods", methods)
        .add("bytes", Arrays.toString(bytes))
        .add("collocateInClassLoader", collocateInClassLoader)
        .add("pluginJar", pluginJar)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDetail.PointcutClass", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PluginDetail.PointcutClass {
    @Nullable Type type;
    @Nullable Pointcut pointcut;
    @Nullable List<PluginDetail.PointcutMethod> methods = ImmutableList.of();
    @Nullable byte[] bytes;
    boolean collocateInClassLoader;
    boolean collocateInClassLoaderIsSet;
    @Nullable File pluginJar;
    @JsonProperty("type")
    public void setType(Type type) {
      this.type = type;
    }
    @JsonProperty("pointcut")
    public void setPointcut(Pointcut pointcut) {
      this.pointcut = pointcut;
    }
    @JsonProperty("methods")
    public void setMethods(List<PluginDetail.PointcutMethod> methods) {
      this.methods = methods;
    }
    @JsonProperty("bytes")
    public void setBytes(byte[] bytes) {
      this.bytes = bytes;
    }
    @JsonProperty("collocateInClassLoader")
    public void setCollocateInClassLoader(boolean collocateInClassLoader) {
      this.collocateInClassLoader = collocateInClassLoader;
      this.collocateInClassLoaderIsSet = true;
    }
    @JsonProperty("pluginJar")
    public void setPluginJar(@Nullable File pluginJar) {
      this.pluginJar = pluginJar;
    }
    @Override
    Type type() { throw new UnsupportedOperationException(); }
    @Override
    Pointcut pointcut() { throw new UnsupportedOperationException(); }
    @Override
    List<PluginDetail.PointcutMethod> methods() { throw new UnsupportedOperationException(); }
    @Override
    byte[] bytes() { throw new UnsupportedOperationException(); }
    @Override
    boolean collocateInClassLoader() { throw new UnsupportedOperationException(); }
    @Override
    File pluginJar() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePointcutClass fromJson(Json json) {
    ImmutablePointcutClass.Builder builder = ImmutablePointcutClass.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.pointcut != null) {
      builder.pointcut(json.pointcut);
    }
    if (json.methods != null) {
      builder.addAllMethods(json.methods);
    }
    if (json.bytes != null) {
      builder.bytes(json.bytes);
    }
    if (json.collocateInClassLoaderIsSet) {
      builder.collocateInClassLoader(json.collocateInClassLoader);
    }
    if (json.pluginJar != null) {
      builder.pluginJar(json.pluginJar);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDetail.PointcutClass} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PointcutClass instance
   */
  public static ImmutablePointcutClass copyOf(PluginDetail.PointcutClass instance) {
    if (instance instanceof ImmutablePointcutClass) {
      return (ImmutablePointcutClass) instance;
    }
    return ImmutablePointcutClass.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePointcutClass ImmutablePointcutClass}.
   * <pre>
   * ImmutablePointcutClass.builder()
   *    .type(org.glowroot.agent.shaded.org.objectweb.asm.Type) // required {@link PluginDetail.PointcutClass#type() type}
   *    .pointcut(org.glowroot.agent.plugin.api.weaving.Pointcut) // required {@link PluginDetail.PointcutClass#pointcut() pointcut}
   *    .addMethods|addAllMethods(org.glowroot.agent.weaving.PluginDetail.PointcutMethod) // {@link PluginDetail.PointcutClass#methods() methods} elements
   *    .bytes(byte) // required {@link PluginDetail.PointcutClass#bytes() bytes}
   *    .collocateInClassLoader(boolean) // required {@link PluginDetail.PointcutClass#collocateInClassLoader() collocateInClassLoader}
   *    .pluginJar(java.io.File | null) // nullable {@link PluginDetail.PointcutClass#pluginJar() pluginJar}
   *    .build();
   * </pre>
   * @return A new ImmutablePointcutClass builder
   */
  public static ImmutablePointcutClass.Builder builder() {
    return new ImmutablePointcutClass.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePointcutClass ImmutablePointcutClass}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDetail.PointcutClass", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_POINTCUT = 0x2L;
    private static final long INIT_BIT_BYTES = 0x4L;
    private static final long INIT_BIT_COLLOCATE_IN_CLASS_LOADER = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Type type;
    private @Nullable Pointcut pointcut;
    private ImmutableList.Builder<PluginDetail.PointcutMethod> methods = ImmutableList.builder();
    private @Nullable byte[] bytes;
    private boolean collocateInClassLoader;
    private @Nullable File pluginJar;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PointcutClass} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDetail.PointcutClass instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      pointcut(instance.pointcut());
      addAllMethods(instance.methods());
      bytes(instance.bytes());
      collocateInClassLoader(instance.collocateInClassLoader());
      @Nullable File pluginJarValue = instance.pluginJar();
      if (pluginJarValue != null) {
        pluginJar(pluginJarValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutClass#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutClass#pointcut() pointcut} attribute.
     * @param pointcut The value for pointcut 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pointcut(Pointcut pointcut) {
      this.pointcut = Objects.requireNonNull(pointcut, "pointcut");
      initBits &= ~INIT_BIT_POINTCUT;
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail.PointcutClass#methods() methods} list.
     * @param element A methods element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMethods(PluginDetail.PointcutMethod element) {
      this.methods.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail.PointcutClass#methods() methods} list.
     * @param elements An array of methods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMethods(PluginDetail.PointcutMethod... elements) {
      this.methods.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail.PointcutClass#methods() methods} list.
     * @param elements An iterable of methods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder methods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
      this.methods = ImmutableList.builder();
      return addAllMethods(elements);
    }

    /**
     * Adds elements to {@link PluginDetail.PointcutClass#methods() methods} list.
     * @param elements An iterable of methods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMethods(Iterable<? extends PluginDetail.PointcutMethod> elements) {
      this.methods.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutClass#bytes() bytes} attribute.
     * @param bytes The elements for bytes
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bytes(byte... bytes) {
      this.bytes = bytes.clone();
      initBits &= ~INIT_BIT_BYTES;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutClass#collocateInClassLoader() collocateInClassLoader} attribute.
     * @param collocateInClassLoader The value for collocateInClassLoader 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder collocateInClassLoader(boolean collocateInClassLoader) {
      this.collocateInClassLoader = collocateInClassLoader;
      initBits &= ~INIT_BIT_COLLOCATE_IN_CLASS_LOADER;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutClass#pluginJar() pluginJar} attribute.
     * @param pluginJar The value for pluginJar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pluginJar(@Nullable File pluginJar) {
      this.pluginJar = pluginJar;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePointcutClass ImmutablePointcutClass}.
     * @return An immutable instance of PointcutClass
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePointcutClass build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePointcutClass(type, pointcut, methods.build(), bytes, collocateInClassLoader, pluginJar);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_POINTCUT) != 0) attributes.add("pointcut");
      if ((initBits & INIT_BIT_BYTES) != 0) attributes.add("bytes");
      if ((initBits & INIT_BIT_COLLOCATE_IN_CLASS_LOADER) != 0) attributes.add("collocateInClassLoader");
      return "Cannot build PointcutClass, some of required attributes are not set " + attributes;
    }
  }
}
