package org.glowroot.agent.weaving;

import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.Method;

/**
 * Immutable implementation of {@link PluginDetail.PointcutMethod}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePointcutMethod.builder()}.
 */
@Generated(from = "PluginDetail.PointcutMethod", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePointcutMethod extends PluginDetail.PointcutMethod {
  private final String name;
  private final String descriptor;
  private final ImmutableSet<Type> annotationTypes;
  private final ImmutableMap<Integer, List<Type>> parameterAnnotationTypes;
  private transient final Method toAsmMethod;

  private ImmutablePointcutMethod(
      String name,
      String descriptor,
      ImmutableSet<Type> annotationTypes,
      ImmutableMap<Integer, List<Type>> parameterAnnotationTypes) {
    this.name = name;
    this.descriptor = descriptor;
    this.annotationTypes = annotationTypes;
    this.parameterAnnotationTypes = parameterAnnotationTypes;
    this.toAsmMethod = Objects.requireNonNull(super.toAsmMethod(), "toAsmMethod");
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  String name() {
    return name;
  }

  /**
   * @return The value of the {@code descriptor} attribute
   */
  @JsonProperty("descriptor")
  @Override
  String descriptor() {
    return descriptor;
  }

  /**
   * @return The value of the {@code annotationTypes} attribute
   */
  @JsonProperty("annotationTypes")
  @Override
  ImmutableSet<Type> annotationTypes() {
    return annotationTypes;
  }

  /**
   * @return The value of the {@code parameterAnnotationTypes} attribute
   */
  @JsonProperty("parameterAnnotationTypes")
  @Override
  ImmutableMap<Integer, List<Type>> parameterAnnotationTypes() {
    return parameterAnnotationTypes;
  }

  /**
   * @return The computed-at-construction value of the {@code toAsmMethod} attribute
   */
  @JsonProperty("toAsmMethod")
  @Override
  Method toAsmMethod() {
    return toAsmMethod;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutMethod#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutMethod withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutablePointcutMethod(newValue, this.descriptor, this.annotationTypes, this.parameterAnnotationTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PluginDetail.PointcutMethod#descriptor() descriptor} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for descriptor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePointcutMethod withDescriptor(String value) {
    String newValue = Objects.requireNonNull(value, "descriptor");
    if (this.descriptor.equals(newValue)) return this;
    return new ImmutablePointcutMethod(this.name, newValue, this.annotationTypes, this.parameterAnnotationTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutMethod withAnnotationTypes(Type... elements) {
    ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
    return new ImmutablePointcutMethod(this.name, this.descriptor, newValue, this.parameterAnnotationTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of annotationTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutMethod withAnnotationTypes(Iterable<? extends Type> elements) {
    if (this.annotationTypes == elements) return this;
    ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
    return new ImmutablePointcutMethod(this.name, this.descriptor, newValue, this.parameterAnnotationTypes);
  }

  /**
   * Copy the current immutable object by replacing the {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the parameterAnnotationTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePointcutMethod withParameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
    if (this.parameterAnnotationTypes == entries) return this;
    ImmutableMap<Integer, List<Type>> newValue = ImmutableMap.copyOf(entries);
    return new ImmutablePointcutMethod(this.name, this.descriptor, this.annotationTypes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePointcutMethod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePointcutMethod
        && equalTo((ImmutablePointcutMethod) another);
  }

  private boolean equalTo(ImmutablePointcutMethod another) {
    return name.equals(another.name)
        && descriptor.equals(another.descriptor)
        && annotationTypes.equals(another.annotationTypes)
        && parameterAnnotationTypes.equals(another.parameterAnnotationTypes)
        && toAsmMethod.equals(another.toAsmMethod);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code descriptor}, {@code annotationTypes}, {@code parameterAnnotationTypes}, {@code toAsmMethod}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + descriptor.hashCode();
    h += (h << 5) + annotationTypes.hashCode();
    h += (h << 5) + parameterAnnotationTypes.hashCode();
    h += (h << 5) + toAsmMethod.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PointcutMethod} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PointcutMethod")
        .omitNullValues()
        .add("name", name)
        .add("descriptor", descriptor)
        .add("annotationTypes", annotationTypes)
        .add("parameterAnnotationTypes", parameterAnnotationTypes)
        .add("toAsmMethod", toAsmMethod)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PluginDetail.PointcutMethod", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends PluginDetail.PointcutMethod {
    @Nullable String name;
    @Nullable String descriptor;
    @Nullable Set<Type> annotationTypes = ImmutableSet.of();
    @Nullable Map<Integer, List<Type>> parameterAnnotationTypes = ImmutableMap.of();
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("descriptor")
    public void setDescriptor(String descriptor) {
      this.descriptor = descriptor;
    }
    @JsonProperty("annotationTypes")
    public void setAnnotationTypes(Set<Type> annotationTypes) {
      this.annotationTypes = annotationTypes;
    }
    @JsonProperty("parameterAnnotationTypes")
    public void setParameterAnnotationTypes(Map<Integer, List<Type>> parameterAnnotationTypes) {
      this.parameterAnnotationTypes = parameterAnnotationTypes;
    }
    @Override
    String name() { throw new UnsupportedOperationException(); }
    @Override
    String descriptor() { throw new UnsupportedOperationException(); }
    @Override
    Set<Type> annotationTypes() { throw new UnsupportedOperationException(); }
    @Override
    Map<Integer, List<Type>> parameterAnnotationTypes() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    Method toAsmMethod() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePointcutMethod fromJson(Json json) {
    ImmutablePointcutMethod.Builder builder = ImmutablePointcutMethod.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.descriptor != null) {
      builder.descriptor(json.descriptor);
    }
    if (json.annotationTypes != null) {
      builder.addAllAnnotationTypes(json.annotationTypes);
    }
    if (json.parameterAnnotationTypes != null) {
      builder.putAllParameterAnnotationTypes(json.parameterAnnotationTypes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PluginDetail.PointcutMethod} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PointcutMethod instance
   */
  public static ImmutablePointcutMethod copyOf(PluginDetail.PointcutMethod instance) {
    if (instance instanceof ImmutablePointcutMethod) {
      return (ImmutablePointcutMethod) instance;
    }
    return ImmutablePointcutMethod.builder()
        .copyFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePointcutMethod ImmutablePointcutMethod}.
   * <pre>
   * ImmutablePointcutMethod.builder()
   *    .name(String) // required {@link PluginDetail.PointcutMethod#name() name}
   *    .descriptor(String) // required {@link PluginDetail.PointcutMethod#descriptor() descriptor}
   *    .addAnnotationTypes|addAllAnnotationTypes(org.glowroot.agent.shaded.org.objectweb.asm.Type) // {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes} elements
   *    .putParameterAnnotationTypes|putAllParameterAnnotationTypes(int =&gt; List&amp;lt;org.glowroot.agent.shaded.org.objectweb.asm.Type&amp;gt;) // {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} mappings
   *    .build();
   * </pre>
   * @return A new ImmutablePointcutMethod builder
   */
  public static ImmutablePointcutMethod.Builder builder() {
    return new ImmutablePointcutMethod.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePointcutMethod ImmutablePointcutMethod}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PluginDetail.PointcutMethod", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_DESCRIPTOR = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String descriptor;
    private ImmutableSet.Builder<Type> annotationTypes = ImmutableSet.builder();
    private ImmutableMap.Builder<Integer, List<Type>> parameterAnnotationTypes = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PointcutMethod} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyFrom(PluginDetail.PointcutMethod instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      descriptor(instance.descriptor());
      addAllAnnotationTypes(instance.annotationTypes());
      putAllParameterAnnotationTypes(instance.parameterAnnotationTypes());
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutMethod#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PluginDetail.PointcutMethod#descriptor() descriptor} attribute.
     * @param descriptor The value for descriptor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder descriptor(String descriptor) {
      this.descriptor = Objects.requireNonNull(descriptor, "descriptor");
      initBits &= ~INIT_BIT_DESCRIPTOR;
      return this;
    }

    /**
     * Adds one element to {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes} set.
     * @param element A annotationTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnnotationTypes(Type element) {
      this.annotationTypes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes} set.
     * @param elements An array of annotationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAnnotationTypes(Type... elements) {
      this.annotationTypes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes} set.
     * @param elements An iterable of annotationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder annotationTypes(Iterable<? extends Type> elements) {
      this.annotationTypes = ImmutableSet.builder();
      return addAllAnnotationTypes(elements);
    }

    /**
     * Adds elements to {@link PluginDetail.PointcutMethod#annotationTypes() annotationTypes} set.
     * @param elements An iterable of annotationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAnnotationTypes(Iterable<? extends Type> elements) {
      this.annotationTypes.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} map.
     * @param key The key in the parameterAnnotationTypes map
     * @param value The associated value in the parameterAnnotationTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putParameterAnnotationTypes(int key, List<Type> value) {
      this.parameterAnnotationTypes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putParameterAnnotationTypes(Map.Entry<Integer, ? extends List<Type>> entry) {
      this.parameterAnnotationTypes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameterAnnotationTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder parameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
      this.parameterAnnotationTypes = ImmutableMap.builder();
      return putAllParameterAnnotationTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PluginDetail.PointcutMethod#parameterAnnotationTypes() parameterAnnotationTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameterAnnotationTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllParameterAnnotationTypes(Map<Integer, ? extends List<Type>> entries) {
      this.parameterAnnotationTypes.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePointcutMethod ImmutablePointcutMethod}.
     * @return An immutable instance of PointcutMethod
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePointcutMethod build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePointcutMethod(name, descriptor, annotationTypes.build(), parameterAnnotationTypes.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTOR) != 0) attributes.add("descriptor");
      return "Cannot build PointcutMethod, some of required attributes are not set " + attributes;
    }
  }
}
