/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassReader;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.ClassWriter;
import org.glowroot.agent.shaded.org.objectweb.asm.MethodVisitor;
import org.glowroot.agent.shaded.org.objectweb.asm.Type;
import org.glowroot.agent.shaded.org.objectweb.asm.commons.AdviceAdapter;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class DebuggingClassFileTransformer
implements ClassFileTransformer {
    private static volatile @MonotonicNonNull Logger logger;

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        try {
            if ("sun/misc/Launcher$AppClassLoader".equals(className)) {
                ClassWriter cw = new ClassWriter(1);
                DebuggingClassVisitor cv = new DebuggingClassVisitor(cw);
                ClassReader cr = new ClassReader(bytes);
                cr.accept(cv, 8);
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            if (logger == null) {
                t.printStackTrace();
            }
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    public static void loadingClass(String name) {
        if (name.startsWith("org.glowroot.")) {
            new Exception(name).printStackTrace();
        }
    }

    public static void initLogger() {
        logger = LoggerFactory.getLogger(DebuggingClassFileTransformer.class);
    }

    private static class DebuggingMethodAdvice
    extends AdviceAdapter {
        private DebuggingMethodAdvice(MethodVisitor mv, int access, String name, String descriptor) {
            super(589824, mv, access, name, descriptor);
        }

        @Override
        protected void onMethodEnter() {
            this.visitVarInsn(25, 1);
            this.visitMethodInsn(184, Type.getInternalName(DebuggingClassFileTransformer.class), "loadingClass", "(Ljava/lang/String;)V", false);
        }
    }

    private static class DebuggingClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private DebuggingClassVisitor(ClassWriter cw) {
            super(589824, cw);
            this.cw = cw;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("loadClass") && descriptor.equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) {
                return new DebuggingMethodAdvice(mv, access, name, descriptor);
            }
            return mv;
        }
    }
}

