/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.central.CentralConnection;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CentralConnection.CollectorTarget", generator="Immutables")
@Immutable
final class ImmutableCollectorTarget
implements CentralConnection.CollectorTarget {
    private final String host;
    private final int port;

    private ImmutableCollectorTarget(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    @JsonProperty(value="host")
    public String host() {
        return this.host;
    }

    @Override
    @JsonProperty(value="port")
    public int port() {
        return this.port;
    }

    public final ImmutableCollectorTarget withHost(String value) {
        String newValue = Objects.requireNonNull(value, "host");
        if (this.host.equals(newValue)) {
            return this;
        }
        return new ImmutableCollectorTarget(newValue, this.port);
    }

    public final ImmutableCollectorTarget withPort(int value) {
        if (this.port == value) {
            return this;
        }
        return new ImmutableCollectorTarget(this.host, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCollectorTarget && this.equalTo((ImmutableCollectorTarget)another);
    }

    private boolean equalTo(ImmutableCollectorTarget another) {
        return this.host.equals(another.host) && this.port == another.port;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.port;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CollectorTarget").omitNullValues().add("host", this.host).add("port", this.port).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCollectorTarget fromJson(Json json) {
        Builder builder = ImmutableCollectorTarget.builder();
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.portIsSet) {
            builder.port(json.port);
        }
        return builder.build();
    }

    public static ImmutableCollectorTarget copyOf(CentralConnection.CollectorTarget instance) {
        if (instance instanceof ImmutableCollectorTarget) {
            return (ImmutableCollectorTarget)instance;
        }
        return ImmutableCollectorTarget.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CentralConnection.CollectorTarget", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private String host;
        private int port;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(CentralConnection.CollectorTarget instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            this.port(instance.port());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder port(int port) {
            this.port = port;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCollectorTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCollectorTarget(this.host, this.port);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("port");
            }
            return "Cannot build CollectorTarget, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CentralConnection.CollectorTarget", generator="Immutables")
    static final class Json
    implements CentralConnection.CollectorTarget {
        @Nullable
        String host;
        int port;
        boolean portIsSet;

        Json() {
        }

        @JsonProperty(value="host")
        public void setHost(String host) {
            this.host = host;
        }

        @JsonProperty(value="port")
        public void setPort(int port) {
            this.port = port;
            this.portIsSet = true;
        }

        @Override
        public String host() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int port() {
            throw new UnsupportedOperationException();
        }
    }
}

