/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.ConfigFileUtil;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class ConfigFile {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFile.class);
    private static final ObjectMapper mapper = ObjectMappers.create(new Module[0]);
    private static final List<String> keyOrder = ImmutableList.of("transactions", "jvm", "uiDefaults", "advanced", "gauges", "syntheticMonitors", "alerts", "plugins", "instrumentation");
    private final File file;
    private final ObjectNode rootObjectNode;
    private final boolean readOnly;

    ConfigFile(List<File> confDirs, boolean readOnly) {
        File defaultFile;
        this.file = new File(confDirs.get(0), "config.json");
        this.rootObjectNode = this.file.exists() ? ConfigFile.readRootObjectNode(this.file) : ((defaultFile = ConfigFile.getConfigDefaultFile(confDirs)) == null ? mapper.createObjectNode() : ConfigFile.readRootObjectNode(defaultFile));
        this.readOnly = readOnly;
    }

    <T> T getConfig(String key, Class<T> clazz) {
        return ConfigFileUtil.getConfig(this.rootObjectNode, key, clazz);
    }

    <T> T getConfig(String key, TypeReference<T> typeReference) {
        return ConfigFileUtil.getConfig(this.rootObjectNode, key, typeReference);
    }

    void writeConfig(String key, Object config) throws IOException {
        if (this.readOnly) {
            throw new IllegalStateException("Running with config.readOnly=true so config updates are not allowed");
        }
        this.rootObjectNode.replace(key, (JsonNode)mapper.valueToTree(config));
        ConfigFileUtil.writeToFileIfNeeded(this.file, this.rootObjectNode, keyOrder, false);
    }

    void writeAllConfigs(Map<String, Object> configs) throws IOException {
        if (this.readOnly) {
            throw new IllegalStateException("Running with config.readOnly=true so config updates are not allowed");
        }
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            this.rootObjectNode.replace(entry.getKey(), (JsonNode)mapper.valueToTree(entry.getValue()));
        }
        ConfigFileUtil.writeToFileIfNeeded(this.file, this.rootObjectNode, keyOrder, false);
    }

    void writeAllConfigsOnStartup(Map<String, Object> configs) throws IOException {
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            this.rootObjectNode.replace(entry.getKey(), (JsonNode)mapper.valueToTree(entry.getValue()));
        }
        ConfigFileUtil.writeToFileIfNeeded(this.file, this.rootObjectNode, keyOrder, this.readOnly);
    }

    @OnlyUsedByTests
    void delete() throws IOException {
        if (!this.file.delete()) {
            throw new IOException("Could not delete file: " + this.file.getCanonicalPath());
        }
    }

    private static ObjectNode readRootObjectNode(File file) {
        ObjectNode rootObjectNode = ConfigFileUtil.getRootObjectNode(file);
        ConfigFile.upgradeAlertsIfNeeded(rootObjectNode);
        ConfigFile.upgradeUiIfNeeded(rootObjectNode);
        ConfigFile.upgradeAdvancedIfNeeded(rootObjectNode);
        ConfigFile.upgradePluginPropertiesIfNeeded(rootObjectNode);
        ConfigFile.upgradeSlowThresholdOverrideIfNeeded(rootObjectNode);
        ConfigFile.removeUserRecordingIfNeeded(rootObjectNode);
        return rootObjectNode;
    }

    private static @Nullable File getConfigDefaultFile(List<File> confDirs) {
        for (File confDir : confDirs) {
            File defaultFile = new File(confDir, "config-default.json");
            if (!defaultFile.exists()) continue;
            return defaultFile;
        }
        return null;
    }

    private static void upgradeAlertsIfNeeded(ObjectNode rootObjectNode) {
        JsonNode alertsNode = rootObjectNode.get("alerts");
        if (alertsNode == null || !alertsNode.isArray()) {
            return;
        }
        for (JsonNode alertNode : alertsNode) {
            JsonNode conditionNode;
            ObjectNode conditionObjectNode;
            if (!(alertNode instanceof ObjectNode)) continue;
            ObjectNode alertObjectNode = (ObjectNode)alertNode;
            if (alertObjectNode.has("transactionThresholdMillis")) {
                alertObjectNode.set("thresholdMillis", alertObjectNode.remove("transactionThresholdMillis"));
            }
            if (alertObjectNode.has("kind")) {
                String alertKind = alertObjectNode.remove("kind").asText();
                if (alertKind.equals("transaction")) {
                    conditionObjectNode = mapper.createObjectNode();
                    conditionObjectNode.put("conditionType", "metric");
                    conditionObjectNode.put("metric", "transaction:x-percentile");
                    conditionObjectNode.set("transactionType", alertObjectNode.remove("transactionType"));
                    conditionObjectNode.set("percentile", alertObjectNode.remove("transactionPercentile"));
                    conditionObjectNode.set("threshold", alertObjectNode.remove("thresholdMillis"));
                    conditionObjectNode.set("timePeriodSeconds", alertObjectNode.remove("timePeriodSeconds"));
                    conditionObjectNode.set("minTransactionCount", alertObjectNode.remove("minTransactionCount"));
                    alertObjectNode.set("condition", conditionObjectNode);
                } else if (alertKind.equals("gauge")) {
                    conditionObjectNode = mapper.createObjectNode();
                    conditionObjectNode.put("conditionType", "metric");
                    conditionObjectNode.put("metric", "gauge:" + alertObjectNode.remove("gaugeName").asText());
                    conditionObjectNode.set("threshold", alertObjectNode.remove("gaugeThreshold"));
                    conditionObjectNode.set("timePeriodSeconds", alertObjectNode.remove("timePeriodSeconds"));
                    alertObjectNode.set("condition", conditionObjectNode);
                } else {
                    logger.error("unexpected alert kind: {}", (Object)alertKind);
                }
                ObjectNode emailNotificationObjectNode = mapper.createObjectNode();
                emailNotificationObjectNode.set("emailAddresses", alertObjectNode.remove("emailAddresses"));
                alertObjectNode.set("emailNotification", emailNotificationObjectNode);
            }
            if (!alertObjectNode.has("severity")) {
                alertObjectNode.put("severity", "critical");
            }
            if (!alertObjectNode.has("condition") || !((conditionNode = alertObjectNode.get("condition")) instanceof ObjectNode) || !(conditionObjectNode = (ObjectNode)conditionNode).path("conditionType").asText().equals("synthetic-monitor") || conditionObjectNode.has("consecutiveCount")) continue;
            conditionObjectNode.put("consecutiveCount", 1);
        }
    }

    private static void upgradeUiIfNeeded(ObjectNode configRootObjectNode) {
        JsonNode uiNode = configRootObjectNode.get("ui");
        if (uiNode == null || !uiNode.isObject()) {
            return;
        }
        ObjectNode uiObjectNode = (ObjectNode)uiNode;
        if (uiObjectNode.has("defaultDisplayedTransactionType")) {
            uiObjectNode.set("defaultTransactionType", uiObjectNode.remove("defaultDisplayedTransactionType"));
        }
        if (uiObjectNode.has("defaultDisplayedPercentiles")) {
            uiObjectNode.set("defaultPercentiles", uiObjectNode.remove("defaultDisplayedPercentiles"));
        }
        configRootObjectNode.set("uiDefaults", configRootObjectNode.remove("ui"));
    }

    private static void upgradeAdvancedIfNeeded(ObjectNode rootObjectNode) {
        JsonNode advancedNode = rootObjectNode.get("advanced");
        if (advancedNode == null || !advancedNode.isObject()) {
            return;
        }
        ObjectNode advancedObjectNode = (ObjectNode)advancedNode;
        if (advancedObjectNode.has("maxAggregateTransactionsPerType")) {
            advancedObjectNode.set("maxTransactionAggregates", advancedObjectNode.remove("maxAggregateTransactionsPerType"));
        }
        if (advancedObjectNode.has("maxAggregateQueriesPerType")) {
            advancedObjectNode.set("maxQueryAggregates", advancedObjectNode.remove("maxAggregateQueriesPerType"));
        }
        if (advancedObjectNode.has("maxAggregateServiceCallsPerType")) {
            advancedObjectNode.set("maxServiceCallAggregates", advancedObjectNode.remove("maxAggregateServiceCallsPerType"));
        }
        if (advancedObjectNode.has("maxStackTraceSamplesPerTransaction")) {
            advancedObjectNode.set("maxProfileSamplesPerTransaction", advancedObjectNode.remove("maxStackTraceSamplesPerTransaction"));
        }
    }

    private static void upgradePluginPropertiesIfNeeded(ObjectNode rootObjectNode) {
        JsonNode pluginsNode = rootObjectNode.get("plugins");
        if (pluginsNode == null || !pluginsNode.isArray()) {
            return;
        }
        for (JsonNode pluginNode : pluginsNode) {
            ObjectNode pluginObjectNode;
            if (!(pluginNode instanceof ObjectNode) || !(pluginObjectNode = (ObjectNode)pluginNode).path("id").asText().equals("jdbc")) continue;
            JsonNode propertiesNode = pluginObjectNode.get("properties");
            if (propertiesNode != null && propertiesNode.isObject()) {
                ConfigFile.upgradeJdbcPluginPropertiesIfNeeded((ObjectNode)propertiesNode);
            }
            return;
        }
    }

    private static void upgradeSlowThresholdOverrideIfNeeded(ObjectNode rootObjectNode) {
        JsonNode transactionsNode = rootObjectNode.get("transactions");
        if (transactionsNode == null || !transactionsNode.isObject()) {
            return;
        }
        ObjectNode transactionsObjectNode = (ObjectNode)transactionsNode;
        if (transactionsObjectNode.has("slowThresholds")) {
            transactionsObjectNode.set("slowThresholdOverrides", transactionsObjectNode.remove("slowThresholds"));
        }
    }

    private static void removeUserRecordingIfNeeded(ObjectNode rootObjectNode) {
        rootObjectNode.remove("userRecording");
    }

    private static void upgradeJdbcPluginPropertiesIfNeeded(ObjectNode propertiesObjectNode) {
        if (propertiesObjectNode.path("captureBindParameters").asBoolean() && !propertiesObjectNode.has("captureBindParametersIncludes")) {
            propertiesObjectNode.set("captureBindParametersIncludes", mapper.createArrayNode().add(".*"));
            propertiesObjectNode.remove("captureBindParameters");
        }
    }
}

