/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.config.ConfigFile;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.CharStreams;
import org.glowroot.agent.shaded.com.google.common.io.Files;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class ConfigFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFile.class);
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    private static final ObjectMapper mapper = ObjectMappers.create(new Module[0]);

    private ConfigFileUtil() {
    }

    public static ObjectNode getRootObjectNode(File file) {
        String content;
        try {
            content = Files.toString(file, Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            return mapper.createObjectNode();
        }
        ObjectNode rootObjectNode = null;
        try {
            JsonNode rootNode = mapper.readTree(content);
            if (rootNode instanceof ObjectNode) {
                rootObjectNode = (ObjectNode)rootNode;
            }
        }
        catch (IOException e) {
            logger.warn("error processing config file: {}", (Object)file.getAbsolutePath(), (Object)e);
            ConfigFileUtil.writeBackupFile(file);
        }
        return rootObjectNode == null ? mapper.createObjectNode() : rootObjectNode;
    }

    public static <T> T getConfig(ObjectNode rootObjectNode, String key, Class<T> clazz) {
        JsonNode node = rootObjectNode.get(key);
        if (node == null) {
            return null;
        }
        try {
            return mapper.treeToValue(node, clazz);
        }
        catch (JsonProcessingException e) {
            logger.error("error parsing config json node '{}': ", (Object)key, (Object)e);
            return null;
        }
    }

    public static <T> T getConfig(ObjectNode rootObjectNode, String key, TypeReference<T> typeReference) {
        JsonNode node = rootObjectNode.get(key);
        if (node == null) {
            return null;
        }
        try {
            return mapper.readValue(mapper.treeAsTokens(node), typeReference);
        }
        catch (IOException e) {
            logger.error("error parsing config json node '{}': ", (Object)key, (Object)e);
            return null;
        }
    }

    public static void writeToFileIfNeeded(File file, ObjectNode rootObjectNode, List<String> keyOrder, boolean logStartupMessageInstead) throws IOException {
        String content = ConfigFileUtil.writeConfigAsString(rootObjectNode, keyOrder);
        String existingContent = "";
        if (file.exists() && content.equals(existingContent = Files.toString(file, Charsets.UTF_8))) {
            return;
        }
        if (!logStartupMessageInstead) {
            Files.write(content, file, Charsets.UTF_8);
        } else if (!ConfigFileUtil.normalize(content).equals(ConfigFileUtil.normalize(existingContent))) {
            startupLogger.info("tried to update {} during startup but the agent is running with config.readOnly=true, you can prevent this message from re-occurring by manually updating the file with these contents:\n{}", (Object)file.getName(), (Object)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeConfigAsString(ObjectNode rootObjectNode, List<String> keyOrder) throws IOException {
        ObjectNode orderedRootObjectNode = ConfigFileUtil.getOrderedObjectNode(rootObjectNode, keyOrder);
        ObjectMappers.stripEmptyContainerNodes(orderedRootObjectNode);
        StringBuilder sb = new StringBuilder();
        try (JsonGenerator jg = mapper.getFactory().createGenerator(CharStreams.asWriter(sb));){
            jg.setPrettyPrinter(ObjectMappers.getPrettyPrinter());
            jg.writeTree(orderedRootObjectNode);
        }
        return sb.toString() + ObjectMappers.NEWLINE;
    }

    private static ObjectNode getOrderedObjectNode(ObjectNode objectNode, List<String> keyOrder) {
        HashMap<String, JsonNode> map = Maps.newHashMap();
        Iterator<Map.Entry<String, JsonNode>> i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry<String, JsonNode> entry = i.next();
            map.put(entry.getKey(), entry.getValue());
        }
        ObjectNode orderedObjectNode = mapper.createObjectNode();
        for (Map.Entry entry : new ExplicitOrdering(keyOrder).sortedCopy(map.entrySet())) {
            orderedObjectNode.set((String)entry.getKey(), (JsonNode)entry.getValue());
        }
        return orderedObjectNode;
    }

    private static void writeBackupFile(File file) {
        File backupFile = new File(file.getParentFile(), file.getName() + ".invalid-orig");
        try {
            Files.copy(file, backupFile);
            logger.warn("due to an error in the config file, it has been backed up to extension '.invalid-orig' and will be overwritten with the default config");
        }
        catch (IOException f) {
            logger.warn("error making a copy of the invalid config file before overwriting it", f);
        }
    }

    private static String normalize(String content) {
        return content.replace("\r\n", "\n").trim();
    }

    private static class ExplicitOrdering
    extends Ordering<Map.Entry<String, JsonNode>> {
        private final List<String> ordering;

        private ExplicitOrdering(List<String> ordering) {
            this.ordering = ordering;
        }

        @Override
        public int compare(Map.Entry<String, JsonNode> left, Map.Entry<String, JsonNode> right) {
            String leftKey = left.getKey();
            String rightKey = right.getKey();
            int compare = Ints.compare(this.getIndex(leftKey), this.getIndex(rightKey));
            if (compare != 0) {
                return compare;
            }
            return Ordering.natural().compare(leftKey, rightKey);
        }

        private int getIndex(String key) {
            int index = this.ordering.indexOf(key);
            return index == -1 ? Integer.MAX_VALUE : index;
        }
    }
}

