/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.config.DoubleProperty;
import org.glowroot.agent.plugin.api.config.ListProperty;
import org.glowroot.agent.plugin.api.config.StringProperty;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.MapMaker;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class ConfigServiceImpl
implements ConfigListener,
ConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigServiceImpl.class);
    private final org.glowroot.agent.config.ConfigService configService;
    private final @Nullable String pluginId;
    private @MonotonicNonNull PluginConfig pluginConfig;
    private final Map<ConfigListener, Boolean> configListeners = new MapMaker().weakKeys().makeMap();

    public static ConfigServiceImpl create(org.glowroot.agent.config.ConfigService configService, List<PluginDescriptor> pluginDescriptors, String pluginId) {
        ConfigServiceImpl configServiceImpl = new ConfigServiceImpl(configService, pluginDescriptors, pluginId);
        configService.addPluginConfigListener(configServiceImpl);
        configService.addConfigListener(configServiceImpl);
        return configServiceImpl;
    }

    private ConfigServiceImpl(org.glowroot.agent.config.ConfigService configService, List<PluginDescriptor> pluginDescriptors, String pluginId) {
        this.configService = configService;
        PluginConfig pluginConfig = configService.getPluginConfig(pluginId);
        if (pluginConfig == null) {
            if (pluginDescriptors.isEmpty()) {
                logger.warn("unexpected plugin id: {} (there are no available plugins)", (Object)pluginId);
            } else {
                ArrayList<String> ids = Lists.newArrayList();
                for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
                    ids.add(pluginDescriptor.id());
                }
                logger.warn("unexpected plugin id: {} (available plugin ids are {})", (Object)pluginId, (Object)Joiner.on(", ").join(ids));
            }
            this.pluginId = null;
        } else {
            this.pluginId = pluginId;
        }
    }

    @Override
    public StringProperty getStringProperty(String name) {
        if (name == null) {
            logger.error("getStringProperty(): argument 'name' must be non-null");
            return new StringPropertyImpl("");
        }
        StringPropertyImpl stringProperty = new StringPropertyImpl(name);
        this.configListeners.put(stringProperty, true);
        return stringProperty;
    }

    @Override
    public BooleanProperty getBooleanProperty(String name) {
        if (name == null) {
            logger.error("getBooleanProperty(): argument 'name' must be non-null");
            return new BooleanPropertyImpl("");
        }
        BooleanPropertyImpl booleanProperty = new BooleanPropertyImpl(name);
        this.configListeners.put(booleanProperty, true);
        return booleanProperty;
    }

    @Override
    public DoubleProperty getDoubleProperty(String name) {
        if (name == null) {
            logger.error("getDoubleProperty(): argument 'name' must be non-null");
            return new DoublePropertyImpl("");
        }
        DoublePropertyImpl doubleProperty = new DoublePropertyImpl(name);
        this.configListeners.put(doubleProperty, true);
        return doubleProperty;
    }

    @Override
    public ListProperty getListProperty(String name) {
        if (name == null) {
            logger.error("getListProperty(): argument 'name' must be non-null");
            return new ListPropertyImpl("");
        }
        ListPropertyImpl listProperty = new ListPropertyImpl(name);
        this.configListeners.put(listProperty, true);
        return listProperty;
    }

    @Override
    public void registerConfigListener(ConfigListener listener) {
        if (this.pluginId == null) {
            return;
        }
        if (listener == null) {
            logger.error("registerConfigListener(): argument 'listener' must be non-null");
            return;
        }
        this.configService.addPluginConfigListener(listener);
        listener.onChange();
        this.configService.writeMemoryBarrier();
    }

    @Override
    public void onChange() {
        if (this.pluginId != null) {
            PluginConfig pluginConfig = this.configService.getPluginConfig(this.pluginId);
            Preconditions.checkNotNull(pluginConfig);
            this.pluginConfig = pluginConfig;
        }
        for (ConfigListener configListener : this.configListeners.keySet()) {
            configListener.onChange();
        }
        this.configService.writeMemoryBarrier();
    }

    private class ListPropertyImpl
    implements ConfigListener,
    ListProperty {
        private final String name;
        private List<String> value = ImmutableList.of();

        private ListPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getListProperty(name);
            }
        }

        @Override
        public List<String> value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getListProperty(this.name);
            }
        }
    }

    private class DoublePropertyImpl
    implements ConfigListener,
    DoubleProperty {
        private final String name;
        private @Nullable Double value;

        private DoublePropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getDoubleProperty(name);
            }
        }

        @Override
        public @Nullable Double value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getDoubleProperty(this.name);
            }
        }
    }

    private class BooleanPropertyImpl
    implements BooleanProperty,
    ConfigListener {
        private final String name;
        private boolean value;

        private BooleanPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getBooleanProperty(name);
            }
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getBooleanProperty(this.name);
            }
        }
    }

    private class StringPropertyImpl
    implements ConfigListener,
    StringProperty {
        private final String name;
        private String value = "";

        private StringPropertyImpl(String name) {
            this.name = name;
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getStringProperty(name);
            }
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void onChange() {
            if (ConfigServiceImpl.this.pluginConfig != null) {
                this.value = ConfigServiceImpl.this.pluginConfig.getStringProperty(this.name);
            }
        }
    }
}

