/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TraceCollector.PendingTrace", generator="Immutables")
@Immutable
public final class ImmutablePendingTrace
implements TraceCollector.PendingTrace {
    private final Transaction transaction;
    private final boolean slow;
    private final boolean partial;

    private ImmutablePendingTrace(Transaction transaction, boolean slow, boolean partial) {
        this.transaction = transaction;
        this.slow = slow;
        this.partial = partial;
    }

    @Override
    @JsonProperty(value="transaction")
    public Transaction transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="slow")
    public boolean slow() {
        return this.slow;
    }

    @Override
    @JsonProperty(value="partial")
    public boolean partial() {
        return this.partial;
    }

    public final ImmutablePendingTrace withTransaction(Transaction value) {
        if (this.transaction == value) {
            return this;
        }
        Transaction newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutablePendingTrace(newValue, this.slow, this.partial);
    }

    public final ImmutablePendingTrace withSlow(boolean value) {
        if (this.slow == value) {
            return this;
        }
        return new ImmutablePendingTrace(this.transaction, value, this.partial);
    }

    public final ImmutablePendingTrace withPartial(boolean value) {
        if (this.partial == value) {
            return this;
        }
        return new ImmutablePendingTrace(this.transaction, this.slow, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePendingTrace && this.equalTo((ImmutablePendingTrace)another);
    }

    private boolean equalTo(ImmutablePendingTrace another) {
        return this.transaction.equals(another.transaction) && this.slow == another.slow && this.partial == another.partial;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + Booleans.hashCode(this.slow);
        h += (h << 5) + Booleans.hashCode(this.partial);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PendingTrace").omitNullValues().add("transaction", this.transaction).add("slow", this.slow).add("partial", this.partial).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePendingTrace fromJson(Json json) {
        Builder builder = ImmutablePendingTrace.builder();
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.slowIsSet) {
            builder.slow(json.slow);
        }
        if (json.partialIsSet) {
            builder.partial(json.partial);
        }
        return builder.build();
    }

    public static ImmutablePendingTrace copyOf(TraceCollector.PendingTrace instance) {
        if (instance instanceof ImmutablePendingTrace) {
            return (ImmutablePendingTrace)instance;
        }
        return ImmutablePendingTrace.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TraceCollector.PendingTrace", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long INIT_BIT_SLOW = 2L;
        private static final long INIT_BIT_PARTIAL = 4L;
        private long initBits = 7L;
        @Nullable
        private Transaction transaction;
        private boolean slow;
        private boolean partial;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(TraceCollector.PendingTrace instance) {
            Objects.requireNonNull(instance, "instance");
            this.transaction(instance.transaction());
            this.slow(instance.slow());
            this.partial(instance.partial());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transaction(Transaction transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder slow(boolean slow) {
            this.slow = slow;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partial(boolean partial) {
            this.partial = partial;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePendingTrace build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePendingTrace(this.transaction, this.slow, this.partial);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("slow");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("partial");
            }
            return "Cannot build PendingTrace, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TraceCollector.PendingTrace", generator="Immutables")
    static final class Json
    implements TraceCollector.PendingTrace {
        @Nullable
        Transaction transaction;
        boolean slow;
        boolean slowIsSet;
        boolean partial;
        boolean partialIsSet;

        Json() {
        }

        @JsonProperty(value="transaction")
        public void setTransaction(Transaction transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="slow")
        public void setSlow(boolean slow) {
            this.slow = slow;
            this.slowIsSet = true;
        }

        @JsonProperty(value="partial")
        public void setPartial(boolean partial) {
            this.partial = partial;
            this.partialIsSet = true;
        }

        @Override
        public Transaction transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean slow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean partial() {
            throw new UnsupportedOperationException();
        }
    }
}

