/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.glowroot.agent.impl.ImmutableLoadFromFileResult;
import org.glowroot.agent.shaded.com.google.common.base.Charsets;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Iterators;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.PeekingIterator;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.io.Files;
import org.glowroot.agent.shaded.com.google.common.io.LineProcessor;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

public class PreloadSomeSuperTypesCache
extends ScheduledRunnable {
    private static final Logger logger = LoggerFactory.getLogger(PreloadSomeSuperTypesCache.class);
    private final File file;
    private final int maxSize;
    private final Clock clock;
    private final ConcurrentMap<String, CacheValue> cache;
    private volatile int linesInFile;
    private volatile boolean trackAccessTimes;
    private final Set<String> needsToBeWritten = Sets.newConcurrentHashSet();
    private final long accessTimeBackfill;
    private static final AtomicBoolean isWritingFile = new AtomicBoolean();

    public PreloadSomeSuperTypesCache(File file, int maxSize, Clock clock) {
        this.file = file;
        this.maxSize = maxSize;
        this.clock = clock;
        LoadFromFileResult result = PreloadSomeSuperTypesCache.loadFromFile(file);
        this.cache = result.cache();
        this.linesInFile = result.linesInFile();
        this.trackAccessTimes = result.trackAccessTimes();
        this.accessTimeBackfill = clock.currentTimeMillis();
    }

    public void put(String typeName, String superTypeName) {
        if (this.trackAccessTimes) {
            this.putWithTrackAccessTimes(typeName, superTypeName);
        } else {
            this.putWithoutTrackAccessTimes(typeName, superTypeName);
        }
    }

    void putWithTrackAccessTimes(String typeName, String superTypeName) {
        long accessTime = this.clock.currentTimeMillis();
        this.needsToBeWritten.add(typeName);
        CacheValue cacheValue = (CacheValue)this.cache.get(typeName);
        if (cacheValue == null && (cacheValue = this.cache.putIfAbsent(typeName, new CacheValue(accessTime, ImmutableSet.of(superTypeName)))) == null) {
            return;
        }
        cacheValue.accessTime = accessTime;
        cacheValue.addSuperTypeName(superTypeName);
    }

    void putWithoutTrackAccessTimes(String typeName, String superTypeName) {
        CacheValue cacheValue = (CacheValue)this.cache.get(typeName);
        if (cacheValue == null && (cacheValue = this.cache.putIfAbsent(typeName, new CacheValue(0L, ImmutableSet.of(superTypeName)))) == null) {
            this.needsToBeWritten.add(typeName);
            return;
        }
        if (cacheValue.addSuperTypeName(superTypeName)) {
            this.needsToBeWritten.add(typeName);
        }
    }

    Set<String> get(String typeName) {
        CacheValue cacheValue = (CacheValue)this.cache.get(typeName);
        if (cacheValue == null) {
            return ImmutableSet.of();
        }
        if (this.trackAccessTimes) {
            cacheValue.accessTime = this.clock.currentTimeMillis();
            this.needsToBeWritten.add(typeName);
        }
        return cacheValue.superTypeNames;
    }

    @Override
    protected void runInternal() throws Exception {
        if (this.needsToBeWritten.size() > 10) {
            this.writeToFileAsync();
        }
    }

    int size() {
        return this.cache.size();
    }

    private void writeToFileAsync() {
        if (isWritingFile.compareAndSet(false, true)) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PreloadSomeSuperTypesCache.this.writeToFile();
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                    isWritingFile.set(false);
                }
            });
            thread.setName("Glowroot-Preload-Some-Super-Types-Cache-Writer");
            thread.start();
        }
    }

    void writeToFile() throws FileNotFoundException, IOException {
        if (this.linesInFile + this.needsToBeWritten.size() > this.maxSize) {
            if (this.cache.size() > this.maxSize) {
                this.truncateCache();
                this.trackAccessTimes = true;
            }
            this.writeAllToFile();
        } else {
            this.appendNewLinesToFile();
        }
        this.needsToBeWritten.clear();
    }

    private void truncateCache() {
        int cacheSize = this.cache.size();
        long[] accessTimes = new long[cacheSize];
        Iterator i = this.cache.values().iterator();
        int j = 0;
        while (i.hasNext() && j < accessTimes.length) {
            accessTimes[j++] = ((CacheValue)i.next()).accessTime;
        }
        Arrays.sort(accessTimes);
        int keepCount = this.maxSize * 8 / 10;
        long threshold = accessTimes[accessTimes.length - keepCount - 1];
        Iterator k = this.cache.entrySet().iterator();
        int removeCount = 0;
        while (k.hasNext()) {
            if (((CacheValue)k.next().getValue()).accessTime > threshold) continue;
            k.remove();
            if (cacheSize - ++removeCount != keepCount) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllToFile() throws FileNotFoundException, IOException {
        try (BufferedWriter out = Files.newWriter(this.file, Charsets.UTF_8);){
            int lineCount = 0;
            for (Map.Entry entry : this.cache.entrySet()) {
                this.writeLine(out, (String)entry.getKey(), (CacheValue)entry.getValue());
                ++lineCount;
            }
            this.linesInFile = lineCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendNewLinesToFile() throws FileNotFoundException, IOException {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), Charsets.UTF_8));){
            int lineCount = 0;
            for (String typeName : this.needsToBeWritten) {
                CacheValue cacheValue = (CacheValue)Preconditions.checkNotNull(this.cache.get(typeName));
                this.writeLine(out, typeName, cacheValue);
                ++lineCount;
            }
            this.linesInFile += lineCount;
        }
    }

    private void writeLine(BufferedWriter out, String typeName, CacheValue cacheValue) throws IOException {
        if (this.trackAccessTimes) {
            long accessTime = cacheValue.accessTime;
            if (accessTime == 0L) {
                accessTime = this.accessTimeBackfill;
            }
            out.write(Long.toString(accessTime));
            out.write(",");
        }
        out.write(typeName);
        for (String superTypeName : cacheValue.superTypeNames) {
            out.write(",");
            out.write(superTypeName);
        }
        out.write("\n");
    }

    private static LoadFromFileResult loadFromFile(File file) {
        ConcurrentMap<String, CacheValue> cache = Maps.newConcurrentMap();
        if (file.exists()) {
            try {
                return Files.readLines(file, Charsets.UTF_8, new LoadFromFile(file));
            }
            catch (IOException e) {
                logger.error("error reading {}: {}", file.getAbsolutePath(), e.getMessage(), e);
            }
        }
        return ImmutableLoadFromFileResult.builder().cache(cache).linesInFile(0).trackAccessTimes(false).build();
    }

    private static class LoadFromFile
    implements LineProcessor<LoadFromFileResult> {
        private final File file;
        private final ConcurrentMap<String, CacheValue> cache = Maps.newConcurrentMap();
        private int linesInFile;
        @Nullable
        private Boolean hasAccessTimes;
        private final Splitter splitter = Splitter.on(',').trimResults().omitEmptyStrings();
        private boolean errorLogged;

        private LoadFromFile(File file) {
            this.file = file;
        }

        @Override
        public boolean processLine(String line) {
            PeekingIterator<String> i = Iterators.peekingIterator(this.splitter.split(line).iterator());
            try {
                ++this.linesInFile;
                if (this.hasAccessTimes == null) {
                    char c = i.peek().charAt(0);
                    this.hasAccessTimes = c >= '0' && c <= '9';
                }
                long accessTime = this.hasAccessTimes != false ? Long.parseLong(i.next()) : 0L;
                String typeName = i.next();
                CacheValue cacheValue = new CacheValue(accessTime, ImmutableSet.copyOf(i));
                this.cache.put(typeName, cacheValue);
            }
            catch (Exception e) {
                if (!this.errorLogged) {
                    logger.error("error parsing {}: {}", this.file.getAbsolutePath(), e.getMessage(), e);
                }
                this.errorLogged = true;
            }
            return true;
        }

        @Override
        public LoadFromFileResult getResult() {
            return ImmutableLoadFromFileResult.builder().cache(this.cache).linesInFile(this.linesInFile).trackAccessTimes(this.hasAccessTimes != null && this.hasAccessTimes != false).build();
        }
    }

    static class CacheValue {
        private volatile long accessTime;
        private volatile ImmutableSet<String> superTypeNames;

        private CacheValue(long accessTime, ImmutableSet<String> superTypeNames) {
            this.accessTime = accessTime;
            this.superTypeNames = superTypeNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSuperTypeName(String superTypeName) {
            if (this.superTypeNames.contains(superTypeName)) {
                return false;
            }
            if (this.superTypeNames.size() > 10) {
                return false;
            }
            CacheValue cacheValue = this;
            synchronized (cacheValue) {
                this.superTypeNames = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.superTypeNames)).add(superTypeName)).build();
            }
            return true;
        }
    }

    @Value.Immutable
    static interface LoadFromFileResult {
        public ConcurrentMap<String, CacheValue> cache();

        public int linesInFile();

        public boolean trackAccessTimes();
    }
}

