/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import org.glowroot.agent.model.ImmutableTimerNameImpl;
import org.glowroot.agent.model.TimerNameImpl;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class TimerNameCache {
    public static final String AUXILIARY_THREAD_ROOT_TIMER_NAME = "auxiliary thread";
    private static final Logger logger = LoggerFactory.getLogger(TimerNameCache.class);
    private final LoadingCache<String, TimerNameImpl> names = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<String, TimerNameImpl>(){

        @Override
        public TimerNameImpl load(String name) {
            return ImmutableTimerNameImpl.of(name, false);
        }
    });
    private final TimerName unknownTimerName = this.names.getUnchecked("unknown");
    private final TimerName auxThreadTimerName = this.names.getUnchecked("auxiliary thread");

    public TimerName getTimerName(Class<?> adviceClass) {
        if (adviceClass == null) {
            logger.error("getTimerName(): argument 'adviceClass' must be non-null");
            return this.unknownTimerName;
        }
        Pointcut pointcut = adviceClass.getAnnotation(Pointcut.class);
        if (pointcut == null) {
            logger.warn("advice has no @Pointcut: {}", (Object)adviceClass.getName());
            return this.unknownTimerName;
        }
        if (pointcut.timerName().isEmpty()) {
            logger.warn("advice @Pointcut has no timerName() attribute: {}", (Object)adviceClass.getName());
            return this.unknownTimerName;
        }
        return this.getName(pointcut.timerName());
    }

    TimerName getTimerName(String name) {
        if (name == null) {
            logger.error("getTimerName(): argument 'name' must be non-null");
            return this.unknownTimerName;
        }
        return this.getName(name);
    }

    TimerName getAuxThreadTimerName() {
        return this.auxThreadTimerName;
    }

    private TimerName getName(String name) {
        return this.names.getUnchecked(name);
    }
}

