/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.bytecode.api.BytecodeServiceHolder;
import org.glowroot.agent.bytecode.api.ThreadContextPlus;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.impl.NopTransactionService;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.AsyncTimer;
import org.glowroot.agent.model.DetailMapWriter;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.model.QueryEntryBase;
import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.internal.ReadableMessage;
import org.glowroot.agent.plugin.api.internal.ReadableQueryMessage;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Tickers;

class TraceEntryImpl
extends QueryEntryBase
implements AsyncQueryEntry,
Timer {
    private static final Logger logger = LoggerFactory.getLogger(TraceEntryImpl.class);
    private static final Ticker ticker = Tickers.getTicker();
    private final ThreadContextImpl threadContext;
    private final @Nullable TraceEntryImpl parentTraceEntry;
    private final @Nullable Object messageSupplier;
    private volatile @Nullable ErrorMessage errorMessage;
    private final long startTick;
    private long revisedStartTick;
    private int selfNestingLevel;
    private long endTick;
    private boolean initialComplete;
    private @Nullable TraceEntryImpl nextTraceEntry;
    private final @Nullable TimerImpl syncTimer;
    private final @Nullable AsyncTimer asyncTimer;
    private @Nullable ImmutableList<StackTraceElement> locationStackTrace;
    private long locationStackTraceThreshold;
    private @Nullable TimerImpl extendedTimer;

    static TraceEntryImpl createCompletedErrorEntry(ThreadContextImpl threadContext, TraceEntryImpl parentTraceEntry, @Nullable Object messageSupplier, @Nullable QueryData queryData, ErrorMessage errorMessage, long startTick, long endTick) {
        TraceEntryImpl entry = new TraceEntryImpl(threadContext, parentTraceEntry, messageSupplier, queryData, -1L, startTick, null, null);
        entry.errorMessage = errorMessage;
        entry.endTick = endTick;
        entry.selfNestingLevel = 0;
        entry.initialComplete = true;
        return entry;
    }

    TraceEntryImpl(ThreadContextImpl threadContext, @Nullable TraceEntryImpl parentTraceEntry, @Nullable Object messageSupplier, @Nullable QueryData queryData, long queryExecutionCount, long startTick, @Nullable TimerImpl syncTimer, @Nullable AsyncTimer asyncTimer) {
        super(queryData, startTick, queryExecutionCount);
        this.threadContext = threadContext;
        this.parentTraceEntry = parentTraceEntry;
        this.messageSupplier = messageSupplier;
        this.startTick = startTick;
        this.syncTimer = syncTimer;
        this.asyncTimer = asyncTimer;
        this.revisedStartTick = startTick;
        this.selfNestingLevel = 1;
    }

    @Override
    public @Nullable Object getMessageSupplier() {
        return this.messageSupplier;
    }

    @Nullable ErrorMessage getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable List<StackTraceElement> getLocationStackTrace() {
        return this.locationStackTrace;
    }

    void accept(int depth, long transactionStartTick, long captureTick, Transaction.TraceEntryVisitor entryVisitor, SharedQueryTextCollection sharedQueryTextCollection) {
        boolean active;
        long durationNanos;
        long offsetNanos = this.startTick - transactionStartTick;
        if (this.isCompleted() && Tickers.lessThanOrEqual(this.endTick, captureTick)) {
            durationNanos = this.endTick - this.revisedStartTick;
            active = false;
        } else {
            durationNanos = Math.max(captureTick - this.revisedStartTick, 0L);
            active = true;
        }
        Object messageSupplier = this.getMessageSupplier();
        TraceOuterClass.Trace.Entry.Builder builder = TraceOuterClass.Trace.Entry.newBuilder().setDepth(depth).setStartOffsetNanos(offsetNanos).setDurationNanos(durationNanos).setActive(active);
        if (messageSupplier instanceof MessageSupplier) {
            ReadableMessage readableMessage = (ReadableMessage)((Object)((MessageSupplier)messageSupplier).get());
            builder.setMessage(readableMessage.getText());
            builder.addAllDetailEntry(DetailMapWriter.toProto(readableMessage.getDetail()));
        } else if (messageSupplier instanceof QueryMessageSupplier) {
            String queryText = Preconditions.checkNotNull(this.getQueryText());
            int sharedQueryTextIndex = sharedQueryTextCollection.getSharedQueryTextIndex(queryText);
            ReadableQueryMessage readableQueryMessage = (ReadableQueryMessage)((Object)((QueryMessageSupplier)messageSupplier).get());
            TraceOuterClass.Trace.QueryEntryMessage.Builder queryMessage = TraceOuterClass.Trace.QueryEntryMessage.newBuilder().setSharedQueryTextIndex(sharedQueryTextIndex).setPrefix(readableQueryMessage.getPrefix());
            String rowCountSuffix = this.getRowCountSuffix();
            if (rowCountSuffix.isEmpty()) {
                queryMessage.setSuffix(readableQueryMessage.getSuffix());
            } else {
                queryMessage.setSuffix(readableQueryMessage.getSuffix() + rowCountSuffix);
            }
            builder.setQueryEntryMessage(queryMessage);
            builder.addAllDetailEntry(DetailMapWriter.toProto(readableQueryMessage.getDetail()));
        }
        ErrorMessage errorMessage = this.errorMessage;
        if (errorMessage != null) {
            TraceOuterClass.Trace.Error.Builder errorBuilder = builder.getErrorBuilder();
            errorBuilder.setMessage(errorMessage.message());
            Proto.Throwable throwable = errorMessage.throwable();
            if (throwable != null) {
                errorBuilder.setException(throwable);
            }
            errorBuilder.build();
        }
        if (this.locationStackTrace != null) {
            for (StackTraceElement stackTraceElement : this.locationStackTrace) {
                builder.addLocationStackTraceElementBuilder().setClassName(stackTraceElement.getClassName()).setMethodName(Strings.nullToEmpty(stackTraceElement.getMethodName())).setFileName(Strings.nullToEmpty(stackTraceElement.getFileName())).setLineNumber(stackTraceElement.getLineNumber()).build();
            }
        }
        entryVisitor.visitEntry(builder.build());
    }

    long getStartTick() {
        return this.startTick;
    }

    @Override
    public void end() {
        if (this.initialComplete) {
            return;
        }
        long endTick = ticker.read();
        this.endInternal(endTick, null);
    }

    @Override
    public void endWithLocationStackTrace(long threshold, TimeUnit unit) {
        if (threshold < 0L) {
            logger.error("endWithLocationStackTrace(): argument 'threshold' must be non-negative");
            this.end();
            return;
        }
        this.endWithLocationStackTraceInternal(threshold, unit);
    }

    @Override
    public void endWithError(Throwable t) {
        if (this.initialComplete) {
            return;
        }
        this.endWithErrorInternal(null, t);
    }

    @Override
    public void endWithError(@Nullable String message) {
        if (this.initialComplete) {
            return;
        }
        this.endWithErrorInternal(message, null);
    }

    @Override
    public void endWithError(@Nullable String message, Throwable t) {
        if (this.initialComplete) {
            return;
        }
        this.endWithErrorInternal(message, t);
    }

    @Override
    public void endWithInfo(Throwable t) {
        if (this.initialComplete) {
            return;
        }
        this.endWithErrorInternal(null, t);
    }

    @Override
    public Timer extend() {
        if (this.selfNestingLevel++ == 0) {
            if (this.isAsync()) {
                this.extendAsync();
            } else {
                TimerImpl currentTimer = this.threadContext.getCurrentTimer();
                if (currentTimer == null) {
                    --this.selfNestingLevel;
                    return NopTransactionService.NopTimer.INSTANCE;
                }
                this.extendSync(ticker.read(), currentTimer);
            }
        }
        return this;
    }

    @Override
    public void rowNavigationAttempted() {
        if (!this.threadContext.isCompleted() || !this.threadContext.getTransaction().isCompleted()) {
            super.rowNavigationAttempted();
        }
    }

    @Override
    public void incrementCurrRow() {
        if (!this.threadContext.isCompleted() || !this.threadContext.getTransaction().isCompleted()) {
            super.incrementCurrRow();
        }
    }

    @Override
    public void setCurrRow(long row) {
        if (!this.threadContext.isCompleted() || !this.threadContext.getTransaction().isCompleted()) {
            super.setCurrRow(row);
        }
    }

    private void extendSync(long currTick, TimerImpl currentTimer) {
        Preconditions.checkNotNull(this.syncTimer);
        long priorDurationNanos = this.endTick - this.revisedStartTick;
        this.revisedStartTick = currTick - priorDurationNanos;
        this.extendedTimer = this.syncTimer.extend(currTick, currentTimer);
        this.extendQueryData(currTick);
    }

    @RequiresNonNull(value={"asyncTimer"})
    private void extendAsync() {
        ThreadContextThreadLocal.Holder holder = BytecodeServiceHolder.get().getCurrentThreadContextHolder();
        ThreadContextPlus currThreadContext = holder.get();
        long currTick = ticker.read();
        if (currThreadContext == this.threadContext) {
            this.extendSync(currTick, Preconditions.checkNotNull(this.threadContext.getCurrentTimer()));
        } else {
            this.extendedTimer = null;
            this.extendQueryData(currTick);
        }
        this.asyncTimer.extend(currTick);
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            if (this.isAsync()) {
                this.stopAsync();
            } else {
                this.stopSync(ticker.read());
            }
        }
    }

    private void stopSync(long endTick) {
        this.endTick = endTick;
        Preconditions.checkNotNull(this.extendedTimer).end(endTick);
        this.endQueryData(endTick);
        if (this.locationStackTrace == null && this.locationStackTraceThreshold != 0L && endTick - this.revisedStartTick >= this.locationStackTraceThreshold) {
            StackTraceElement[] locationStackTrace = Thread.currentThread().getStackTrace();
            int index = ThreadContextImpl.getNormalizedStartIndex(locationStackTrace, "stop", 1);
            this.setLocationStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(locationStackTrace).subList(index, locationStackTrace.length));
        }
    }

    @RequiresNonNull(value={"asyncTimer"})
    private void stopAsync() {
        long endTick = ticker.read();
        if (this.extendedTimer == null) {
            this.endQueryData(endTick);
        } else {
            this.stopSync(endTick);
        }
        this.asyncTimer.end(endTick);
    }

    boolean hasLocationStackTrace() {
        return this.locationStackTrace != null;
    }

    void setLocationStackTrace(ImmutableList<StackTraceElement> locationStackTrace) {
        this.locationStackTrace = locationStackTrace;
    }

    ThreadContextImpl getThreadContext() {
        return this.threadContext;
    }

    @Nullable TraceEntryImpl getParentTraceEntry() {
        return this.parentTraceEntry;
    }

    @Nullable TraceEntryImpl getNextTraceEntry() {
        return this.nextTraceEntry;
    }

    void setNextTraceEntry(TraceEntryImpl nextTraceEntry) {
        this.nextTraceEntry = nextTraceEntry;
    }

    boolean isAuxThreadRoot() {
        return this.syncTimer != null && this.syncTimer.getName().equals("auxiliary thread");
    }

    private boolean isCompleted() {
        return this.initialComplete && this.selfNestingLevel == 0;
    }

    @EnsuresNonNullIf(expression={"asyncTimer"}, result=true)
    private boolean isAsync() {
        return this.asyncTimer != null;
    }

    private void endWithLocationStackTraceInternal(long threshold, TimeUnit unit) {
        long thresholdNanos;
        if (this.initialComplete) {
            return;
        }
        if (this.isAsync()) {
            this.endInternal(this.endTick, null);
            return;
        }
        long endTick = ticker.read();
        if (endTick - this.startTick >= (thresholdNanos = unit.toNanos(threshold))) {
            StackTraceElement[] locationStackTrace = Thread.currentThread().getStackTrace();
            int index = ThreadContextImpl.getNormalizedStartIndex(locationStackTrace, "endWithLocationStackTraceInternal", 2);
            this.setLocationStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(locationStackTrace).subList(index, locationStackTrace.length));
        } else {
            this.locationStackTraceThreshold = thresholdNanos;
        }
        this.endInternal(endTick, null);
    }

    private void endWithErrorInternal(@Nullable String message, @Nullable Throwable t) {
        ErrorMessage errorMessage = ErrorMessage.create(message, t, this.threadContext.getTransaction().getThrowableFrameLimitCounter());
        this.endInternal(ticker.read(), errorMessage);
    }

    private void endInternal(long endTick, @Nullable ErrorMessage errorMessage) {
        Preconditions.checkNotNull(this.syncTimer);
        if (this.isAsync()) {
            this.asyncTimer.end(endTick);
        } else {
            this.syncTimer.end(endTick);
        }
        this.endQueryData(endTick);
        this.errorMessage = errorMessage;
        this.endTick = endTick;
        if (this.isAsync()) {
            this.threadContext.getTransaction().memoryBarrierWrite();
        } else {
            --this.selfNestingLevel;
            this.threadContext.popEntry(this, endTick);
        }
        this.initialComplete = true;
    }

    private String getRowCountSuffix() {
        if (!this.isRowNavigationAttempted()) {
            return "";
        }
        long rowCount = this.getRowCount();
        if (rowCount == 1L) {
            return " => 1 row";
        }
        return " => " + rowCount + " rows";
    }

    @Override
    public void stopSyncTimer() {
        Preconditions.checkNotNull(this.syncTimer);
        this.syncTimer.stop();
        --this.selfNestingLevel;
        this.threadContext.popNonRootEntry(this);
    }

    @Override
    public Timer extendSyncTimer(ThreadContext currThreadContext) {
        if (currThreadContext != this.threadContext) {
            return NopTransactionService.NopTimer.INSTANCE;
        }
        Preconditions.checkNotNull(this.syncTimer);
        return this.syncTimer.extend(Preconditions.checkNotNull(this.threadContext.getCurrentTimer()));
    }

    public String toString() {
        if (this.messageSupplier instanceof MessageSupplier) {
            return ((ReadableMessage)((Object)((MessageSupplier)this.messageSupplier).get())).getText();
        }
        if (this.messageSupplier instanceof QueryMessageSupplier) {
            ReadableQueryMessage readableQueryMessage = (ReadableQueryMessage)((Object)((QueryMessageSupplier)this.messageSupplier).get());
            return readableQueryMessage.getPrefix() + Preconditions.checkNotNull(this.getQueryText()) + readableQueryMessage.getSuffix();
        }
        if (this.errorMessage != null) {
            return this.errorMessage.message();
        }
        return Preconditions.checkNotNull(super.toString());
    }
}

